/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.core;

import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class EventConfig {
    private static Properties props;
    private static final Logger logger;
    private static final String EAS_DEPLOY = "eas.deploy";
    private final String CONFIGFILE_NAME = "eventconfig.properties";
    private static EventConfig config;
    private int eventProcessorNum = 2;
    private long timeout = Long.MAX_VALUE;
    private boolean isBufferMode = true;
    private int threadSemaphore = 10;
    private String eventJarFilePath = "";
    private int queueMaxRollbackRetryTimes = 3;
    private boolean persistence = false;
    private String driverClass;
    private String dbUrl;
    private String dbUser;
    private String dbPass;
    private Integer maxActivityConnectionNum;
    private Integer maxIdleConnectionNum;
    private Long maxWaitConnectionNum;
    private String dyanmicEventSubscribeFileName;

    public String getDyanmicEventSubscribeFileName() {
        return this.dyanmicEventSubscribeFileName;
    }

    public void setDyanmicEventSubscribeFileName(String dyanmicEventSubscribeFileName) {
        this.dyanmicEventSubscribeFileName = dyanmicEventSubscribeFileName;
    }

    public boolean isPersistence() {
        return this.persistence;
    }

    public String getDbPass() {
        return this.dbPass;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public Integer getMaxActivityConnectionNum() {
        return this.maxActivityConnectionNum;
    }

    public Integer getMaxIdleConnectionNum() {
        return this.maxIdleConnectionNum;
    }

    public Long getMaxWaitConnectionNum() {
        return this.maxWaitConnectionNum;
    }

    public String getEventJarFilePath() {
        return this.eventJarFilePath;
    }

    public int getQueueMaxRollbackRetryTimes() {
        return this.queueMaxRollbackRetryTimes;
    }

    public void setQueueMaxRollbackRetryTimes(int maxRollbackRetryTimes) {
        this.queueMaxRollbackRetryTimes = maxRollbackRetryTimes;
    }

    public void setEventJarFilePath(String eventJarFilePath) {
        this.eventJarFilePath = eventJarFilePath;
    }

    public int getThreadSemaphore() {
        return this.threadSemaphore;
    }

    public void setThreadSemaphore(int threadSemaphore) {
        this.threadSemaphore = threadSemaphore;
    }

    public boolean isBufferMode() {
        return this.isBufferMode;
    }

    public void setBufferMode(boolean isBufferMode) {
        this.isBufferMode = isBufferMode;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getEventProcessorNum() {
        return this.eventProcessorNum;
    }

    public void setEventProcessorNum(int eventProcessorNum) {
        this.eventProcessorNum = eventProcessorNum;
    }

    private EventConfig() {
        props = new Properties();
        this.loadConfigFile();
        this.initConfig();
    }

    public static EventConfig getInstance() {
        return config;
    }

    private void initConfig() {
        if (!StringUtils.isEmpty((String)this.getProperty("eventProcessorNum"))) {
            this.eventProcessorNum = new Integer(this.getProperty("eventProcessorNum"));
        }
        if (!StringUtils.isEmpty((String)this.getProperty("isBufferMode"))) {
            this.isBufferMode = Boolean.valueOf(this.getProperty("isBufferMode"));
        }
        if (!StringUtils.isEmpty((String)this.getProperty("threadSemaphore"))) {
            this.threadSemaphore = new Integer(this.getProperty("threadSemaphore"));
        }
        if (!StringUtils.isEmpty((String)this.getProperty("eventJarFilePath"))) {
            this.eventJarFilePath = this.getProperty("eventJarFilePath");
        }
        if (!StringUtils.isEmpty((String)this.getProperty("persistence"))) {
            this.persistence = Boolean.valueOf(this.getProperty("persistence"));
        }
        if (!StringUtils.isEmpty((String)this.getProperty("dbDriverClass"))) {
            this.driverClass = this.getPathProperty("dbDriverClass");
        }
        if (!StringUtils.isEmpty((String)this.getProperty("dbUrl"))) {
            this.dbUrl = this.getProperty("dbUrl");
        }
        if (!StringUtils.isEmpty((String)this.getProperty("dbUser"))) {
            this.dbUser = this.getProperty("dbUser");
        }
        if (!StringUtils.isEmpty((String)this.getProperty("dbPass"))) {
            this.dbPass = this.getProperty("dbPass");
        }
        if (!StringUtils.isEmpty((String)this.getProperty("maxActiveConnectionNum"))) {
            this.maxActivityConnectionNum = new Integer(this.getProperty("maxActiveConnectionNum"));
        }
        if (!StringUtils.isEmpty((String)this.getProperty("MaxIdleConnectionNum"))) {
            this.maxIdleConnectionNum = new Integer(this.getProperty("MaxIdleConnectionNum"));
        }
        if (!StringUtils.isEmpty((String)this.getProperty("MaxWaitConnectionNum"))) {
            this.maxWaitConnectionNum = new Long(this.getProperty("MaxWaitConnectionNum"));
        }
        if (!StringUtils.isEmpty((String)this.getPathProperty("dyanmicEventSubscribeFileName"))) {
            this.dyanmicEventSubscribeFileName = this.getPathProperty("dyanmicEventSubscribeFileName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigFile() {
        InputStream in = null;
        String deployDir = System.getProperty(EAS_DEPLOY);
        if (!StringUtils.isEmpty((String)deployDir)) {
            String configFilePath = deployDir + "/" + "eventconfig.properties";
            try {
                in = new FileInputStream(new File(configFilePath));
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("FileNotFoundException:error occurs during load event configuration...,can't find " + configFilePath), (Throwable)e);
            }
        }
        if (in == null) {
            String defaultPath = "/eventconfig.properties";
            in = EventConfig.class.getResourceAsStream(defaultPath);
        }
        if (in != null) {
            try {
                props.load(in);
            }
            catch (Exception e) {
                logger.fatal((Object)"error occurs during load system configuration...", (Throwable)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        } else {
            logger.fatal((Object)"config.properties not found. Please make sure the file is in the classpath");
        }
    }

    public String getProperty(String key) {
        return props.getProperty(key, "");
    }

    public String getPathProperty(String key) {
        String s = props.getProperty(key, "");
        s = s.replace('/', File.separator.charAt(0));
        return s;
    }

    public static void main(String[] args) {
        EventConfig.getInstance();
    }

    static {
        logger = Logger.getLogger(EventConfig.class);
        config = new EventConfig();
    }
}

