/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.core;

import com.kingdee.bos.event.CommonEvent;
import com.kingdee.bos.event.SystemEntironment;
import com.kingdee.bos.event.core.EventConfig;
import com.kingdee.bos.event.core.EventProcessor;
import com.kingdee.bos.event.core.queue.EventQueue;
import com.kingdee.bos.event.core.queue.EventQueueFactory;
import com.kingdee.bos.event.core.queue.EventReceiveQueueListener;
import com.kingdee.bos.event.exception.EventServerException;
import com.kingdee.bos.event.model.EventRepositoryService;
import com.kingdee.bos.event.model.IEventRepositoryService;
import com.kingdee.bos.event.storer.StorerManager;
import com.kingdee.bos.event.subscribe.DispatcherManager;
import com.kingdee.bos.event.util.ServerUtils;
import com.kingdee.bos.util.ThreadPool;
import com.kingdee.bos.util.backport.concurrent.ConcurrentHashMap;
import com.kingdee.util.objbuddy.BuddyObjectFactory;
import com.kingdee.util.objbuddy.IBuddyObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class EventServer {
    private static final Logger logger = Logger.getLogger(EventServer.class);
    private String name = "";
    private String host = null;
    private String ip = null;
    private Date createdDate = null;
    private ThreadPool threadPool = null;
    private EventConfig config = null;
    private EventQueue eventQueue = null;
    private StorerManager storerManager = null;
    private IEventRepositoryService repositoryService = null;
    private DispatcherManager dispatcherManager = null;
    private static ConcurrentHashMap serverMap = new ConcurrentHashMap();
    private Map processors = null;
    private boolean isRunning = false;
    private final IBuddyObject buddy;

    public DispatcherManager getDispatcherManager() {
        return this.dispatcherManager;
    }

    public void setDispatcherManager(DispatcherManager dispatcherManager) {
        this.dispatcherManager = dispatcherManager;
    }

    public IEventRepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(IEventRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public EventConfig getConfig() {
        return this.config;
    }

    public void setConfig(EventConfig config) {
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map getProcessors() {
        return this.processors;
    }

    public void setProcessors(Map processors) {
        this.processors = processors;
    }

    public EventQueue getEventQueue() {
        return this.eventQueue;
    }

    public void setEventQueue(EventQueue queue) {
        this.eventQueue = queue;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    private EventServer(String name) {
        this.name = name;
        this.buddy = BuddyObjectFactory.getInstance((Object)this);
        try {
            this.buddy.initialize();
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
        this.initServer();
    }

    public static synchronized EventServer getServer(String serverKey) {
        EventServer server;
        if (serverMap == null || serverMap.size() <= 0) {
            server = new EventServer(serverKey);
            serverMap.put((Object)serverKey, (Object)server);
        }
        server = (EventServer)serverMap.get((Object)serverKey);
        return server;
    }

    public String getServerKey() {
        return this.host + " | " + this.ip;
    }

    private void initServer() {
        this.host = SystemEntironment.getInstance().getHostName();
        this.ip = SystemEntironment.getInstance().getHostIP();
        this.createdDate = new Date();
        this.config = EventConfig.getInstance();
        this.threadPool = new ThreadPool("EventProcessor Pool", 0, this.config.getThreadSemaphore());
        this.processors = new HashMap();
        this.dispatcherManager = new DispatcherManager(this);
        this.repositoryService = new EventRepositoryService();
        this.startServer();
    }

    private void initProcessor() {
        for (int i = 0; i < this.config.getEventProcessorNum(); ++i) {
            try {
                EventProcessor processor = new EventProcessor(this, "EventProcessor " + i);
                processor.startListen();
                this.processors.put(processor.getName(), processor);
                continue;
            }
            catch (EventServerException e) {
                logger.error((Object)("EventProcessor : " + i + " start Listening EventQueue error!" + (Object)((Object)e)));
            }
        }
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public StorerManager getStorerManager() {
        if (this.storerManager == null) {
            this.storerManager = new StorerManager(this);
        }
        return this.storerManager;
    }

    public void setStorerManager(StorerManager storerManager) {
        this.storerManager = storerManager;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public synchronized void startServer() {
        this.initEventQueue();
        this.initProcessor();
        this.isRunning = true;
        this.buddy.operationPerformed("startServer");
    }

    private void initEventQueue() {
        this.eventQueue = EventQueueFactory.getEventQueue(this.name);
        if (this.storerManager == null) {
            this.storerManager = new StorerManager(this);
        }
        EventReceiveQueueListener listener = new EventReceiveQueueListener(this, this.storerManager.getEventStorer(), EventQueueFactory.isBufferMode());
        this.eventQueue.removeAllListeners();
        this.eventQueue.registerListener(listener, 47);
        this.eventQueue.init();
    }

    public synchronized void stopServer() {
        this.eventQueue.clearListener();
        this.eventQueue = null;
        this.storerManager = null;
        for (Map.Entry entry : this.processors.entrySet()) {
            ((EventProcessor)entry.getValue()).stop();
        }
        this.isRunning = false;
        this.buddy.operationPerformed("stopServer");
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public static void main(String[] args) {
        EventServer server = EventServer.getServer(ServerUtils.generateServerKey());
        server.startServer();
        server.getEventQueue().put(new CommonEvent("test"));
    }
}

