/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.core.launcher;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.core.EventServer;
import com.kingdee.bos.event.core.EventSubscriberRelationUtil;
import com.kingdee.bos.event.core.launcher.IEventLauncher;
import com.kingdee.bos.event.exception.CommonEventException;
import com.kingdee.bos.event.exception.EventRepositoryException;
import com.kingdee.bos.event.model.es.EventSubscribePoint;
import com.kingdee.bos.event.subscribe.EventNotificationException;
import com.kingdee.bos.event.subscribe.ISubscriberInformant;
import com.kingdee.bos.event.subscribe.SubscriberInformantFactory;
import com.kingdee.bos.event.util.ServerUtils;
import org.apache.log4j.Logger;

public class EventLauncher
implements IEventLauncher {
    Logger logger = Logger.getLogger(EventLauncher.class);
    EventServer server = ServerUtils.getEventServer(ServerUtils.generateServerKey());

    @Override
    public boolean filterEvent(ICommonEvent event) throws CommonEventException {
        return false;
    }

    @Override
    public void sendEvent(ICommonEvent event) throws CommonEventException {
        this.logger.debug((Object)("=== EventLauncher sendEvent [" + event.getName() + "  |  " + event.getId() + "]==="));
        if (this.validateEvent(event) && !this.filterEvent(event)) {
            if (this.server == null) {
                throw new CommonEventException("EventLauncher sendEvent Exception: eventServer is null ");
            }
            this.processSyncPushSubsciberEvent(event);
            this.server.getEventQueue().put(event);
        }
    }

    private void processSyncPushSubsciberEvent(ICommonEvent event) throws EventRepositoryException, EventNotificationException {
        EventSubscribePoint[] esps = EventSubscriberRelationUtil.getSubScriberFromEvent(this.server.getRepositoryService(), event, "push", "sync");
        if (esps != null) {
            this.logger.debug((Object)"EventLauncher process Sync/Push Event");
            for (int i = 0; i < esps.length; ++i) {
                EventSubscribePoint subscriber = esps[i];
                ISubscriberInformant si = SubscriberInformantFactory.getSubscriberInformant(subscriber);
                si.informSubscriber(event);
            }
        }
    }

    @Override
    public boolean validateEvent(ICommonEvent event) throws CommonEventException {
        return true;
    }
}

