/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.core.queue;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.core.EventServer;
import com.kingdee.bos.event.core.queue.EventQueue;
import com.kingdee.bos.event.core.queue.EventQueueFactory;
import com.kingdee.bos.event.core.queue.IEventQueueListener;
import com.kingdee.bos.event.core.queue.QueueEvent;
import com.kingdee.bos.event.exception.EventQueueException;
import com.kingdee.bos.event.exception.EventStoreException;
import com.kingdee.bos.event.storer.StorerManager;
import com.kingdee.bos.event.subscribe.EventNotificationException;
import com.kingdee.bos.event.subscribe.ISubscriberInformant;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class EventPushQueueListener
implements IEventQueueListener {
    private static final Logger logger = Logger.getLogger(EventPushQueueListener.class);
    private ISubscriberInformant subscriberInformant;
    private StorerManager storerManager;
    private String subscribeUri;

    public EventPushQueueListener(ISubscriberInformant subscriberInformant, EventServer server) {
        this.subscriberInformant = subscriberInformant;
        this.storerManager = server.getStorerManager();
        this.subscribeUri = subscriberInformant.getSubscribePoint().getDestination();
    }

    @Override
    public void onInit(QueueEvent event) throws EventQueueException {
        ICommonEvent[] objArray = null;
        if (StringUtils.isEmpty((String)this.subscribeUri)) {
            return;
        }
        try {
            String[] eventIds = this.storerManager.getSubscriberStorer().getEventsBySubscribeUri(this.subscribeUri);
            if (eventIds != null && eventIds.length > 0) {
                objArray = this.storerManager.getEventStorer().getEventsByIds(eventIds);
            }
        }
        catch (EventStoreException e) {
            logger.error((Object)e);
            throw new EventQueueException((Throwable)((Object)e));
        }
        if (objArray == null || objArray.length <= 0) {
            return;
        }
        for (int i = 0; i < objArray.length; ++i) {
            EventQueue subscriberQueue = EventQueueFactory.getEventQueue(this.subscribeUri);
            subscriberQueue.setFireEvent(false);
            if (!subscriberQueue.contains(objArray[i])) {
                subscriberQueue.put(objArray[i]);
            }
            subscriberQueue.setFireEvent(true);
        }
    }

    @Override
    public void beforePut(QueueEvent event) throws EventQueueException {
        if (event == null || event.getObj() == null) {
            logger.error((Object)"EventSendQueueListener.beforePut event is Null");
            return;
        }
        if (StringUtils.isEmpty((String)this.subscribeUri)) {
            return;
        }
        ICommonEvent commonEvent = (ICommonEvent)event.getObj();
        try {
            this.storerManager.getSubscriberStorer().storeSubscribeRelation(commonEvent, this.subscribeUri);
        }
        catch (EventStoreException e) {
            throw new EventQueueException((Throwable)((Object)e));
        }
    }

    @Override
    public void afterPut(QueueEvent event) throws EventQueueException {
        if (event == null || event.getObj() == null) {
            return;
        }
        ICommonEvent commonEvent = (ICommonEvent)event.getObj();
        try {
            this.subscriberInformant.informSubscriber(commonEvent);
            EventQueueFactory.getEventQueue(this.subscribeUri).get();
            EventQueueFactory.getEventQueue(this.subscribeUri).commit(event.getObj());
        }
        catch (EventNotificationException e) {
            logger.error((Object)"informSubscriber error,informSubscriber error ", (Throwable)((Object)e));
            EventQueueFactory.getEventQueue(this.subscribeUri).rollback(commonEvent);
        }
    }

    @Override
    public void onCommit(QueueEvent event) throws EventQueueException {
        if (event == null || event.getObj() == null) {
            return;
        }
        ICommonEvent commonEvent = (ICommonEvent)event.getObj();
        try {
            this.storerManager.getSubscriberStorer().deleteRelationByEvent(commonEvent, this.subscribeUri);
        }
        catch (EventStoreException e) {
            throw new EventQueueException((Throwable)((Object)e));
        }
    }

    @Override
    public String afterGet(QueueEvent event) throws EventQueueException {
        return null;
    }

    @Override
    public void afterRollback(QueueEvent event) throws EventQueueException {
    }

    @Override
    public Object beforeGet(QueueEvent event) throws EventQueueException {
        return null;
    }

    @Override
    public void beforeRollback(QueueEvent event) throws EventQueueException {
    }

    @Override
    public void retryFailed(QueueEvent event) throws EventQueueException {
    }

    @Override
    public void setNotInQueue(QueueEvent event) throws EventQueueException {
    }

    @Override
    public void stopRetry(QueueEvent event) throws EventQueueException {
    }
}

