/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.core.queue;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.core.EventServer;
import com.kingdee.bos.event.core.queue.IEventQueueListener;
import com.kingdee.bos.event.core.queue.QueueEvent;
import com.kingdee.bos.event.exception.EventQueueException;
import com.kingdee.bos.event.exception.EventStoreException;
import com.kingdee.bos.event.storer.IEventStorer;
import org.apache.log4j.Logger;

public class EventReceiveQueueListener
implements IEventQueueListener {
    private static final Logger logger = Logger.getLogger(EventReceiveQueueListener.class);
    private boolean isBufferMode = true;
    private IEventStorer itemStorer;
    private EventServer server;

    public EventReceiveQueueListener(EventServer engine, IEventStorer itemStorer) {
        this(engine, itemStorer, true);
    }

    public EventReceiveQueueListener(EventServer server, IEventStorer itemStorer, boolean isBufferMode) {
        this.server = server;
        this.itemStorer = itemStorer;
        this.isBufferMode = isBufferMode;
    }

    @Override
    public void onInit(QueueEvent event) throws EventQueueException {
        if (this.isBufferMode) {
            ICommonEvent[] objArray = null;
            try {
                objArray = this.itemStorer.LookupUnProcessedEvent();
            }
            catch (EventStoreException e) {
                throw new EventQueueException((Throwable)((Object)e));
            }
            if (objArray != null) {
                for (int i = 0; i < objArray.length; ++i) {
                    this.server.getEventQueue().setFireEvent(false);
                    if (!this.server.getEventQueue().contains(objArray[i])) {
                        this.server.getEventQueue().put(objArray[i]);
                    }
                    this.server.getEventQueue().setFireEvent(true);
                }
            }
        }
    }

    @Override
    public void beforePut(QueueEvent event) throws EventQueueException {
        if (event != null && event.getObj() != null) {
            try {
                this.itemStorer.storeEvent((ICommonEvent)event.getObj());
            }
            catch (EventStoreException e) {
                logger.error((Object)("storeEvent error :" + event.getObj().toString()), (Throwable)((Object)e));
                throw new EventQueueException((Throwable)((Object)e));
            }
        }
    }

    @Override
    public Object beforeGet(QueueEvent event) throws EventQueueException {
        ICommonEvent commonEvent = null;
        if (event != null && event.getObj() != null) {
            commonEvent = (ICommonEvent)event.getObj();
        }
        return event;
    }

    @Override
    public String afterGet(QueueEvent event) throws EventQueueException {
        return null;
    }

    @Override
    public void onCommit(QueueEvent event) throws EventQueueException {
        ICommonEvent commonEvent = null;
        if (event != null && event.getObj() != null) {
            try {
                commonEvent = (ICommonEvent)event.getObj();
                this.itemStorer.transferEventToHistory(commonEvent);
            }
            catch (EventStoreException e) {
                throw new EventQueueException((Throwable)((Object)e));
            }
        }
    }

    @Override
    public void afterPut(QueueEvent event) throws EventQueueException {
    }

    @Override
    public void setNotInQueue(QueueEvent event) throws EventQueueException {
    }

    @Override
    public void stopRetry(QueueEvent event) throws EventQueueException {
    }

    @Override
    public void afterRollback(QueueEvent event) throws EventQueueException {
    }

    @Override
    public void beforeRollback(QueueEvent event) throws EventQueueException {
    }

    @Override
    public void retryFailed(QueueEvent event) throws EventQueueException {
    }
}

