/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.core.queue;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.core.queue.Queue;
import com.kingdee.bos.event.subscribe.EventNotificationException;
import com.kingdee.bos.event.subscribe.ISubscriberInformant;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SubscriberQueue
extends Queue {
    Logger logger = Logger.getLogger(SubscriberQueue.class);
    private String name;
    private boolean changed = false;
    private Vector obs;

    public SubscriberQueue(String subscriberName) {
        this.name = subscriberName;
    }

    public synchronized void addObserver(ISubscriberInformant o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!this.obs.contains(o)) {
            this.obs.addElement(o);
        }
    }

    public synchronized void deleteObserver(ISubscriberInformant o) {
        this.obs.removeElement(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(ICommonEvent event) {
        Object[] arrLocal;
        SubscriberQueue subscriberQueue = this;
        synchronized (subscriberQueue) {
            if (!this.changed) {
                return;
            }
            arrLocal = this.obs.toArray();
            this.clearChanged();
        }
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            try {
                ((ISubscriberInformant)arrLocal[i]).informSubscriber(event);
                continue;
            }
            catch (EventNotificationException e) {
                this.logger.error((Object)("SubscriberQueue : " + this.name + "notifyObservers error :" + event.toString()), (Throwable)((Object)e));
            }
        }
    }

    public synchronized void deleteObservers() {
        this.obs.removeAllElements();
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    protected synchronized void eventPuted(ICommonEvent event) {
        this.changed = true;
        this.notifyObservers(event);
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public synchronized int countObservers() {
        return this.obs.size();
    }

    public synchronized boolean containObserver(ISubscriberInformant si) {
        return this.obs.contains(si);
    }

    public void putEvent(ICommonEvent event) {
        super.put(event);
        this.eventPuted(event);
    }

    public ICommonEvent getEvent() {
        return (ICommonEvent)super.get();
    }

    public ICommonEvent getEvent(long timeout) {
        return (ICommonEvent)super.get(timeout);
    }
}

