/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.model;

import com.kingdee.bos.event.adapter.BOSEventMappingConfig;
import com.kingdee.bos.event.adapter.EventMappingInfo;
import com.kingdee.bos.event.exception.EventRepositoryException;
import com.kingdee.bos.event.model.EventResourceManager;
import com.kingdee.bos.event.model.IEventRepositoryService;
import com.kingdee.bos.event.model.ModelFindUtils;
import com.kingdee.bos.event.model.ResourceLocator;
import com.kingdee.bos.event.model.cem.CommonEvent;
import com.kingdee.bos.event.model.es.EventSubscribePoint;
import com.kingdee.bos.event.model.es.EventSubscribePointRelation;
import com.kingdee.bos.event.model.es.EventSubscribePointRelations;
import com.kingdee.bos.event.model.es.EventSubscribePoints;
import com.kingdee.bos.event.model.es.EventSubscribers;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;

public class EventRepositoryService
implements IEventRepositoryService {
    private EventResourceManager resourceManager = this.getResourceManager();

    private EventResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new EventResourceManager();
        }
        return this.resourceManager;
    }

    @Override
    public CommonEvent[] getAllEventModel() throws EventRepositoryException {
        return this.getAllCommonEvents();
    }

    @Override
    public CommonEvent[] getAllCommonEvents() throws EventRepositoryException {
        CommonEvent[] events = null;
        try {
            Map eventMap = this.resourceManager.getAllEventModels();
            events = new CommonEvent[eventMap.size()];
            Iterator iterator = eventMap.entrySet().iterator();
            int index = 0;
            while (iterator.hasNext()) {
                events[index] = (CommonEvent)iterator.next().getValue();
                ++index;
            }
        }
        catch (Exception e) {
            throw new EventRepositoryException("\u83b7\u53d6\u901a\u7528\u4e8b\u4ef6\u5143\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8bbe\u7f6e\u7684\u4e8b\u4ef6\u5143\u4fe1\u606f\u8def\u5f84\u662f\u5426\u6b63\u786e!", e);
        }
        return events;
    }

    @Override
    public EventSubscribePoint[] getAllEventSubscribePoints() throws EventRepositoryException {
        EventSubscribePoint[] esp = null;
        try {
            Map espMap = this.resourceManager.getEventSubscribePoints();
            esp = new EventSubscribePoint[espMap.size()];
            Iterator iterator = espMap.entrySet().iterator();
            int index = 0;
            while (iterator.hasNext()) {
                esp[index] = (EventSubscribePoint)iterator.next().getValue();
                ++index;
            }
        }
        catch (Exception e) {
            throw new EventRepositoryException("EventRepositoryService getAllEventSubscribePoints IOException : ", e);
        }
        return esp;
    }

    @Override
    public EventSubscribePointRelation[] getAllEventSubscriberPointRelations() throws EventRepositoryException {
        EventSubscribePointRelation[] esr = null;
        try {
            Map esrMap = this.resourceManager.getEventSubscriberRelations();
            esr = new EventSubscribePointRelation[esrMap.size()];
            Iterator iterator = esrMap.entrySet().iterator();
            int index = 0;
            while (iterator.hasNext()) {
                esr[index] = (EventSubscribePointRelation)iterator.next().getValue();
                ++index;
            }
        }
        catch (Exception e) {
            throw new EventRepositoryException("EventRepositoryService getAllEventSubscribePoints IOException : ", e);
        }
        return esr;
    }

    @Override
    public CommonEvent getCommonEvent(String eventName) throws EventRepositoryException {
        return this.getCommonEventByCommonEventName(eventName);
    }

    @Override
    public CommonEvent getCommonEventByCommonEventName(String eventName) throws EventRepositoryException {
        CommonEvent ce = null;
        try {
            ce = (CommonEvent)this.resourceManager.getAllEventModels().get(eventName);
        }
        catch (Exception e) {
            throw new EventRepositoryException(e.getMessage(), e);
        }
        return ce;
    }

    @Override
    public CommonEvent getCommonEventByBindingEventSource(String objectName, String bindingEventName) throws EventRepositoryException {
        return null;
    }

    @Override
    public CommonEvent[] getCommonEventsBySubscriberId(String subscribePointId) throws EventRepositoryException {
        if (StringUtils.isEmpty((String)subscribePointId)) {
            throw new EventRepositoryException("getCommonEventsBySubscriberId Args subscribePointId is empty");
        }
        EventSubscribePointRelation[] esrArray = this.getAllEventSubscriberPointRelations();
        List matchedEsprs = this.getMatchedSubscribePointRelationsBySubscribePointId(subscribePointId, esrArray);
        List matchedCommonEvents = this.getMatchedCommonEvents(matchedEsprs);
        return matchedCommonEvents.toArray(new CommonEvent[0]);
    }

    private List getMatchedCommonEvents(List matchedEsprs) throws EventRepositoryException {
        if (matchedEsprs == null) {
            return null;
        }
        ArrayList<CommonEvent> ceList = new ArrayList<CommonEvent>();
        for (EventSubscribePointRelation espr : matchedEsprs) {
            CommonEvent ce;
            if (espr.getRefEventId() == null || (ce = this.getCommonEventByCommonEventId(espr.getRefEventId())) == null) continue;
            ceList.add(ce);
        }
        return ceList;
    }

    public CommonEvent getCommonEventByCommonEventId(String eventId) throws EventRepositoryException {
        return (CommonEvent)this.resourceManager.getAllEventModels().get(eventId);
    }

    private List getMatchedSubscribePointRelationsBySubscribePointId(String subscribePointId, EventSubscribePointRelation[] esrArray) {
        if (subscribePointId == null || esrArray == null) {
            return null;
        }
        ArrayList<EventSubscribePointRelation> matchedList = new ArrayList<EventSubscribePointRelation>();
        for (int i = 0; i < esrArray.length; ++i) {
            EventSubscribePointRelation eventSubscribePointRelation = esrArray[i];
            if (eventSubscribePointRelation.getRefSubscribePointId() == null || !eventSubscribePointRelation.getRefSubscribePointId().equalsIgnoreCase(subscribePointId)) continue;
            matchedList.add(eventSubscribePointRelation);
        }
        return matchedList;
    }

    @Override
    public CommonEvent[] getCommonEventsBySubscriberName(String subscribePointName) throws EventRepositoryException {
        if (StringUtils.isEmpty((String)subscribePointName)) {
            throw new EventRepositoryException("getCommonEventsBySubscriberName Args subscribePointName is empty");
        }
        String subscribePointId = (String)this.resourceManager.getEventSubscribePointName2IDMap().get(subscribePointName);
        return this.getCommonEventsBySubscriberId(subscribePointId);
    }

    @Override
    public EventSubscribePoint getEventSubscribePointByID(String subscribePointId) throws EventRepositoryException {
        if (StringUtils.isEmpty((String)subscribePointId)) {
            throw new EventRepositoryException("getEventSubscribePoint Args eventId is empty");
        }
        EventSubscribePoint esp = null;
        esp = (EventSubscribePoint)this.resourceManager.getEventSubscribePoints().get(subscribePointId);
        return esp;
    }

    @Override
    public EventSubscribePoint getEventSubscribePointByEventSubscribePointName(String eventSubscribePointName) throws EventRepositoryException {
        String espId = (String)this.resourceManager.getEventSubscribePointName2IDMap().get(eventSubscribePointName);
        return this.getEventSubscribePointByID(espId);
    }

    @Override
    public EventSubscribePoint[] getEventSubscribePointsByEvent(CommonEvent eventDef) throws EventRepositoryException {
        if (eventDef == null) {
            throw new EventRepositoryException("getEventSubscribePointsByEvent Args eventDef is empty");
        }
        return this.getEventSubscribePointsByEventID(eventDef.getId());
    }

    public EventSubscribePoint[] getEventSubscribePointsByEventType(CommonEvent eventDef) throws EventRepositoryException {
        return null;
    }

    @Override
    public EventSubscribePoint[] getEventSubscribePointsByEventID(String eventId) throws EventRepositoryException {
        if (StringUtils.isEmpty((String)eventId)) {
            throw new EventRepositoryException("Args eventId is empty");
        }
        EventSubscribePointRelation[] eventSubscribePointRelations = this.getAllEventSubscriberPointRelations();
        List matched = this.getMatchedSubscribePointRelations(eventId, eventSubscribePointRelations);
        List matchedEventSubscribePoint = this.getmatchedSubscribePoints(matched);
        if (matchedEventSubscribePoint == null) {
            return null;
        }
        return matchedEventSubscribePoint.toArray(new EventSubscribePoint[matchedEventSubscribePoint.size()]);
    }

    @Override
    public EventSubscribePoint[] getEventSubscribePointsByEventName(String eventName) throws EventRepositoryException {
        if (StringUtils.isEmpty((String)eventName)) {
            throw new EventRepositoryException("Args eventName is empty");
        }
        CommonEvent commonEvent = this.getCommonEventByCommonEventName(eventName);
        if (commonEvent != null) {
            return this.getEventSubscribePointsByEventID(commonEvent.getId());
        }
        return null;
    }

    private List getMatchedSubscribePointRelations(String eventId, EventSubscribePointRelation[] esprs) {
        ArrayList<EventSubscribePointRelation> matched = new ArrayList<EventSubscribePointRelation>();
        if (esprs != null && esprs.length > 0) {
            for (int i = 0; i < esprs.length; ++i) {
                EventSubscribePointRelation espr = esprs[i];
                if (!espr.getRefEventId().equalsIgnoreCase(eventId)) continue;
                matched.add(espr);
            }
        }
        return matched;
    }

    private List getmatchedSubscribePoints(List matchedEsprs) throws EventRepositoryException {
        if (matchedEsprs == null || matchedEsprs.size() <= 0) {
            return null;
        }
        ArrayList<EventSubscribePoint> matchedSubscribePoints = new ArrayList<EventSubscribePoint>();
        for (int i = 0; i < matchedEsprs.size(); ++i) {
            EventSubscribePoint esp;
            EventSubscribePointRelation espr = (EventSubscribePointRelation)matchedEsprs.get(i);
            if (StringUtils.isEmpty((String)espr.getRefSubscribePointId()) || (esp = this.getEventSubscribePointByID(espr.getRefSubscribePointId())) == null) continue;
            matchedSubscribePoints.add(esp);
        }
        return matchedSubscribePoints;
    }

    public String createEventSubscribePoint(EventSubscribePoint esp, boolean isPersistent) throws EventRepositoryException {
        if (esp == null) {
            throw new EventRepositoryException("createEventSubscribePoint Args esp is empty");
        }
        if (this.resourceManager.getEventSubscribePointName2IDMap().get(esp.getName()) != null) {
            esp.setId((String)this.resourceManager.getEventSubscribePointName2IDMap().get(esp.getName()));
        }
        if (StringUtils.isEmpty((String)esp.getId())) {
            esp.setId(BOSUuid.create((String)"EVTSUBPT").toString());
        }
        if (isPersistent) {
            this.createDynamicEventSubscriber(esp);
        }
        this.resourceManager.getEventSubscribePoints().put(esp.getId(), esp);
        this.resourceManager.getEventSubscribePointName2IDMap().put(esp.getName(), esp.getId());
        return esp.getId();
    }

    public EventSubscribePoint getEventSubscribePointByName(String espName) throws EventRepositoryException {
        if (StringUtils.isEmpty((String)espName)) {
            throw new EventRepositoryException("getEventSubscribePoint Args  espName is empty");
        }
        EventSubscribePoint esp = null;
        String id = (String)this.resourceManager.getEventSubscribePointName2IDMap().get(espName);
        esp = (EventSubscribePoint)this.resourceManager.getEventSubscribePoints().get(id);
        return esp;
    }

    public void deleteEventSubscribePoint(String espID, boolean isPersistent) throws EventRepositoryException {
        if (espID == null) {
            throw new EventRepositoryException("deleteEventSubscriberPoint Args espName is empty");
        }
        EventSubscribePoint esp = this.getEventSubscribePointByID(espID);
        if (isPersistent) {
            this.deleteDynamicEventSubscriber(esp, null);
        }
        this.resourceManager.getEventSubscribePoints().remove(esp.getId());
        this.resourceManager.getEventSubscribePointName2IDMap().remove(esp.getName());
    }

    private String getEventSubcribePointName(EventSubscribePoint esp, EventSubscribePointRelation espr) throws EventRepositoryException {
        if (esp != null) {
            return esp.getName();
        }
        if (espr != null) {
            return this.getEventSubscribePointByID(espr.getRefSubscribePointId()).getName();
        }
        return "";
    }

    private EventSubscribePointRelation getEventSubscribePointRelation(EventSubscribePointRelation espr) throws EventRepositoryException {
        Set set = this.resourceManager.getEventSubscriberRelations().keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            EventSubscribePointRelation relation = (EventSubscribePointRelation)this.resourceManager.getEventSubscriberRelations().get(it.next());
            if (!StringUtils.equalsIgnoreCase((String)relation.getRefSubscribePointId(), (String)espr.getRefSubscribePointId()) || !StringUtils.equalsIgnoreCase((String)relation.getRefEventName(), (String)espr.getRefEventName())) continue;
            return relation;
        }
        return null;
    }

    public String saveEventSubscribe(EventSubscribePoint esp, EventSubscribePointRelation espr, boolean isPersistent) throws EventRepositoryException {
        EventSubscribePointRelation relation;
        if (espr == null) {
            throw new EventRepositoryException("createEventSubscribePointRalation Args espr is empty");
        }
        if (this.resourceManager.getEventName2IDMap().get(espr.getRefEventName()) != null) {
            espr.setRefEventId((String)this.resourceManager.getEventName2IDMap().get(espr.getRefEventName()));
        }
        if ((relation = this.getEventSubscribePointRelation(espr)) != null) {
            espr.setId(relation.getId());
        }
        if (StringUtils.isEmpty((String)espr.getId())) {
            espr.setId(BOSUuid.create((String)"EVTSUBPR").toString());
        }
        if (isPersistent) {
            this.saveDynamicEventSubscriber(esp, espr);
        }
        this.resourceManager.getEventSubscribePoints().put(esp.getId(), esp);
        this.resourceManager.getEventSubscribePointName2IDMap().put(esp.getName(), esp.getId());
        this.resourceManager.getEventSubscriberRelations().put(espr.getId(), espr);
        return espr.getId();
    }

    public EventSubscribePointRelation getEventSubscribePointRelation(String id) throws EventRepositoryException {
        if (StringUtils.isEmpty((String)id)) {
            throw new EventRepositoryException("getEventSubscribePointRelation Args id is empty");
        }
        EventSubscribePointRelation espr = null;
        espr = (EventSubscribePointRelation)this.resourceManager.getEventSubscriberRelations().get(id);
        return espr;
    }

    public void deleteEventSubscribePointRelation(String esrpID, boolean isPersistent) throws EventRepositoryException {
        if (StringUtils.isEmpty((String)esrpID)) {
            throw new EventRepositoryException("deleteEventSubscribePointRelation args esrpID is empty");
        }
        if (isPersistent) {
            EventSubscribePointRelation espr = (EventSubscribePointRelation)this.resourceManager.getEventSubscriberRelations().get(esrpID);
            this.deleteDynamicEventSubscriber(null, espr);
        }
        this.resourceManager.getEventSubscriberRelations().remove(esrpID);
    }

    private void createDynamicEventSubscriber(EventSubscribePoint esp) throws EventRepositoryException {
        try {
            String uri = ResourceLocator.getDyanmicEventSubscribeResoucesURI(esp.getName());
            this.resourceManager.createEventSubscribers(esp, uri);
        }
        catch (IOException e) {
            throw new EventRepositoryException(e);
        }
    }

    private void saveDynamicEventSubscriber(EventSubscribePoint esp, EventSubscribePointRelation espr) throws EventRepositoryException {
        try {
            int index;
            String dyanSubscribeFileURL = ResourceLocator.getDyanmicEventSubscribeResoucesURI(this.getEventSubcribePointName(esp, espr));
            EventSubscribers ess = this.resourceManager.getEventSubscribers(URI.createURI((String)dyanSubscribeFileURL));
            if (esp != null) {
                EventSubscribePoints esps = ess.getEventSubscribePoints();
                index = -1;
                index = ModelFindUtils.findEventSubscribePoint(esps.getEventSubscribePoint(), esp);
                if (index >= 0) {
                    esps.getEventSubscribePoint().remove(index);
                }
                esps.getEventSubscribePoint().add((Object)esp);
                ess.setEventSubscribePoints(esps);
            }
            if (espr != null) {
                EventSubscribePointRelations esprs = ess.getEventSubscribePointRelations();
                index = -1;
                index = ModelFindUtils.findEventSubscribePointRelation(esprs.getEventSubscribePointRelation(), espr);
                if (index >= 0) {
                    esprs.getEventSubscribePointRelation().remove(index);
                }
                esprs.getEventSubscribePointRelation().add((Object)espr);
                ess.setEventSubscribePointRelations(esprs);
            }
            this.resourceManager.updateEventSubscribers(ess, dyanSubscribeFileURL);
        }
        catch (IOException e) {
            throw new EventRepositoryException("EventRepositoryService updateDyanmicEventSubscribePoints IOException : ", e);
        }
    }

    private void deleteDynamicEventSubscriber(EventSubscribePoint esp, EventSubscribePointRelation espr) throws EventRepositoryException {
        try {
            int index;
            String dyanSubscribeFileURL = ResourceLocator.getDyanmicEventSubscribeResoucesURI(this.getEventSubcribePointName(esp, espr));
            EventSubscribers ess = this.resourceManager.getEventSubscribers(URI.createURI((String)dyanSubscribeFileURL));
            if (esp != null) {
                EventSubscribePoints esps = ess.getEventSubscribePoints();
                index = -1;
                index = ModelFindUtils.findEventSubscribePoint(esps.getEventSubscribePoint(), esp);
                if (index >= 0) {
                    esps.getEventSubscribePoint().remove(index);
                }
                ess.setEventSubscribePoints(esps);
            }
            if (espr != null) {
                EventSubscribePointRelations esprs = ess.getEventSubscribePointRelations();
                index = -1;
                index = ModelFindUtils.findEventSubscribePointRelation(esprs.getEventSubscribePointRelation(), espr);
                if (index >= 0) {
                    esprs.getEventSubscribePointRelation().remove(index);
                }
                ess.setEventSubscribePointRelations(esprs);
            }
            this.resourceManager.updateEventSubscribers(ess, dyanSubscribeFileURL);
        }
        catch (IOException e) {
            throw new EventRepositoryException("EventRepositoryService updateDyanmicEventSubscribePoints IOException : ", e);
        }
    }

    @Override
    public void saveCommonEvent(CommonEvent event) throws EventRepositoryException {
        try {
            if (event == null || StringUtils.isEmpty((String)event.getName())) {
                throw new EventRepositoryException("event is empty");
            }
            String uri = ResourceLocator.getDyanmicEventDefResouceURI(event.getName());
            if (this.resourceManager.getEventName2IDMap().get(event.getName()) != null) {
                event.setId((String)this.resourceManager.getEventName2IDMap().get(event.getName()));
                this.resourceManager.updateEventDef(event, uri);
            } else {
                if (event.getId() == null || StringUtils.isEmpty((String)event.getId())) {
                    event.setId(BOSUuid.create((String)"COMMNEVT").toString());
                }
                this.resourceManager.createEventDef(event, uri);
            }
            this.resourceManager.getAllEventModels().put(event.getName(), event);
            this.resourceManager.getEventName2IDMap().put(event.getName(), event.getId());
        }
        catch (Exception e) {
            throw new EventRepositoryException("", e);
        }
    }

    @Override
    public void deleteCommenEvent(String eventName) throws EventRepositoryException {
    }

    @Override
    public void deleteEventMappingInfo(String eventName) throws EventRepositoryException {
        try {
            BOSEventMappingConfig.getInstance().deleteEventMappingInfo(eventName);
        }
        catch (IOException e) {
            throw new EventRepositoryException(e);
        }
    }

    @Override
    public void saveEventMappingInfo(EventMappingInfo eventMappingInfo) throws EventRepositoryException {
        try {
            BOSEventMappingConfig.getInstance().saveEventMappingInfo(eventMappingInfo);
        }
        catch (IOException e) {
            throw new EventRepositoryException(e);
        }
    }

    @Override
    public boolean subscribeEvent(EventSubscribePoint sp, EventSubscribePointRelation espr, boolean isPersistent) throws EventRepositoryException {
        if (this.getEventSubscribePointByName(sp.getName()) == null) {
            this.createEventSubscribePoint(sp, isPersistent);
        }
        this.saveEventSubscribe(sp, espr, isPersistent);
        return true;
    }

    @Override
    public boolean subscribeEvent(EventSubscribePoint sp, EventSubscribePointRelation[] espr, boolean isPersistent) throws EventRepositoryException {
        if (espr != null && espr.length > 0) {
            for (int i = 0; i < espr.length; ++i) {
                this.subscribeEvent(sp, espr[i], isPersistent);
            }
        }
        return true;
    }

    @Override
    public boolean unsubscribeEvent(EventSubscribePoint sp, EventSubscribePointRelation espr, boolean isPersistent) throws EventRepositoryException {
        if (espr.getId() != null && this.getEventSubscribePointRelation(espr.getId()) != null) {
            this.deleteEventSubscribePointRelation(espr.getId(), isPersistent);
        }
        return true;
    }
}

