/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.model;

import com.kingdee.bos.event.core.EventConfig;
import com.kingdee.bos.event.exception.EventRepositoryException;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class ResourceLocator {
    private static final Logger logger = Logger.getLogger(ResourceLocator.class);

    public static String[] getAllResourcesURI() throws IOException, EventRepositoryException {
        String jarFilePath = ResourceLocator.getEventJarFilePath();
        return ResourceLocator.caculateAllResouceUrl(jarFilePath).toArray(new String[0]);
    }

    public static String getDyanmicEventSubscribeResoucesURI(String espName) throws IOException, EventRepositoryException {
        String dyanFileName = ResourceLocator.getDefaultDyanmicResoucePath() + "CES_GEN_" + espName + ".es";
        if (!StringUtils.isEmpty((String)dyanFileName)) {
            return "file:/" + dyanFileName;
        }
        return null;
    }

    public static String getDyanmicEventDefResouceURI(String eventName) {
        String path = ResourceLocator.getDefaultDyanmicResoucePath() + "CES_GEN_" + eventName + ".cem";
        return "file:/" + path;
    }

    private static String getDefaultDyanmicResoucePath() {
        return System.getProperty("EAS_HOME") + "/server/events/";
    }

    private static String getEventJarFilePath() {
        String path = System.getProperty("event.repository");
        if (StringUtils.isEmpty((String)path)) {
            return EventConfig.getInstance().getEventJarFilePath();
        }
        return path;
    }

    public static boolean validateRepository(JarFile file) throws IOException {
        return true;
    }

    private static List caculateAllResouceUrl(String rootPath) {
        ArrayList list = new ArrayList();
        try {
            if (rootPath == null || StringUtils.isEmpty((String)rootPath)) {
                logger.warn((Object)"event.repository root path is empty");
                return list;
            }
            String[] paths = rootPath.split(";");
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                if (path.startsWith("${EAS_HOME}")) {
                    path = System.getProperty("EAS_HOME") + "/" + path.substring(path.lastIndexOf("}") + 1);
                }
                list.addAll(ResourceLocator.caculateResouceUris(path));
            }
        }
        catch (IOException e) {
            logger.warn((Object)"event.repository error");
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List caculateResouceUris(String path) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        if (path != null && !StringUtils.isEmpty((String)path)) {
            File file = new File(path);
            if (file.isDirectory()) {
                String[] files = file.list();
                for (int i = 0; i < files.length; ++i) {
                    list.addAll(ResourceLocator.caculateResouceUris(path + "/" + files[i]));
                }
            }
            if (file.isFile() && file.getName().endsWith(".jar")) {
                try (JarFile jarFile = null;){
                    jarFile = new JarFile(path);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (StringUtils.isEmpty((String)entry.getName()) || !entry.getName().endsWith(".cem") && !entry.getName().endsWith(".es")) continue;
                        String entryUri = "jar:file:" + path + "!/" + entry.getName();
                        list.add(entryUri);
                    }
                }
            }
            if (file.isFile() && (file.getName().endsWith(".cem") || file.getName().endsWith(".es"))) {
                String uri = "file:/" + path;
                list.add(uri);
            }
        }
        return list;
    }
}

