/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.services;

import com.kingdee.bos.ORMRPCObjectFactory;
import com.kingdee.bos.event.services.IServices;
import com.kingdee.bos.orm.IObjectFactory;
import com.kingdee.bos.rpcwrapper.IServer;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.rpcwrapper.ServerManager;
import org.apache.log4j.Logger;

public class ORMRPCService
implements IServices {
    Logger logger = Logger.getLogger(ORMRPCService.class);
    private static final long serialVersionUID = -706344775895225753L;
    private IServer server;
    private int port;
    private IServer sslServer;
    private int sslPort;

    @Override
    public void start() {
        ServerManager sm = ServerManager.getInstance();
        try {
            RPCEngineFactory.registerObjectFactory((IObjectFactory)new ORMRPCObjectFactory());
            this.port = ORMRPCService.getDefaultTCPPort();
            this.server = sm.newTCPServer(this.port);
            if (sm.supportSSL()) {
                this.sslPort = ORMRPCService.getDefaultSSLPort();
                this.sslServer = sm.newSSLServer("ssl", this.sslPort);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"cannot create rpc server", (Throwable)e);
            throw new RuntimeException("cannot create rpc server", e);
        }
        if (this.server != null) {
            this.server.start();
            this.logger.info((Object)("RPC Server[" + this.port + "] started "));
        }
        if (this.sslServer != null) {
            this.sslServer.start();
            this.logger.info((Object)("RPC SSL Server[" + ORMRPCService.getDefaultSSLPort() + "] started "));
        }
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.shutdown();
            this.logger.info((Object)("RPC Server[" + this.port + "] showdown "));
        }
        if (this.sslServer != null) {
            this.sslServer.shutdown();
            this.logger.info((Object)("RPC SSL Server[" + ORMRPCService.getDefaultSSLPort() + "] showdown "));
        }
    }

    private static final int getDefaultTCPPort() {
        return ServerManager.getInstance().getDefaultTCPPort();
    }

    private static final int getDefaultSSLPort() {
        return ServerManager.getInstance().getDefaultSSLPort();
    }
}

