/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.storer;

import com.kingdee.bos.event.core.EventConfig;
import com.kingdee.bos.event.storer.IConnectionManager;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;

public class ConnectionManager
implements IConnectionManager {
    private static IConnectionManager instance = new ConnectionManager();
    BasicDataSource ds = new BasicDataSource();

    private ConnectionManager() {
        EventConfig config = EventConfig.getInstance();
        this.ds.setDriverClassName(config.getDriverClass());
        this.ds.setUrl(config.getDbUrl());
        this.ds.setUsername(config.getDbUser());
        this.ds.setPassword(config.getDbPass());
        if (config.getMaxActivityConnectionNum() != null) {
            this.ds.setMaxActive(config.getMaxActivityConnectionNum().intValue());
        }
        if (config.getMaxIdleConnectionNum() != null) {
            this.ds.setMaxIdle(config.getMaxIdleConnectionNum().intValue());
        }
        if (config.getMaxWaitConnectionNum() != null) {
            this.ds.setMaxWait(config.getMaxWaitConnectionNum().longValue());
        }
    }

    public static IConnectionManager getInstance() {
        return instance;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    @Override
    public void shutdownDataSource() throws SQLException {
        this.ds.close();
    }
}

