/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.storer;

import com.kingdee.bos.event.CommonEvent;
import com.kingdee.bos.event.EventPriority;
import com.kingdee.bos.event.EventSeverity;
import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.core.EventServer;
import com.kingdee.bos.event.exception.EventStoreException;
import com.kingdee.bos.event.exception.EventTransformException;
import com.kingdee.bos.event.storer.AbstractEventStorer;
import com.kingdee.bos.event.storer.CommonEventInfo;
import com.kingdee.bos.event.storer.StorerManager;
import com.kingdee.bos.event.transform.EventTransformerImpl;
import com.kingdee.bos.event.transform.IEventTransformer;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

public class EventStorer
extends AbstractEventStorer {
    IEventTransformer transformer = null;
    private EventServer server;
    private StorerManager manager;
    private boolean persistence = false;
    private static final String EVENTQUEUE_TABLE_NAME = "T_CBE_EventQueue";
    private static final String EVENTQUEUE_TABLE_NAME_HST = "T_CBE_EventQueueHst";
    private static final String EVENTQUEUE_COLUMNS = " FEVENTID,FEVENTNAME,FEVENTDEFID,FTYPE,FVERSION,FGROUP,FHOSTIP,FHOSTNAME,FSOLUTIONNAME,FDATACENTERNAME,FALIAS,FDESCRIPTION,FPRIORITY,FSERVRITY,FSTATUS,FEVENT,FCREATEDTIME,FUPDATEDTIME ";

    public EventStorer(EventServer server, StorerManager manager) {
        this.server = server;
        this.manager = manager;
        this.transformer = new EventTransformerImpl();
        this.persistence = server.getConfig().isPersistence();
    }

    @Override
    public ICommonEvent[] LookupUnProcessedEvent() throws EventStoreException {
        ICommonEvent[] iCommonEventArray;
        if (!this.persistence) {
            return null;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            conn = this.getConnection();
            String sql = "select  FEVENTID,FEVENTNAME,FEVENTDEFID,FTYPE,FVERSION,FGROUP,FHOSTIP,FHOSTNAME,FSOLUTIONNAME,FDATACENTERNAME,FALIAS,FDESCRIPTION,FPRIORITY,FSERVRITY,FSTATUS,FEVENT,FCREATEDTIME,FUPDATEDTIME  from T_CBE_EventQueue where (FSTATUS = ?) order by FCREATEDTIME DESC";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, "unprocess");
            resultSet = stmt.executeQuery();
            iCommonEventArray = this.constructCommonEvent(resultSet);
        }
        catch (SQLException e) {
            try {
                throw new EventStoreException(e);
            }
            catch (Throwable throwable) {
                this.cleanup(resultSet, stmt, conn);
                throw throwable;
            }
        }
        this.cleanup(resultSet, stmt, conn);
        return iCommonEventArray;
    }

    @Override
    public ICommonEvent[] getCommonEvent(String eventName) throws EventStoreException {
        ICommonEvent[] iCommonEventArray;
        if (!this.persistence) {
            return null;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            conn = this.getConnection();
            String sql = "select  FEVENTID,FEVENTNAME,FEVENTDEFID,FTYPE,FVERSION,FGROUP,FHOSTIP,FHOSTNAME,FSOLUTIONNAME,FDATACENTERNAME,FALIAS,FDESCRIPTION,FPRIORITY,FSERVRITY,FSTATUS,FEVENT,FCREATEDTIME,FUPDATEDTIME  from T_CBE_EventQueuewhere (FEVENTNAME = ?) order by FCREATEDTIME DESC";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, eventName);
            resultSet = stmt.executeQuery();
            iCommonEventArray = this.constructCommonEvent(resultSet);
        }
        catch (SQLException e) {
            try {
                throw new EventStoreException(e);
            }
            catch (Throwable throwable) {
                this.cleanup(resultSet, stmt, conn);
                throw throwable;
            }
        }
        this.cleanup(resultSet, stmt, conn);
        return iCommonEventArray;
    }

    @Override
    public ICommonEvent[] getEventsByIds(String[] ids) throws EventStoreException {
        ICommonEvent[] iCommonEventArray;
        if (!this.persistence) {
            return null;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            conn = this.getConnection();
            String sql = "select  FEVENTID,FEVENTNAME,FEVENTDEFID,FTYPE,FVERSION,FGROUP,FHOSTIP,FHOSTNAME,FSOLUTIONNAME,FDATACENTERNAME,FALIAS,FDESCRIPTION,FPRIORITY,FSERVRITY,FSTATUS,FEVENT,FCREATEDTIME,FUPDATEDTIME  from T_CBE_EventQueuewhere (FEVENTID = ?) order by FCREATEDTIME DESC";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, ids[0]);
            resultSet = stmt.executeQuery();
            iCommonEventArray = this.constructCommonEvent(resultSet);
        }
        catch (SQLException e) {
            try {
                throw new EventStoreException(e);
            }
            catch (Throwable throwable) {
                this.cleanup(resultSet, stmt, conn);
                throw throwable;
            }
        }
        this.cleanup(resultSet, stmt, conn);
        return iCommonEventArray;
    }

    private ICommonEvent[] constructCommonEvent(ResultSet rs) throws SQLException, EventStoreException {
        ArrayList<ICommonEvent> list = new ArrayList<ICommonEvent>();
        if (rs != null) {
            while (rs.next()) {
                try {
                    ICommonEvent event = this.transformer.xmlToEvent(rs.getString(16));
                    if (event == null) continue;
                    list.add(event);
                }
                catch (EventTransformException e) {
                    throw new EventStoreException((Throwable)((Object)e));
                }
            }
        }
        return list.toArray(new CommonEvent[0]);
    }

    @Override
    public void storeEvent(ICommonEvent commonEvent) throws EventStoreException {
        this.innerStoreEvent(commonEvent, EVENTQUEUE_TABLE_NAME);
    }

    private void innerStoreEvent(ICommonEvent commonEvent, String tableName) throws EventStoreException {
        if (commonEvent == null || !this.persistence) {
            return;
        }
        CommonEventInfo info = null;
        try {
            info = this.constructCommoneventInfo(commonEvent);
        }
        catch (EventTransformException e1) {
            throw new EventStoreException((Throwable)((Object)e1));
        }
        if (info == null) {
            return;
        }
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            String sql = "insert into " + tableName + "(" + EVENTQUEUE_COLUMNS + ") values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, info.getEventId());
            stmt.setString(2, info.getName());
            stmt.setString(3, info.getEventDefId());
            stmt.setString(4, info.getType());
            stmt.setString(5, info.getVersion());
            stmt.setString(6, info.getGroup());
            stmt.setString(7, info.getHostIp());
            stmt.setString(8, info.getHostName());
            stmt.setString(9, info.getSolutionName());
            stmt.setString(10, info.getDataCenterName());
            stmt.setString(11, info.getAlias());
            stmt.setString(12, info.getDescription());
            stmt.setInt(13, info.getPriority());
            stmt.setInt(14, info.getServrity());
            stmt.setString(15, info.getStatus());
            stmt.setString(16, info.getData());
            stmt.setDate(17, new Date(info.getCreatedTime().getTime()));
            stmt.setDate(18, new Date(info.getUpdatedTime().getTime()));
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new EventStoreException(e);
            }
            catch (Throwable throwable) {
                this.cleanup(resultSet, stmt, connection);
                throw throwable;
            }
        }
        this.cleanup(resultSet, stmt, connection);
    }

    private void innerDeleteEvent(String eventID, String tableName) throws EventStoreException {
        if (StringUtils.isEmpty((String)eventID) || !this.persistence) {
            return;
        }
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            String sql = "delete from " + tableName + " where FEVENTID= ?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, eventID);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new EventStoreException(e);
            }
            catch (Throwable throwable) {
                this.cleanup(resultSet, stmt, connection);
                throw throwable;
            }
        }
        this.cleanup(resultSet, stmt, connection);
    }

    private CommonEventInfo constructCommoneventInfo(ICommonEvent commonEvent) throws EventTransformException {
        if (commonEvent == null || !this.persistence) {
            return null;
        }
        CommonEventInfo info = new CommonEventInfo();
        info.setEventId(commonEvent.getId());
        info.setName(commonEvent.getName());
        info.setEventDefId(commonEvent.getEventDefId());
        info.setType(commonEvent.getEventType());
        info.setVersion(commonEvent.getVersion());
        info.setGroup(commonEvent.getGroup());
        info.setHostIp(commonEvent.getHostIP());
        info.setHostName(commonEvent.getHostName());
        info.setSolutionName(commonEvent.getSolutionName());
        info.setDataCenterName(commonEvent.getDataCenterName());
        info.setAlias(commonEvent.getAlias(new Locale("L2")));
        info.setDescription(commonEvent.getDescription(new Locale("L2")));
        info.setPriority(commonEvent.getPriority() != null ? commonEvent.getPriority().getValue() : EventPriority.MEDIUM.getValue());
        info.setServrity(commonEvent.getSeverity() != null ? commonEvent.getSeverity().getValue() : EventSeverity.INFO.getValue());
        info.setStatus("unprocess");
        info.setCreatedTime(new java.util.Date());
        info.setUpdatedTime(new java.util.Date());
        info.setData(this.transformer.eventToXML(commonEvent));
        return info;
    }

    @Override
    public void transferEventToHistory(ICommonEvent event) throws EventStoreException {
        this.innerStoreEvent(event, EVENTQUEUE_TABLE_NAME_HST);
        this.innerDeleteEvent(event.getId(), EVENTQUEUE_TABLE_NAME);
    }
}

