/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.storer;

import com.kingdee.bos.event.core.EventServer;
import com.kingdee.bos.event.storer.ConnectionManager;
import com.kingdee.bos.event.storer.EventStorer;
import com.kingdee.bos.event.storer.IEventStorer;
import com.kingdee.bos.event.storer.ISubscriberStorer;
import com.kingdee.bos.event.storer.SubscriberStorer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class StorerManager {
    private static final Logger logger = Logger.getLogger(StorerManager.class);
    private EventServer server;
    private volatile IEventStorer eventStorer;
    private volatile ISubscriberStorer subscriberStorer;
    private static int connCount = 0;

    public static int getConnCount() {
        return connCount;
    }

    public EventServer getServer() {
        return this.server;
    }

    public StorerManager(EventServer server) {
        if (server == null) {
            throw new IllegalArgumentException();
        }
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEventStorer getEventStorer() {
        if (this.eventStorer == null) {
            StorerManager storerManager = this;
            synchronized (storerManager) {
                if (this.eventStorer == null) {
                    this.eventStorer = new EventStorer(this.server, this);
                }
            }
        }
        return this.eventStorer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISubscriberStorer getSubscriberStorer() {
        if (this.subscriberStorer == null) {
            StorerManager storerManager = this;
            synchronized (storerManager) {
                if (this.subscriberStorer == null) {
                    this.subscriberStorer = new SubscriberStorer(this.server, this);
                }
            }
        }
        return this.subscriberStorer;
    }

    public static Connection getConnection() throws SQLException {
        ++connCount;
        Connection rtnVal = ConnectionManager.getInstance().getConnection();
        if (rtnVal == null) {
            throw new SQLException("can not get connection.");
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(ResultSet rs, Statement stmt, Connection cn) {
        try {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
        }
        catch (SQLException e) {
            logger.warn((Object)("cleanup connection error. " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (cn != null) {
                --connCount;
                try {
                    cn.close();
                }
                catch (SQLException e) {
                    logger.warn((Object)("cleanup connection error. " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public static void cleanup(Statement stmt, Connection conn) {
        StorerManager.cleanup(null, stmt, conn);
    }

    public static void cleanup(Connection conn) {
        StorerManager.cleanup(null, null, conn);
    }
}

