/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.subscribe.pull;

import com.kingdee.bos.event.CommonEvent;
import com.kingdee.bos.event.core.EventServer;
import com.kingdee.bos.event.core.queue.EventQueue;
import com.kingdee.bos.event.core.queue.EventQueueFactory;
import com.kingdee.bos.event.core.queue.PullSubscriberEventQueue;
import com.kingdee.bos.event.exception.CommonEventException;
import com.kingdee.bos.event.model.EventRepositoryService;
import com.kingdee.bos.event.model.es.EventSubscribePoint;
import com.kingdee.bos.event.subscribe.pull.IIAEventPullSubscriber;
import com.kingdee.bos.event.util.ServerUtils;
import org.apache.log4j.Logger;

public class EventPullSubscriber
implements IIAEventPullSubscriber {
    private static final Logger logger = Logger.getLogger(EventPullSubscriber.class);
    private EventServer server = ServerUtils.getEventServer(ServerUtils.generateServerKey());

    @Override
    public void deleteEvent(String subscriberName, String eventID) throws CommonEventException {
        EventQueue queue;
        logger.debug((Object)("EventPullSubscrber [" + subscriberName + "] consume Event [" + eventID + "]"));
        String destination = this.getSubscriberDestByName(subscriberName);
        if (destination != null && (queue = EventQueueFactory.getPullSubscriberEventQueue(destination)) instanceof PullSubscriberEventQueue) {
            PullSubscriberEventQueue psQueue = (PullSubscriberEventQueue)queue;
            psQueue.get(eventID);
        }
    }

    @Override
    public CommonEvent getEvent(String subscriberName, String eventID) throws CommonEventException {
        EventQueue queue;
        logger.debug((Object)("EventPullSubscrber [" + subscriberName + "]peak Event"));
        CommonEvent ce = null;
        String destination = this.getSubscriberDestByName(subscriberName);
        if (destination != null && (queue = EventQueueFactory.getPullSubscriberEventQueue(destination)) instanceof PullSubscriberEventQueue) {
            PullSubscriberEventQueue psQueue = (PullSubscriberEventQueue)queue;
            ce = psQueue.peak(eventID);
        }
        return ce;
    }

    @Override
    public CommonEvent[] getEventsBySubscriberName(String subscriberName) throws CommonEventException {
        EventQueue queue;
        CommonEvent[] cea = null;
        String destination = this.getSubscriberDestByName(subscriberName);
        if (destination != null && (queue = EventQueueFactory.getPullSubscriberEventQueue(destination)) instanceof PullSubscriberEventQueue) {
            PullSubscriberEventQueue psQueue = (PullSubscriberEventQueue)queue;
            cea = psQueue.peakAll();
        }
        return cea;
    }

    @Override
    public CommonEvent receiveEvent(String subscriberName) throws CommonEventException {
        logger.debug((Object)("EventPullSubscrber [" + subscriberName + "] receive/consume Event "));
        String destination = this.getSubscriberDestByName(subscriberName);
        if (destination != null) {
            EventQueue queue = EventQueueFactory.getPullSubscriberEventQueue(destination);
            return (CommonEvent)queue.get();
        }
        return null;
    }

    private String getSubscriberDestByName(String espName) throws CommonEventException {
        try {
            EventRepositoryService srv = (EventRepositoryService)this.server.getRepositoryService();
            EventSubscribePoint esp = srv.getEventSubscribePointByName(espName);
            if (esp != null) {
                return esp.getDestination();
            }
        }
        catch (Exception e) {
            throw new CommonEventException(e);
        }
        return null;
    }
}

