/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.remote;

import com.kingdee.bos.kscript.debug.DebugEnv;
import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.debug.IDebugProvider;
import com.kingdee.bos.kscript.debug.IDebugRuntime;
import com.kingdee.bos.kscript.debug.IStackElement;
import com.kingdee.bos.kscript.debug.IValue;
import com.kingdee.bos.util.lightremote.RemoteContext;
import java.net.Socket;

public class DebugRemoteContext
extends RemoteContext {
    public static final String REMOTE_DEBUGER = "_remote_debuger_";
    IDebugRuntime env = null;

    public DebugRemoteContext(String address) throws Exception {
        super(address);
        this.initRemoteClasses();
    }

    public DebugRemoteContext(Socket sock) throws Exception {
        super(sock);
        this.initRemoteClasses();
    }

    private void initRemoteClasses() {
        super.registerRemoteClass(IValue.class);
        super.registerRemoteClass(IDebugContext.class);
        super.registerRemoteClass(IDebugRuntime.class);
        super.registerRemoteClass(IDebugProvider.class);
        super.registerRemoteClass(IStackElement.class);
    }

    @Override
    protected void finalClose() throws Exception {
        if (this.env != null) {
            this.env.terminate();
        }
    }

    @Override
    protected Object createServerObject(String className, Class model, Class[] types, Object[] args) throws Exception {
        if (className.equals(REMOTE_DEBUGER) && model == IDebugRuntime.class) {
            IDebugProvider p = (IDebugProvider)args[0];
            this.env = DebugEnv.registerDebuger(p);
            return this.env;
        }
        throw new UnsupportedOperationException("createObject(" + className + ")");
    }

    @Override
    protected boolean handShake() throws Exception {
        return true;
    }

    public static IDebugRuntime createRemoteDebugEnv(IDebugProvider provider, String address) throws Exception {
        DebugRemoteContext x = new DebugRemoteContext(address);
        x.startServiceLoop();
        IDebugRuntime env = (IDebugRuntime)x.createObject(REMOTE_DEBUGER, IDebugRuntime.class, new Class[]{IDebugProvider.class}, new Object[]{provider});
        return env;
    }
}

