/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.ui;

import com.kingdee.bos.kscript.debug.ui.ChangedListener;
import com.kingdee.bos.kscript.debug.ui.DebugManager;
import com.kingdee.bos.kscript.debug.ui.DebugUI;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class ConnectionsPanel
extends JScrollPane {
    static final Logger logger = Logger.getLogger(ConnectionsPanel.class);
    public final DebugUI main;
    public JList list = new JList();

    public ConnectionsPanel(DebugUI main) {
        this.main = main;
        this.setViewportView(this.list);
        main.getDebugManager().addChangedListener(new ChangedListener(){

            @Override
            public void notifyChanged(Object source, Object args) {
                ConnectionsPanel.this.refresh();
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    ConnectionsPanel.this.showPopupMenu(e);
                }
            }
        });
        this.refresh();
    }

    private void showPopupMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu("Actions");
        menu.add(new AbstractAction("Connect Remote..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionsPanel.this.main.connectRemote();
            }
        });
        menu.addSeparator();
        final DebugManager.Element x = (DebugManager.Element)this.list.getSelectedValue();
        String action = "Disconnect";
        if (x != null) {
            action = action + " " + x.name;
        }
        JMenuItem m = menu.add(new AbstractAction(action){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (x != null && !x.isLocal()) {
                    x.localClose = true;
                    ConnectionsPanel.this.main.disableExceptionHandler = true;
                    ConnectionsPanel.this.main.debugManager.disableEvent = true;
                    try {
                        ConnectionsPanel.this.main.debugManager.unlistDebug(x.runtime);
                        ConnectionsPanel.this.main.removeDebug(null);
                        ConnectionsPanel.this.refresh();
                    }
                    catch (Exception ex) {
                        logger.debug((Object)ex, (Throwable)ex);
                    }
                    finally {
                        ConnectionsPanel.this.main.disableExceptionHandler = false;
                        ConnectionsPanel.this.main.debugManager.disableEvent = false;
                    }
                }
            }
        });
        m.setEnabled(x != null && !x.isLocal());
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    public void refresh() {
        try {
            DebugManager.Element[] ar = this.main.getDebugManager().getRuntimes();
            this.list.setListData(ar);
        }
        catch (Exception ex) {
            this.main.handleException(ex);
        }
    }
}

