/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.ui;

import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.debug.IValue;
import com.kingdee.bos.kscript.debug.ui.DebugUI;
import com.kingdee.bos.kscript.debug.ui.DefaultEditMenu;
import com.kingdee.bos.kscript.debug.ui.Props;
import com.kingdee.bos.kscript.debug.ui.SourcePage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class EvalDialog
extends JDialog {
    static final Props props = DebugUI.props;
    private JTextArea text;
    private DefaultEditMenu editMenu;
    private DefaultEditMenu editMenu2;
    private JButton btnEval = new JButton("Eval");
    private JButton btnClose = new JButton("Close");
    private JTextField result = new JTextField();
    public SourcePage page;

    public EvalDialog(SourcePage page) {
        super(page.sourcePanel.debugPanel.uiMain, "Eval Script", true);
        this.page = page;
        this.text = new JTextArea(props.get(page.getName() + ".evalScript"));
        this.getContentPane().setLayout(null);
        this.setResizable(false);
        JScrollPane sp = new JScrollPane(this.text);
        this.getContentPane().add(sp);
        this.getContentPane().add(this.btnEval);
        this.getContentPane().add(this.btnClose);
        this.getContentPane().add(this.result);
        JLabel l = new JLabel("Sciprt:");
        l.setBounds(10, 10, 200, 24);
        this.getContentPane().add(l);
        sp.setBounds(10, 40, 400, 200);
        l = new JLabel("Result:");
        l.setBounds(10, 250, 100, 24);
        this.getContentPane().add(l);
        this.result.setBounds(l.getX() + l.getWidth(), l.getY(), 300, l.getHeight());
        this.btnEval.setBounds(60, 290, 120, 30);
        this.btnClose.setBounds(240, 290, 120, 30);
        this.pack();
        this.setSize(430, 360);
        props.traceComponent("evalDialog", this);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EvalDialog.this.saveChanges();
                EvalDialog.this.setVisible(false);
            }
        });
        this.btnEval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EvalDialog.this.eval();
            }
        });
        this.editMenu = new DefaultEditMenu("script", this.text, true);
        this.editMenu2 = new DefaultEditMenu("result", this.result, false);
        this.editMenu.supportLoadSave = true;
    }

    private void eval() {
        this.saveChanges();
        try {
            String expr = this.text.getText();
            if (expr == null) {
                return;
            }
            if ((expr = expr.trim()).length() == 0) {
                return;
            }
            IDebugContext debug = this.page.sourcePanel.debugPanel.debug;
            IValue r = debug.evalNoDebug(expr);
            this.result.setText(String.valueOf(r));
            this.page.sourcePanel.debugPanel.watchPanel.notifyChanged(true);
        }
        catch (Exception ex) {
            this.page.sourcePanel.debugPanel.uiMain.handleException(ex);
        }
        if (!this.page.sourcePanel.debugPanel.isPausedState()) {
            this.setVisible(false);
        }
    }

    private void saveChanges() {
        props.set(this.page.getName() + ".evalScript", this.text.getText(), true);
    }
}

