/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.ui;

import com.kingdee.bos.kscript.debug.BreakPoints;
import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.debug.ui.ConsolePanel;
import com.kingdee.bos.kscript.debug.ui.DebugManager;
import com.kingdee.bos.kscript.debug.ui.DebugUI;
import com.kingdee.bos.kscript.debug.ui.IScript;
import com.kingdee.bos.kscript.debug.ui.SourcePanel;
import com.kingdee.bos.kscript.parser.Position;
import com.kingdee.bos.kscript.parser.Source;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class SourcePage
extends JSplitPane {
    static final Logger logger = Logger.getLogger(SourcePage.class);
    public static Color breakPoint = new Color(255, 192, 192);
    public static Color currentNoSelected = new Color(192, 192, 255);
    public SourcePanel sourcePanel;
    public IScript script;
    private Color selectedColor = null;
    private DefaultListCellRenderer render = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color clr;
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (isSelected) {
                SourcePage.this.selectedColor = c.getBackground();
            }
            if ((clr = SourcePage.this.getLineColor(c, index + 1, isSelected)) != null) {
                c.setBackground(clr);
            }
            return c;
        }
    };
    private volatile boolean ignore_modified = false;
    private volatile boolean checking = false;
    private DataModel dataModel = new DataModel();
    private JList list = new JList(this.dataModel);
    private final BreakPoints breakPoints = new BreakPoints();
    public ConsolePanel console;

    private Color getLineColor(Component c, int line, boolean isSelected) {
        if (isSelected) {
            return null;
        }
        if (this.breakPoints.containsLine(line)) {
            Color clr = breakPoint;
            if (isSelected) {
                int c1 = c.getBackground().getRGB();
                int c2 = clr.getRGB();
                int c3 = 0xFF000000 | c1 | c2;
                clr = new Color(c3);
            }
            return clr;
        }
        if (!isSelected && line == this.getCurrentDebugLine()) {
            return currentNoSelected;
        }
        return null;
    }

    public boolean reload() {
        this.ignore_modified = true;
        try {
            DebugManager dm = this.sourcePanel.debugPanel.uiMain.getDebugManager();
            Source source0 = this.getSource();
            IScript script0 = this.script;
            this.script = this.script.reload();
            if (source0.equals((Object)this.getSource())) {
                return false;
            }
            dm.unregisterDebugSource(script0.getKey());
            dm.registerDebugSource(this.getSource().getKey());
            dm.setBreakPoints(this.getSource().getKey(), this.breakPoints);
            int tabIndex = this.sourcePanel.indexOfComponent(this);
            this.sourcePanel.setTitleAt(tabIndex, this.script.getName());
            this.sourcePanel.setToolTipTextAt(tabIndex, this.script.getDescription());
            this.dataModel.fireChanged(-1);
            this.sourcePanel.debugPanel.uiMain.refreshState();
            this.ignore_modified = false;
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean checkModified() {
        if (this.checking) {
            return false;
        }
        this.checking = true;
        try {
            if (this.ignore_modified) {
                boolean bl = false;
                return bl;
            }
            if (!this.script.isModified()) {
                boolean bl = false;
                return bl;
            }
            int tabIndex = this.sourcePanel.indexOfComponent(this);
            this.sourcePanel.setTitleAt(tabIndex, "*" + this.script.getName());
            this.sourcePanel.setSelectedComponent(this);
            this.ignore_modified = true;
            if (!this.sourcePanel.debugPanel.uiMain.confirm("Source Modified", this.script.getDescription() + " has been changed,reload it?")) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.reload();
            return bl;
        }
        finally {
            this.checking = false;
        }
    }

    public void notifyChanged() {
        try {
            if (this.checkModified()) {
                return;
            }
            this.dataModel.fireChanged(this.list.getSelectedIndex());
            this.breakPoints.setBreakImmediately(this.sourcePanel.debugPanel.uiMain.isBreakImmediately());
            this.setBreakPoints();
        }
        catch (Exception ex) {
            this.sourcePanel.debugPanel.uiMain.handleDebugContextException(ex);
        }
    }

    private int getCurrentDebugLine() {
        try {
            IDebugContext debug = this.sourcePanel.debugPanel.debug;
            if (debug == null) {
                return 0;
            }
            int state = debug.getState();
            if (state != 4 && state != 1) {
                return 0;
            }
            Position pos = debug.getCurrentPosition();
            if (!pos.isValidPosition()) {
                return 0;
            }
            if (!pos.source.equals((Object)this.getSource())) {
                return 0;
            }
            return pos.beginLine;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private String getSourceLine(int line) {
        StringBuffer sb = new StringBuffer();
        if (this.getCurrentDebugLine() == line) {
            sb.append(">");
        } else {
            sb.append(" ");
        }
        if (this.breakPoints.containsLine(line)) {
            sb.append("*");
        } else {
            sb.append(" ");
        }
        sb.append(line);
        while (sb.length() < 8) {
            sb.append(" ");
        }
        String s = this.getSource().getLine(line);
        if (s != null) {
            s = s.replaceAll("\t", "    ");
            sb.append(s);
        }
        return sb.toString();
    }

    public Source getSource() {
        return this.script.getSource();
    }

    public SourcePage(SourcePanel parent, IScript script) {
        this.sourcePanel = parent;
        this.script = script;
        this.console = new ConsolePanel(this);
        JScrollPane sp = new JScrollPane(this.list);
        this.list.setCellRenderer(this.render);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    SourcePage.this.dblClicked();
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SourcePage.this.dataModel.fireChanged(SourcePage.this.getCurrentDebugLine() - 1);
            }
        });
        this.setOrientation(0);
        this.setLeftComponent(sp);
        this.setRightComponent(this.console.getComponent());
        this.setResizeWeight(0.7);
        DebugUI.setTextFont(this.list);
        this.sourcePanel.debugPanel.uiMain.getDebugManager().registerDebugSource(this.getSource().getKey());
        this.breakPoints.setModified(true);
        this.notifyChanged();
    }

    public void setBreakPoints() {
        if (this.breakPoints.isModified()) {
            this.sourcePanel.debugPanel.uiMain.getDebugManager().setBreakPoints(this.getSource().getKey(), this.breakPoints);
        }
    }

    public void refreshBreakPoints(boolean impBreak) {
        this.breakPoints.setBreakImmediately(impBreak);
        this.setBreakPoints();
    }

    private void dblClicked() {
        int line = this.list.getSelectedIndex() + 1;
        if (line > 0) {
            this.breakPoints.reverseLine(line);
            this.setBreakPoints();
            this.dataModel.fireChanged(line - 1);
        }
    }

    public boolean isPageOf(Source source) {
        return this.getSource().equals((Object)source);
    }

    public String getTitle() {
        return this.getSource().getName();
    }

    public void dropToPosition(Position pos) {
        this.list.setSelectedIndex(pos.beginLine - 1);
        this.list.ensureIndexIsVisible(pos.beginLine - 1);
    }

    class DataModel
    extends AbstractListModel {
        DataModel() {
        }

        @Override
        public Object getElementAt(int index) {
            return SourcePage.this.getSourceLine(index + 1);
        }

        @Override
        public int getSize() {
            return SourcePage.this.getSource().getLineCount();
        }

        public void fireChanged(int index) {
            if (index >= 0) {
                super.fireContentsChanged(this, index, index);
            } else {
                super.fireContentsChanged(this, 0, this.getSize());
            }
        }
    }
}

