/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.ui;

import com.kingdee.bos.kscript.debug.ui.DebugPanel;
import com.kingdee.bos.kscript.debug.ui.DebugUI;
import com.kingdee.bos.kscript.debug.ui.IScript;
import com.kingdee.bos.kscript.debug.ui.IScriptProvider;
import com.kingdee.bos.kscript.debug.ui.ScriptManager;
import com.kingdee.bos.kscript.debug.ui.SourcePage;
import com.kingdee.bos.kscript.parser.Position;
import com.kingdee.bos.kscript.parser.Source;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SourcePanel
extends JTabbedPane {
    static final Logger logger = Logger.getLogger(SourcePanel.class);
    public DebugPanel debugPanel;
    private ArrayList pages = new ArrayList();

    public SourcePanel(DebugPanel debugPanel) {
        this.debugPanel = debugPanel;
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SourcePage page = SourcePanel.this.getActivedPage();
                if (page != null && page.checkModified()) {
                    return;
                }
                SourcePanel.this.setTitle();
            }
        });
    }

    public void checkSourceChanged() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            SourcePage page = (SourcePage)this.getComponentAt(i);
            if (page == null) continue;
            page.checkModified();
        }
    }

    public void setTitle() {
        SourcePage page = this.getActivedPage();
        String title = "";
        if (this.debugPanel.debug != null) {
            title = title + this.debugPanel.debug.getRunningThread() + " - ";
        }
        if (page != null) {
            title = title + page.script.getName();
        }
        this.debugPanel.uiMain.setSubTitle(title);
    }

    public Component getComponent() {
        return this;
    }

    public boolean dropToPosition(Position pos) {
        SourcePage page = this.activePage(pos.source);
        if (page == null) {
            return false;
        }
        page.dropToPosition(pos);
        return true;
    }

    public void closeActivedPage() {
        this.closePage(this.getActivedPage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePage(SourcePage page) {
        if (page != null) {
            this.debugPanel.uiMain.getDebugManager().unregisterDebugSource(page.getSource().getKey());
            this.remove(page);
            ArrayList arrayList = this.pages;
            synchronized (arrayList) {
                this.pages.remove(page);
            }
        }
        this.debugPanel.uiMain.refreshState();
        this.saveSourcePages();
    }

    public void clearPage() {
        SourcePage[] sp = new SourcePage[this.pages.size()];
        sp = this.pages.toArray(sp);
        int len = sp.length;
        for (int i = 0; i < len; ++i) {
            this.closePage(sp[i]);
        }
    }

    public SourcePage getActivedPage() {
        return (SourcePage)this.getSelectedComponent();
    }

    public SourcePage activePage(Source source) {
        SourcePage page = this.activePage1(source);
        this.setTitle();
        return page;
    }

    private SourcePage activePage1(Source source) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            SourcePage page = (SourcePage)this.getComponentAt(i);
            if (page == null || !page.isPageOf(source)) continue;
            this.setSelectedIndex(i);
            return page;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourcePage getSourcePage(Source source) {
        if (source == null) {
            return null;
        }
        ArrayList arrayList = this.pages;
        synchronized (arrayList) {
            for (int i = 0; i < this.pages.size(); ++i) {
                SourcePage page = (SourcePage)this.pages.get(i);
                if (!page.getSource().equals((Object)source)) continue;
                return page;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourcePage loadScript(IScript script) throws Exception {
        SourcePage page = this.getSourcePage(script.getSource());
        if (page != null) {
            this.closePage(page);
        }
        page = new SourcePage(this, script);
        ArrayList arrayList = this.pages;
        synchronized (arrayList) {
            this.pages.add(page);
        }
        this.addTab(page.getTitle(), null, page, script.getDescription());
        this.setSelectedComponent(page);
        this.saveSourcePages();
        this.debugPanel.uiMain.refreshState();
        return page;
    }

    public SourcePage loadScript(IScriptProvider p) {
        try {
            IScript script = p.browseScript(this.debugPanel.uiMain);
            if (script == null) {
                return null;
            }
            return this.loadScript(script);
        }
        catch (Exception ex) {
            this.debugPanel.uiMain.handleException(ex);
            return null;
        }
    }

    public void notifyChanged() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            SourcePage page = (SourcePage)this.getComponentAt(i);
            if (page == null) continue;
            page.notifyChanged();
        }
    }

    public void refreshBreakPoints(boolean impBreak) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            SourcePage page = (SourcePage)this.getComponentAt(i);
            if (page == null) continue;
            page.refreshBreakPoints(impBreak);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSourcePages() {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList arrayList = this.pages;
        synchronized (arrayList) {
            for (int i = 0; i < this.pages.size(); ++i) {
                IScript script = ((SourcePage)this.pages.get((int)i)).script;
                String key = script.getProvider().getName() + "\n" + script.getKey();
                list.add(key);
            }
        }
        String[] ar = new String[list.size()];
        list.toArray(ar);
        DebugUI.props.setArray("scriptfiles", ar, true);
    }

    public void loadSourcePages() {
        String[] keys = DebugUI.props.getArray("scriptfiles");
        if (keys == null) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            try {
                IScript script;
                int index = keys[i].indexOf(10);
                if (index <= 0) continue;
                String p = keys[i].substring(0, index);
                String k = keys[i].substring(index + 1);
                IScriptProvider provider = ScriptManager.getProvider(p);
                if (provider == null || (script = provider.loadScript(k)) == null) continue;
                this.loadScript(script);
                continue;
            }
            catch (Exception ex) {
                logger.debug((Object)ex, (Throwable)ex);
            }
        }
        this.saveSourcePages();
    }
}

