/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.ui;

import com.kingdee.bos.kscript.debug.IValue;
import com.kingdee.bos.kscript.parser.Source;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ValueTree {
    public ValueTree parent;
    public String name;
    public String value;
    public String typeName;
    public Class type;
    public IValue ref = null;
    public ValueTree[] children = null;
    public int childCount = 0;
    public int index = 0;
    private static HashMap selectMap = new HashMap();
    public Source source = null;

    public ValueTree(ValueTree parent) {
        this.parent = parent;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.children == null && this.ref != null && this.childCount > 0) {
            sb.append("+");
        } else if (this.children != null && this.children.length > 0) {
            sb.append("-");
        } else {
            sb.append(" ");
        }
        for (int i = this.getDepth(); i > 0; --i) {
            sb.append("  ");
        }
        sb.append(this.getName());
        return sb.toString();
    }

    public ValueTree[] listAll(boolean includeThis) {
        ArrayList list = new ArrayList();
        this.listAll(list, includeThis);
        ValueTree[] ar = new ValueTree[list.size()];
        list.toArray(ar);
        return ar;
    }

    public void listAll(ArrayList list, boolean includeThis) {
        if (includeThis) {
            list.add(this);
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].listAll(list, true);
            }
        }
    }

    public void refresh() {
        this.children = null;
        this.setValue(this.name, this.index, this.ref, false);
    }

    public int getDepth() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getDepth() + 1;
    }

    public String getFullName() {
        if (this.parent != null) {
            if (this.name == null) {
                return this.parent.getFullName() + "[" + this.index + "]";
            }
            return this.parent.getFullName() + "." + this.name;
        }
        return this.name;
    }

    public int getAllChildCount() {
        if (this.children == null) {
            return 0;
        }
        int count = this.children.length;
        for (int i = 0; i < this.children.length; ++i) {
            count += this.children[i].getAllChildCount();
        }
        return count;
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.length;
    }

    public boolean expandOrNot() {
        int count;
        int count0 = this.getChildCount();
        if (this.children != null) {
            this.children = null;
        } else if (this.ref != null && (count = this.childCount) > 0) {
            this.children = new ValueTree[count];
            this.refreshChildren();
        }
        return count0 != this.getChildCount();
    }

    public static void setSelectedName(Source source, String name) {
        selectMap.put(source.getKey(), name);
    }

    public Source getSource() {
        if (this.source == null) {
            return this.parent.getSource();
        }
        return this.source;
    }

    public static String getSelectedName(Source source) {
        return (String)selectMap.get(source.getKey());
    }

    public void setSelected() {
        ValueTree.setSelectedName(this.getSource(), this.getFullName());
    }

    public String getSelectedName() {
        return ValueTree.getSelectedName(this.getSource());
    }

    public boolean isSelected() {
        String sel = this.getSelectedName();
        return sel != null && sel.equals(this.getFullName());
    }

    private boolean isExpands() {
        String var = this.getFullName();
        if (var == null) {
            return false;
        }
        String expandName = this.getSelectedName();
        if (expandName == null) {
            return false;
        }
        boolean b = var.equals(expandName) || expandName.startsWith(var + ".") || expandName.startsWith(var + "[");
        return b;
    }

    void refreshChildren() {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                String name = this.ref.getChildName(i);
                IValue val1 = null;
                if (this.ref != null) {
                    val1 = this.ref.getChildValue(i);
                }
                if (this.children[i] == null) {
                    this.children[i] = new ValueTree(this);
                }
                this.children[i].setValue(name, i, val1, false);
            }
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "[" + this.index + "]";
    }

    public void setValue(String name, int index, IValue ref, boolean expand) {
        this.ref = ref;
        this.name = name;
        this.index = index;
        if (ref == null) {
            this.type = null;
            this.typeName = null;
            this.value = null;
            this.childCount = 0;
        } else {
            this.type = ref.getGeneralType();
            this.typeName = ref.getTypeName();
            this.value = ref.toString();
            this.childCount = ref.getChildCount();
        }
        if (this.children != null && this.childCount != this.children.length) {
            this.children = null;
        }
        if (!expand) {
            expand = this.isExpands();
        }
        if (expand && this.childCount > 0 && (this.children == null || this.children.length != this.childCount)) {
            this.children = new ValueTree[this.childCount];
        }
        this.refreshChildren();
    }

    public boolean isTypeOf(Class cls) {
        if (this.type == null) {
            return false;
        }
        return cls.isAssignableFrom(this.type);
    }

    public String getVarScript() {
        if (this.parent.parent == null) {
            return this.name;
        }
        String pVar = this.parent.getVarScript();
        if (pVar == null) {
            return null;
        }
        if (this.parent.isTypeOf(Map.class)) {
            return pVar + ".get(\"" + this.name + "\")";
        }
        if (this.name != null) {
            return pVar + "." + this.name;
        }
        if (this.parent.isTypeOf(Set.class)) {
            return null;
        }
        return pVar + "[" + this.index + "]";
    }

    public String getAssignScript(String valExpr) {
        if (this.parent.parent == null) {
            return this.name + "=" + valExpr;
        }
        String pVar = this.parent.getVarScript();
        if (pVar == null) {
            return null;
        }
        if (this.parent.isTypeOf(Map.class)) {
            return pVar + ".put(\"" + this.name + "\"," + valExpr + ")";
        }
        if (this.name != null) {
            return pVar + "." + this.name + "=" + valExpr;
        }
        if (this.parent.isTypeOf(Set.class)) {
            return null;
        }
        return pVar + "[" + this.index + "]=" + valExpr;
    }
}

