/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.ui.swt;

import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.debug.BreakPoints;
import com.kingdee.bos.kscript.debug.DebugEnv;
import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.debug.IDebugProvider;
import com.kingdee.bos.kscript.debug.IDebugRuntime;
import com.kingdee.bos.kscript.debug.IValue;
import com.kingdee.bos.kscript.debug.ui.DebugManager;
import com.kingdee.bos.kscript.debug.ui.StringScriptProvider;
import com.kingdee.bos.kscript.debug.ui.swt.ActionExitAction;
import com.kingdee.bos.kscript.debug.ui.swt.ActionResumeAction;
import com.kingdee.bos.kscript.debug.ui.swt.ActionRunAction;
import com.kingdee.bos.kscript.debug.ui.swt.ActionSetLocalDebugAction;
import com.kingdee.bos.kscript.debug.ui.swt.ActionSetRemoteDebugAction;
import com.kingdee.bos.kscript.debug.ui.swt.ActionStepIntoAction;
import com.kingdee.bos.kscript.debug.ui.swt.ActionStepOutAction;
import com.kingdee.bos.kscript.debug.ui.swt.ActionStepOverAction;
import com.kingdee.bos.kscript.debug.ui.swt.ActionStopAction;
import com.kingdee.bos.kscript.debug.ui.swt.IDebugUI;
import com.kingdee.bos.kscript.debug.ui.swt.VarTreeViewerContentProvider;
import com.kingdee.bos.kscript.debug.ui.swt.VarTreeViewerLabelProvider;
import com.kingdee.bos.kscript.debug.ui.swt.VarTreeViewerModel;
import com.kingdee.bos.kscript.debug.ui.swt.widgets.DatePickerCombo;
import com.kingdee.bos.kscript.parser.Position;
import com.kingdee.bos.kscript.parser.Source;
import com.kingdee.bos.util.lightremote.RemoteEnv;
import com.kingdee.util.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.BasicConfigurator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class DebugUISWT
extends ApplicationWindow
implements IDebugProvider,
IDebugUI {
    public static final String TYPE_INT = "\u6574\u578b";
    public static final String TYPE_STRING = "\u5b57\u7b26\u4e32";
    public static final String TYPE_DOUBLE = "\u6d6e\u70b9\u578b";
    public static final String TYPE_BOOLEAN = "\u5e03\u5c14";
    public static final String TYPE_DATETIME = "\u65e5\u671f";
    public static final String[] TYPES = new String[]{"\u6574\u578b", "\u5b57\u7b26\u4e32", "\u6d6e\u70b9\u578b", "\u5e03\u5c14", "\u65e5\u671f"};
    public static List initContextList = null;
    private Context bosContext = null;
    ActionExitAction exitAction;
    ActionResumeAction resumeAction;
    ActionRunAction runAction;
    ActionStepIntoAction stepIntoAction;
    ActionStepOutAction stepOutAction;
    ActionStepOverAction stepOverAction;
    ActionStopAction stopAction;
    ActionSetLocalDebugAction setLocalDebugAction;
    ActionSetRemoteDebugAction setRemoteDebugAction;
    private Text evalSourceText;
    private Text evalResultText;
    private Text consoleText;
    private ListViewer sourceListViewer;
    private TreeViewer contextTreeViewer;
    private TableEditor editorName;
    private TableEditor editorType;
    private TableEditor editorValue;
    private Text txtName;
    private CCombo cmType;
    private Text txtValue;
    private CCombo cmBoolean;
    private DatePickerCombo cmDate;
    private boolean isExit = false;
    private boolean isStop = true;
    private static final BreakPoints breakPoints = new BreakPoints();
    private IDebugContext debugContext = null;
    public final DebugManager debugManager = new DebugManager();
    private IDebugRuntime remoteDebugRuntime = null;
    private boolean isRemoteDebug = false;
    private int debugUIState = 0;
    private String debugServerAddr = "";
    private int curLine = 0;
    private Source ksSource;
    private Table initContextTable;

    public boolean isStop() {
        return this.isStop;
    }

    @Override
    public void setStart() {
        this.isStop = false;
    }

    @Override
    public void setStop() {
        this.isStop = true;
    }

    public boolean isExit() {
        return this.isExit;
    }

    public int getDebugUIState() {
        return this.debugUIState;
    }

    @Override
    public boolean isRemoteDebug() {
        return this.isRemoteDebug;
    }

    @Override
    public int getCurLine() {
        return this.curLine;
    }

    @Override
    public void setCurLine(int curLine) {
        this.curLine = curLine;
    }

    public DebugManager getDebugManager() {
        return this.debugManager;
    }

    @Override
    public IDebugContext getDebugContext() {
        return this.debugContext;
    }

    public void setDebugContext(IDebugContext debugContext) {
        this.debugContext = debugContext;
    }

    public void setBreakPoints() {
        if (breakPoints.isModified()) {
            this.getDebugManager().setBreakPoints(this.getSource().getKey(), breakPoints);
        }
    }

    public List getContextTableData() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        TableItem[] tableItems = this.initContextTable.getItems();
        int len = tableItems.length;
        for (int i = 0; i < len; ++i) {
            String[] str = new String[]{tableItems[i].getText(0), tableItems[i].getText(1), tableItems[i].getText(2)};
            list.add(str);
        }
        return list;
    }

    public void setContextTableData(List list) {
        this.initContextTable.removeAll();
        if (list == null) {
            return;
        }
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            String[] str;
            Object obj = list.get(i);
            if (!(obj instanceof String[]) || (str = (String[])obj).length != 3) continue;
            TableItem ti = new TableItem(this.initContextTable, 0);
            ti.setText(str);
        }
    }

    @Override
    public Map getInitContext() {
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        rtn.put("__bosContext", this.getBosContext());
        TableItem[] tableItems = this.initContextTable.getItems();
        int len = tableItems.length;
        for (int i = 0; i < len; ++i) {
            Comparable<Double> d;
            String key = tableItems[i].getText(0);
            String type = tableItems[i].getText(1);
            String value = tableItems[i].getText(2);
            if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) continue;
            if (TYPE_INT.equals(type)) {
                Integer iv = null;
                try {
                    iv = new Integer(value);
                }
                catch (Exception e) {
                    iv = new Integer(0);
                }
                rtn.put(key, iv);
                continue;
            }
            if (TYPE_STRING.equals(type)) {
                rtn.put(key, value);
                continue;
            }
            if (TYPE_DOUBLE.equals(type)) {
                d = null;
                try {
                    d = new Double(value);
                }
                catch (Exception e) {
                    d = new Double(0.0);
                }
                rtn.put(key, d);
                continue;
            }
            if (TYPE_BOOLEAN.equals(type)) {
                Boolean f = null;
                try {
                    f = new Boolean(value);
                }
                catch (Exception e) {
                    f = new Boolean(false);
                }
                rtn.put(key, f);
                continue;
            }
            if (TYPE_DATETIME.equals(type)) {
                d = null;
                try {
                    d = DateFormat.getDateInstance(2).parse(type);
                }
                catch (Exception e) {
                    d = new Date(System.currentTimeMillis());
                }
                rtn.put(key, d);
                continue;
            }
            rtn.put(key, value);
        }
        return rtn;
    }

    private int getCurrentDebugLine() {
        try {
            IDebugContext debug = this.getDebugContext();
            if (debug == null) {
                return 0;
            }
            int state = debug.getState();
            if (state != 4 && state != 1) {
                return 0;
            }
            Position pos = debug.getCurrentPosition();
            if (!pos.isValidPosition()) {
                return 0;
            }
            if (!pos.source.equals((Object)this.getSource())) {
                return 0;
            }
            return pos.beginLine;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private String getSourceLine(int line) {
        StringBuffer sb = new StringBuffer();
        if (this.getCurrentDebugLine() == line) {
            sb.append(">");
        } else {
            sb.append(" ");
        }
        if (breakPoints.containsLine(line)) {
            sb.append("*");
        } else {
            sb.append(" ");
        }
        sb.append(line);
        while (sb.length() < 8) {
            sb.append(" ");
        }
        String s = this.getSource().getLine(line);
        if (s != null) {
            s = s.replaceAll("\t", "    ");
            sb.append(s);
        }
        return sb.toString();
    }

    public void setSource(Source source) {
        this.ksSource = source;
    }

    @Override
    public Source getSource() {
        if (this.ksSource != null) {
            return this.ksSource;
        }
        try {
            this.ksSource = new StringScriptProvider().loadScript("int a=0;\r\n\r\n\r\nprintln(a);\r\na++;\r\na++;a++;a=a/b;\r\na++;\r\nreturn a;").getSource();
        }
        catch (Exception ex) {
            this.ksSource = null;
        }
        return this.ksSource;
    }

    public DebugUISWT(Shell p, Source source) {
        super(p);
        this.setSource(source);
        this.createActions();
        this.addToolBar(0x800040);
        this.addMenuBar();
        this.getDebugManager().setLocalDebugProvider(this);
        DebugEnv env = (DebugEnv)DebugEnv.registerDebuger(this);
        this.getDebugManager().enlistDebug(null, (IDebugRuntime)env);
        breakPoints.setModified(true);
        breakPoints.setBreakImmediately(false);
        if (this.getSource() != null) {
            this.getDebugManager().registerDebugSource(this.getSource().getKey());
        }
        this.setLocalDebug();
        this.setActionState(0);
    }

    public DebugUISWT(Source source) {
        this(null, source);
    }

    @Override
    public IDebugRuntime getDebugRuntime() {
        if (this.isRemoteDebug() && this.remoteDebugRuntime != null) {
            return this.remoteDebugRuntime;
        }
        return DebugEnv.getDebugEnv();
    }

    @Override
    public void setLocalDebug() {
        this.setLocalDebugAction.setChecked(true);
        this.setRemoteDebugAction.setChecked(false);
        this.isRemoteDebug = false;
        if (this.remoteDebugRuntime != null) {
            this.remoteDebugRuntime.terminate();
            this.getDebugManager().unlistDebug(this.remoteDebugRuntime);
            this.remoteDebugRuntime = null;
        }
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Remote Connect", (String)message);
    }

    private boolean connect() {
        try {
            this.remoteDebugRuntime = null;
            if (StringUtils.isEmpty((String)this.debugServerAddr)) {
                this.showMessage("\u670d\u52a1\u5668\u5730\u5740\u4e3a\u7a7a");
                return false;
            }
            this.remoteDebugRuntime = this.getDebugManager().connectRemote(this.debugServerAddr);
            this.showMessage("Remote Debug Server '" + DebugManager.getDebugRuntimeName(this.remoteDebugRuntime) + "' connected.");
            return true;
        }
        catch (Exception ex) {
            this.showMessage("\u8fde\u63a5\u5230\u8fdc\u7a0b\u670d\u52a1\u5668(" + this.debugServerAddr + ")\u5931\u8d25!");
            return false;
        }
    }

    @Override
    public void setRemoteDebug() {
        if (this.connect()) {
            this.setRemoteDebugAction.setChecked(true);
            this.setLocalDebugAction.setChecked(false);
            this.isRemoteDebug = true;
        } else {
            if (this.remoteDebugRuntime != null) {
                this.getDebugManager().unlistDebug(this.remoteDebugRuntime);
                this.remoteDebugRuntime = null;
            }
            this.setLocalDebugAction.setChecked(true);
            this.setRemoteDebugAction.setChecked(false);
            this.isRemoteDebug = false;
        }
    }

    @Override
    public void exit() {
        this.debugUIState = 0;
        if (this.getDebugContext() != null) {
            try {
                this.getDebugContext().stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (DebugEnv.getDebugEnv() != null) {
            DebugEnv.getDebugEnv().terminate();
        }
        this.isExit = true;
    }

    protected Control createContents(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent de) {
                DebugUISWT.this.exit();
            }
        });
        Composite container = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout(256);
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        container.setLayout((Layout)fillLayout);
        SashForm sashForm_Main = new SashForm(container, 0);
        sashForm_Main.setSashWidth(2);
        sashForm_Main.SASH_WIDTH = 2;
        SashForm sashForm_Left = new SashForm((Composite)sashForm_Main, 0);
        sashForm_Left.setOrientation(512);
        sashForm_Left.setSashWidth(2);
        sashForm_Left.SASH_WIDTH = 2;
        Composite cmpLeftTop = new Composite((Composite)sashForm_Left, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 1;
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        gridLayout.horizontalSpacing = 1;
        cmpLeftTop.setLayout((Layout)gridLayout);
        Label lblSource = new Label(cmpLeftTop, 0);
        lblSource.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblSource.setText("KScript\u811a\u672c:");
        this.sourceListViewer = new ListViewer(cmpLeftTop, 2816);
        org.eclipse.swt.widgets.List list = this.sourceListViewer.getList();
        list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                String str;
                org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)e.getSource();
                int line = list.getSelectionIndex() + 1;
                if (line > 0 && !(str = list.getItem(line - 1).substring(7)).trim().equals("")) {
                    breakPoints.reverseLine(line);
                    DebugUISWT.this.updateSourceLine(line);
                    DebugUISWT.this.setBreakPoints();
                }
            }
        });
        this.sourceListViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.sourceListViewer.getList().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite cmpLeftBot = new Composite((Composite)sashForm_Left, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 1;
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        gridLayout.horizontalSpacing = 1;
        cmpLeftBot.setLayout((Layout)gridLayout);
        lblSource = new Label(cmpLeftBot, 0);
        lblSource.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblSource.setText("\u63a7\u5236\u53f0:");
        this.consoleText = new Text(cmpLeftBot, 2816);
        this.consoleText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.consoleText.setBackground(Display.getCurrent().getSystemColor(1));
        Composite composite = new Composite((Composite)sashForm_Main, 0);
        composite.setLayout((Layout)new FillLayout(256));
        Composite composite_bot = new Composite(composite, 0);
        composite_bot.setLayout((Layout)new FillLayout(256));
        TabFolder tabFolder = new TabFolder(composite_bot, 0);
        TabItem tbtmInit = new TabItem(tabFolder, 0);
        tbtmInit.setText("\u521d\u59cb\u5316\u53c2\u6570");
        Composite composite_initContext = new Composite((Composite)tabFolder, 0);
        composite_initContext.setLayout((Layout)new GridLayout(2, false));
        Button btnAdd = new Button(composite_initContext, 0);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugUISWT.this.resetEditors();
                new TableItem(DebugUISWT.this.initContextTable, 0);
            }
        });
        btnAdd.setText("\u6dfb\u52a0");
        Button btnDel = new Button(composite_initContext, 0);
        btnDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugUISWT.this.resetEditors();
                int selectionIndex = DebugUISWT.this.initContextTable.getSelectionIndex();
                if (selectionIndex >= 0) {
                    DebugUISWT.this.initContextTable.remove(selectionIndex);
                }
            }
        });
        btnDel.setText("\u5220\u9664");
        TableViewer initContextTV = new TableViewer(composite_initContext, 67584);
        this.initContextTable = initContextTV.getTable();
        this.initContextTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.initContextTable.setLinesVisible(true);
        this.initContextTable.setHeaderVisible(true);
        tbtmInit.setControl((Control)composite_initContext);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(initContextTV, 0);
        TableColumn tblclmnName = tableViewerColumn.getColumn();
        tblclmnName.setWidth(100);
        tblclmnName.setText("\u540d\u79f0");
        tableViewerColumn = new TableViewerColumn(initContextTV, 0);
        TableColumn tblclmnValue = tableViewerColumn.getColumn();
        tblclmnValue.setWidth(100);
        tblclmnValue.setText("\u7c7b\u578b");
        tableViewerColumn = new TableViewerColumn(initContextTV, 0);
        tblclmnValue = tableViewerColumn.getColumn();
        tblclmnValue.setWidth(100);
        tblclmnValue.setText("\u521d\u59cb\u503c");
        this.buildTable();
        TabItem tbtmContext = new TabItem(tabFolder, 0);
        tbtmContext.setText("\u4e0a\u4e0b\u6587");
        this.contextTreeViewer = new TreeViewer((Composite)tabFolder, 2048);
        this.contextTreeViewer.setUseHashlookup(true);
        this.contextTreeViewer.setLabelProvider((IBaseLabelProvider)new VarTreeViewerLabelProvider());
        this.contextTreeViewer.setContentProvider((IContentProvider)new VarTreeViewerContentProvider());
        this.contextTreeViewer.setInput(null);
        Tree tree = this.contextTreeViewer.getTree();
        TreeColumn treeColumn = new TreeColumn(tree, 0);
        treeColumn.setWidth(100);
        treeColumn.setText("\u540d\u79f0");
        treeColumn = new TreeColumn(tree, 0);
        treeColumn.setWidth(100);
        treeColumn.setText("\u7c7b\u578b");
        treeColumn = new TreeColumn(tree, 0);
        treeColumn.setWidth(100);
        treeColumn.setText("\u503c");
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tbtmContext.setControl((Control)tree);
        TabItem tbtmDisplay = new TabItem(tabFolder, 0);
        tbtmDisplay.setText("\u663e\u793a");
        Composite composite_display = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.verticalSpacing = 1;
        gridLayout2.marginWidth = 1;
        gridLayout2.marginHeight = 1;
        gridLayout2.horizontalSpacing = 1;
        composite_display.setLayout((Layout)gridLayout2);
        this.evalSourceText = new Text(composite_display, 2818);
        this.evalSourceText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Button btnEval = new Button(composite_display, 0);
        btnEval.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = DebugUISWT.this.evalSourceText.getSelectionText();
                if (StringUtils.isEmpty((String)text)) {
                    text = DebugUISWT.this.evalSourceText.getText();
                }
                if (!StringUtils.isEmpty((String)text) && DebugUISWT.this.getDebugContext() != null) {
                    IValue rtn = null;
                    String rtnTxt = "";
                    try {
                        rtn = DebugUISWT.this.getDebugContext().evalNoDebug(text);
                        rtnTxt = rtn == null ? "\u6ca1\u6709\u8fd4\u56de\u503c" : rtn.toString();
                    }
                    catch (Exception ex) {
                        rtnTxt = "\u6267\u884c\u811a\u672c\u51fa\u9519!";
                    }
                    DebugUISWT.this.evalResultText.setText(rtnTxt);
                }
            }
        });
        btnEval.setText("\u6267\u884c");
        this.evalResultText = new Text(composite_display, 2056);
        this.evalResultText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        tbtmDisplay.setControl((Control)composite_display);
        sashForm_Main.setWeights(new int[]{1, 1});
        this.init();
        return container;
    }

    private void buildTable() {
        this.editorName = new TableEditor(this.initContextTable);
        this.editorType = new TableEditor(this.initContextTable);
        this.editorValue = new TableEditor(this.initContextTable);
        this.initContextTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DebugUISWT.this.resetEditors();
                int selectedIndex = DebugUISWT.this.initContextTable.getSelectionIndex();
                Point pt = new Point(e.x, e.y);
                TableItem newItem = selectedIndex == -1 || selectedIndex > DebugUISWT.this.initContextTable.getItemCount() - 1 ? DebugUISWT.this.initContextTable.getItem(pt) : DebugUISWT.this.initContextTable.getItem(selectedIndex);
                if (newItem == null) {
                    return;
                }
                DebugUISWT.this.initContextTable.showSelection();
                for (int i = 0; i < DebugUISWT.this.initContextTable.getColumnCount(); ++i) {
                    Rectangle rect = newItem.getBounds(i);
                    if (!rect.contains(pt)) continue;
                    DebugUISWT.this.createTableEditor(newItem, i);
                }
            }
        });
    }

    protected void resetEditors() {
        this.resetEditors(this.editorName, (Control)this.txtName, 0);
        this.resetEditors(this.editorType, (Control)this.cmType, 1);
        this.resetEditors(this.editorValue, (Control)this.txtValue, 2);
        this.resetEditors(this.editorValue, (Control)this.cmBoolean, 2);
        this.resetEditors(this.editorValue, (Control)this.cmDate, 2);
        initContextList = this.getContextTableData();
    }

    private void resetEditors(TableEditor editor, Control control, int colIndex) {
        TableItem oldItem = editor.getItem();
        String temp = "";
        if (editor.getEditor() instanceof Text) {
            temp = ((Text)editor.getEditor()).getText();
        } else if (editor.getEditor() instanceof CCombo) {
            temp = ((CCombo)editor.getEditor()).getText();
        } else if (editor.getEditor() instanceof DatePickerCombo) {
            temp = ((DatePickerCombo)editor.getEditor()).getText();
        }
        editor.setEditor(null, null, -1);
        if (oldItem != null && oldItem != null && !oldItem.isDisposed()) {
            oldItem.setText(colIndex, temp);
        }
        if (control != null && !control.isDisposed()) {
            control.dispose();
        }
    }

    protected void createTextEditor(Table table, Text text, TableEditor editor, TableItem item, int colIndex) {
        text.setText(item.getText(colIndex));
        table.selectAll();
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.setEditor((Control)text, item, colIndex);
    }

    private void createComboEditor(Table table, CCombo combo, TableEditor comboEditor, TableItem item, int colIndex, String[] values, String defaultValue) {
        combo.setItems(values);
        if (StringUtils.isEmpty((String)item.getText(colIndex))) {
            combo.setText(defaultValue);
        } else {
            combo.setText(item.getText(colIndex));
        }
        comboEditor.horizontalAlignment = 16384;
        comboEditor.grabHorizontal = true;
        comboEditor.minimumWidth = 50;
        comboEditor.setEditor((Control)combo, item, colIndex);
    }

    protected void createDatePickComboEditor(Table table, DatePickerCombo combo, TableEditor editor, TableItem item, int colIndex) {
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.setEditor((Control)combo, item, colIndex);
    }

    private void createTableEditor(TableItem newItem, int colIndex) {
        switch (colIndex) {
            case 0: {
                this.txtName = new Text((Composite)this.initContextTable, 0);
                this.createTextEditor(this.initContextTable, this.txtName, this.editorName, newItem, colIndex);
                this.txtName.setFocus();
                this.txtName.getSelection();
                break;
            }
            case 1: {
                this.cmType = new CCombo((Composite)this.initContextTable, 8);
                this.createComboEditor(this.initContextTable, this.cmType, this.editorType, newItem, colIndex, TYPES, TYPES[0]);
                this.cmType.setFocus();
                break;
            }
            case 2: {
                String type = newItem.getText(1);
                if (TYPE_BOOLEAN.equals(type)) {
                    this.cmBoolean = new CCombo((Composite)this.initContextTable, 8);
                    this.createComboEditor(this.initContextTable, this.cmBoolean, this.editorValue, newItem, colIndex, new String[]{"true", "false"}, "true");
                    this.cmBoolean.setFocus();
                    break;
                }
                if (TYPE_DATETIME.equals(type)) {
                    this.cmDate = new DatePickerCombo((Composite)this.initContextTable, 0);
                    String strDate = newItem.getText(2);
                    if (!StringUtils.isEmpty((String)strDate)) {
                        try {
                            Date date = DateFormat.getDateInstance(2).parse(strDate);
                            this.cmDate.setDate(date);
                        }
                        catch (ParseException e) {
                            this.cmDate.setDate(new Date(System.currentTimeMillis()));
                        }
                    } else {
                        this.cmDate.setDate(new Date(System.currentTimeMillis()));
                    }
                    this.createDatePickComboEditor(this.initContextTable, this.cmDate, this.editorValue, newItem, colIndex);
                    this.cmDate.setFocus();
                    break;
                }
                this.txtValue = new Text((Composite)this.initContextTable, 0);
                this.createTextEditor(this.initContextTable, this.txtValue, this.editorValue, newItem, colIndex);
                this.txtValue.setFocus();
                this.txtValue.getSelection();
                break;
            }
        }
    }

    @Override
    public void setActionState(int state) {
        this.debugUIState = state;
        switch (state) {
            case 0: {
                this.runAction.setEnabled(true);
                this.resumeAction.setEnabled(false);
                this.stepIntoAction.setEnabled(false);
                this.stepOutAction.setEnabled(false);
                this.stepOverAction.setEnabled(false);
                this.stopAction.setEnabled(false);
                this.setLocalDebugAction.setEnabled(true);
                this.setRemoteDebugAction.setEnabled(true);
                break;
            }
            case 1: {
                this.runAction.setEnabled(false);
                this.resumeAction.setEnabled(true);
                this.stepIntoAction.setEnabled(true);
                this.stepOutAction.setEnabled(true);
                this.stepOverAction.setEnabled(true);
                this.stopAction.setEnabled(true);
                this.setLocalDebugAction.setEnabled(false);
                this.setRemoteDebugAction.setEnabled(false);
            }
        }
    }

    private void createActions() {
        this.exitAction = new ActionExitAction(this);
        this.resumeAction = new ActionResumeAction(this);
        this.runAction = new ActionRunAction(this);
        this.stepIntoAction = new ActionStepIntoAction(this);
        this.stepOutAction = new ActionStepOutAction(this);
        this.stepOverAction = new ActionStepOverAction(this);
        this.stopAction = new ActionStopAction(this);
        this.setLocalDebugAction = new ActionSetLocalDebugAction(this);
        this.setRemoteDebugAction = new ActionSetRemoteDebugAction(this);
    }

    protected MenuManager createMenuManager() {
        MenuManager menuBar = new MenuManager("menuBar");
        MenuManager menuFile = new MenuManager("&File");
        menuFile.add((IAction)this.exitAction);
        menuBar.add((IContributionItem)menuFile);
        MenuManager menuDebug = new MenuManager("&Debug");
        menuDebug.add((IAction)this.setLocalDebugAction);
        menuDebug.add((IAction)this.setRemoteDebugAction);
        menuDebug.add((IContributionItem)new Separator());
        menuDebug.add((IAction)this.runAction);
        menuDebug.add((IAction)this.resumeAction);
        menuDebug.add((IAction)this.stopAction);
        menuDebug.add((IContributionItem)new Separator());
        menuDebug.add((IAction)this.stepOverAction);
        menuDebug.add((IAction)this.stepIntoAction);
        menuDebug.add((IAction)this.stepOutAction);
        menuBar.add((IContributionItem)menuDebug);
        return menuBar;
    }

    protected ToolBarManager createToolBarManager(int style) {
        ToolBarManager toolBar = new ToolBarManager(style);
        toolBar.add((IAction)this.setLocalDebugAction);
        toolBar.add((IAction)this.setRemoteDebugAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.runAction);
        toolBar.add((IAction)this.resumeAction);
        toolBar.add((IAction)this.stopAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.stepIntoAction);
        toolBar.add((IAction)this.stepOverAction);
        toolBar.add((IAction)this.stepOutAction);
        return toolBar;
    }

    protected StatusLineManager createStatusLineManager() {
        StatusLineManager statusLineManager = new StatusLineManager();
        statusLineManager.setMessage(null, "");
        return statusLineManager;
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            DebugUISWT window = new DebugUISWT(null, null);
            window.setBlockOnOpen(true);
            window.open();
            Display.getCurrent().dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("KScript Debug Tool");
    }

    protected Point getInitialSize() {
        return new Point(300, 400);
    }

    public void init() {
        this.initListViewer(this.sourceListViewer);
        this.setContextTableData(initContextList);
        this.setBreakPoints();
    }

    private void initListViewer(ListViewer listViewer) {
        Source source = this.getSource();
        if (source != null) {
            listViewer.setInput((Object)source);
        }
    }

    @Override
    public void updateSourceLine(final int line) {
        Source source = this.getSource();
        if (source != null && line > 0 && line <= source.getLineCount()) {
            final String str = this.getSourceLine(line);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    int is = DebugUISWT.this.sourceListViewer.getList().getSelectionIndex();
                    DebugUISWT.this.sourceListViewer.getList().setItem(line - 1, str);
                    DebugUISWT.this.sourceListViewer.getList().select(is);
                }
            });
        }
    }

    public IDebugUI getThis() {
        return this;
    }

    public void debugOutput(IDebugContext debug, int state, final Object value) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (DebugUISWT.this.consoleText != null && !DebugUISWT.this.consoleText.isDisposed()) {
                    String str = DebugUISWT.this.consoleText.getText();
                    DebugUISWT.this.consoleText.setText(str + value + "\r\n");
                }
            }
        });
    }

    public void debugNotify(final IDebugContext debug, final int state, final IValue value) {
        RemoteEnv.startThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (DebugUISWT.this.isStop()) {
                        if (state == -2) {
                            DebugUISWT.this.debugOutput(debug, state, "\u6267\u884c\u811a\u672c\u7ed3\u675f, \u8fd4\u56de\u503c\u662f  " + String.valueOf(value));
                        }
                        DebugUISWT.this.getThis().setActionState(0);
                        DebugUISWT.this.setStop();
                        return;
                    }
                    if (state == -4) {
                        DebugUISWT.this.debugOutput(debug, state, value);
                        return;
                    }
                    DebugUISWT.this.setDebugContext(debug);
                    if (DebugUISWT.this.curLine > 0) {
                        DebugUISWT.this.updateSourceLine(DebugUISWT.this.curLine);
                    }
                    DebugUISWT.this.curLine = DebugUISWT.this.getCurrentDebugLine();
                    DebugUISWT.this.updateSourceLine(DebugUISWT.this.curLine);
                    if (state == 2 || state == 4) {
                        DebugUISWT.this.getThis().setActionState(1);
                    } else if (state == 8 || state == 1) {
                        DebugUISWT.this.getThis().setActionState(0);
                        DebugUISWT.this.setStop();
                    }
                    if (state == -2 || state == -3) {
                        if (state == -2) {
                            DebugUISWT.this.debugOutput(debug, state, "\u6267\u884c\u811a\u672c\u7ed3\u675f, \u8fd4\u56de\u503c\u662f  " + String.valueOf(value));
                        }
                        DebugUISWT.this.getThis().setActionState(0);
                        DebugUISWT.this.setStop();
                        return;
                    }
                    if (state == 1) {
                        DebugUISWT.this.debugOutput(debug, state, "\u7b2c " + DebugUISWT.this.curLine + " \u884c: " + DebugUISWT.this.getSourceLine(DebugUISWT.this.curLine).substring(7) + "   \u6267\u884c\u51fa\u9519\r\n" + debug.getReturnValue().getStackTrace());
                    }
                    if (state == 4 || state == 8 || state == 1) {
                        final IValue context = debug.getContext();
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                DebugUISWT.this.contextTreeViewer.setInput((Object)new VarTreeViewerModel("context", context));
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public String getDebugServerAddr() {
        return this.debugServerAddr;
    }

    public void setDebugServerAddr(String debugServerAddr) {
        this.debugServerAddr = debugServerAddr;
    }

    @Override
    public Context getBosContext() {
        return this.bosContext;
    }

    public void setBosContext(Context bosContext) {
        this.bosContext = bosContext;
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Source source = (Source)inputElement;
            int len = source.getLineCount();
            Object[] rtn = new Object[len];
            for (int i = 0; i < len; ++i) {
                String str = DebugUISWT.this.getSourceLine(i + 1);
                rtn[i] = str;
            }
            return rtn;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

