/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db.InspectSql;

import com.kingdee.bos.db.InspectSql.InspectSqlManageMBean;
import com.kingdee.bos.sql.shell.trace.LogItem;
import com.kingdee.util.BOSGlobalConfiguration;
import com.kingdee.util.ConfigurationItem;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class InspectSqlManage
implements InspectSqlManageMBean {
    private static final Logger logger = Logger.getLogger(InspectSqlManage.class);
    private static String nkey = "";
    private static StringBuffer sql = new StringBuffer();
    private static StringBuffer stack = new StringBuffer();
    private static BlockingQueue<Object> queue;

    @Override
    public String getKey() {
        return nkey;
    }

    private static void initFromConfig() {
        BOSGlobalConfiguration configuration = BOSGlobalConfiguration.getInstance();
        ConfigurationItem item = configuration.getConfigItem("InspectSql");
        if (item == null) {
            return;
        }
        String searchKey = item.getProperty("searchKey");
        if (searchKey != null) {
            nkey = searchKey;
        }
    }

    @Override
    public void setKey(String message) {
        nkey = message;
    }

    @Override
    public String getSql() {
        return sql.toString();
    }

    @Override
    public String getStack() {
        return stack.toString();
    }

    public static boolean isEnable() {
        return nkey != null && nkey.trim().length() > 0;
    }

    public static void filter(LogItem logItem) {
        if (logItem == null || logItem.dialect_sql == null && logItem.ksql == null) {
            return;
        }
        String dsql = "\r\n<KSQL>:\t" + logItem.ksql + "  \r\n<sql>: \t" + logItem.dialect_sql;
        if (InspectSqlManage.isSqlMatch(dsql)) {
            stack = InspectSqlManage.getStackTrace();
            sql.setLength(0);
            sql.append(dsql);
            try {
                if (queue.size() < 1000) {
                    queue.put(new Pair(dsql, stack.toString()));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static boolean isSqlMatch(String dsql) {
        return dsql.contains(nkey) || dsql.contains(nkey.toUpperCase()) || dsql.contains(nkey.toLowerCase());
    }

    private static StringBuffer getStackTrace() {
        StackTraceElement[] stackTraceElements = new Exception().getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < stackTraceElements.length; ++i) {
            sb.append("\r\n \t " + stackTraceElements[i]);
        }
        return sb;
    }

    private static void writeLog(Pair pair) {
        logger.error((Object)pair.sql);
        logger.error((Object)pair.trace);
    }

    static {
        try {
            LazyLog lazy = new LazyLog();
            lazy.setName("Inspect KSql Lazy Log");
            lazy.setDaemon(true);
            lazy.setPriority(1);
            lazy.start();
            InspectSqlManage.initFromConfig();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        queue = new LinkedBlockingQueue<Object>(1024);
    }

    static class Pair {
        String sql;
        String trace;

        public Pair(String sql, String trace) {
            this.sql = sql;
            this.trace = trace;
        }
    }

    static class LazyLog
    extends Thread {
        private boolean isRunnable = true;

        LazyLog() {
        }

        public void stopThread() {
            this.isRunnable = false;
        }

        @Override
        public void run() {
            while (this.isRunnable || !queue.isEmpty()) {
                try {
                    Pair pair = (Pair)queue.take();
                    InspectSqlManage.writeLog(pair);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

