/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.session;

import com.kingdee.bos.framework.session.ApplicationInfo;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionInfoCompositeDataBuilder;
import com.kingdee.bos.management.util.CompositeDataBuilder;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

class OpenDataHelper {
    private OpenDataHelper() {
    }

    public static CompositeData toCompositeData(String sessionId, SessionInfo session) {
        return new SessionInfoCompositeDataBuilder(sessionId, session).toCompositeData();
    }

    public static CompositeData toCompositeData(String sessionId, SessionInfo session, boolean fixedFieldOnly) {
        return new SessionInfoCompositeDataBuilder(sessionId, session, fixedFieldOnly).toCompositeData();
    }

    public static CompositeData toCompositeData(String ais, ApplicationInfo app) {
        CompositeDataBuilder cdb = new CompositeDataBuilder("ApplicationInfoCompositeData", "ApplicationInfo CompositeData");
        cdb.addValue("AIS", "Data Center", ais);
        cdb.addValue(app.application);
        return cdb.toCompositeData();
    }

    public static TabularData toSessionTabularData(Map sessionMap) {
        return OpenDataHelper.toSessionTabularData(sessionMap, null);
    }

    public static TabularData toSessionTabularData(Map sessionMap, ISessionFilter filter) {
        assert (sessionMap != null);
        TabularData td = SessionInfoCompositeDataBuilder.getTabularData();
        for (String sessionId : sessionMap.keySet()) {
            SessionInfo session = (SessionInfo)sessionMap.get(sessionId);
            if (filter != null && !filter.match(session)) continue;
            td.put(OpenDataHelper.toCompositeData(sessionId, session));
        }
        return td;
    }

    static interface ISessionFilter {
        public boolean match(SessionInfo var1);
    }
}

