/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.invokecounter;

import com.kingdee.util.StringUtils;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;

public class HttpCounterUtils {
    private static ThreadLocal<Long> baseNo = new ThreadLocal();
    private static ThreadLocal<Stack<String>> handlerNoStack = new ThreadLocal();

    public static String getHandlerNo() {
        Stack<String> stack = handlerNoStack.get();
        if (stack == null || stack.size() == 0) {
            return null;
        }
        return stack.peek();
    }

    public static String pushHandlerNo() {
        Long bNo = baseNo.get();
        if (bNo == null) {
            bNo = System.currentTimeMillis();
            baseNo.set(bNo);
        }
        bNo = bNo + 1L;
        baseNo.set(bNo);
        Stack<String> stack = handlerNoStack.get();
        if (stack == null) {
            handlerNoStack.set(new Stack());
            stack = handlerNoStack.get();
        }
        stack.push(bNo.toString());
        return stack.peek();
    }

    public static void popHandlerNo() {
        Stack<String> stack = handlerNoStack.get();
        if (stack == null || stack.size() == 0) {
            return;
        }
        stack.pop();
    }

    public static void remove() {
        baseNo.remove();
        handlerNoStack.remove();
    }

    public static boolean isMonitorOn(HttpServletRequest request) {
        String monitor = request.getParameter("monitor");
        String requestNo = request.getParameter("requestNo");
        String uipk = request.getParameter("uipk");
        if (uipk == null || "".equals(uipk) || "com.kingdee.eas.webDev.monitor".equals(uipk) || "heartbeat".equals(request.getParameter("event"))) {
            return false;
        }
        return "true".equals(monitor) || !StringUtils.isEmpty((String)requestNo);
    }
}

