/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.invokecounter;

import com.kingdee.bos.invokecounter.HttpCounterUtils;
import com.kingdee.bos.invokecounter.OneInvokeInfo;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class HttpRpcCounter {
    public static final Logger logger = Logger.getLogger(HttpRpcCounter.class);
    private static ThreadLocal<ThreadCounter> counter = new ThreadLocal();
    private static boolean isValid = false;
    private static boolean isFilterTime = false;
    private static long filter_time_threshold = 5000L;
    private static long filter_vector_threshold = 100L;
    static ThreadLocal<Long> rpcInvokeFlag;
    static ThreadLocal<AtomicInteger> rpcInvokeLevel;
    private static SimpleDateFormat mdf;
    private static SimpleDateFormat mdf2;
    private static Calendar calendar;

    public static boolean isValid() {
        return isValid || HttpCounterUtils.getHandlerNo() != null;
    }

    public static synchronized void setValid(boolean valid) {
        isValid = valid;
    }

    public static void startHttp(String url, String queryString) {
        if (HttpRpcCounter.isValid()) {
            ThreadCounter tc = new ThreadCounter();
            tc.url = url;
            tc.queryString = queryString;
            tc.begin = System.currentTimeMillis();
            counter.set(tc);
        }
    }

    public static void endHttp() {
        ThreadCounter tc = counter.get();
        counter.remove();
        if (tc == null) {
            return;
        }
        tc.end = System.currentTimeMillis();
        HttpRpcCounter.print(tc);
    }

    public static void startInvoke(Object instance, Method method, Object[] params) {
        ThreadCounter tc = counter.get();
        if (tc != null) {
            rpcInvokeFlag.set(System.currentTimeMillis());
            rpcInvokeLevel.get().incrementAndGet();
            tc.startInvoke(instance, method, params);
        }
    }

    public static void endInvoke() {
        ThreadCounter tc = counter.get();
        if (tc != null) {
            rpcInvokeFlag.remove();
            rpcInvokeLevel.get().decrementAndGet();
            tc.endInvoke();
        }
    }

    public static ArrayList getHttpRPCByHandlerNo(String handlerNo) {
        ThreadCounter tc = counter.get();
        if (tc != null) {
            return (ArrayList)tc.mapHandlerNo.get(handlerNo);
        }
        return null;
    }

    private static synchronized void print(ThreadCounter tc) {
        ArrayList invokeInfos = tc.invokeInfos;
        if (tc.invokeInfos.size() == 0) {
            return;
        }
        calendar.setTimeInMillis(tc.begin);
        String message = tc.url + ", begin: " + mdf.format(calendar.getTime()) + "\r\n";
        message = message + "param:" + tc.queryString + "\r\n";
        message = message + "thread:" + Thread.currentThread().getName() + "\r\n";
        int rpcCount = 0;
        int index = 0;
        for (OneInvokeInfo info : invokeInfos) {
            message = message + "    No " + ++index + ",rpcflag=" + info.invokefalg + ",rpcLevel=" + info.invokeLevel + ",method=" + info.methodFullName + "\r\n";
            calendar.setTimeInMillis(info.begin);
            String begin = mdf2.format(calendar.getTime());
            calendar.setTimeInMillis(info.end);
            String end = mdf2.format(calendar.getTime());
            message = message + "      cost " + (info.end - info.begin) + "ms, begin: " + begin + ",end: " + end + ".";
            message = message + "\r\n";
            rpcCount = (int)((long)rpcCount + (info.end - info.begin));
        }
        if (tc.overflow > 0) {
            message = message + "    No " + (index + 1) + "-" + (index + tc.overflow) + ", total elapse " + tc.overflowTime + "ms.";
            message = message + "\r\n";
        }
        calendar.setTimeInMillis(tc.end);
        message = message + "end: " + mdf.format(calendar.getTime());
        message = message + ", elapse " + (tc.end - tc.begin) + "ms, rpc invoke cost " + ((long)rpcCount + tc.overflowTime) + "ms, rpc invoke times:" + (invokeInfos.size() + tc.overflow) + "\r\n\r\n\r\n";
        logger.debug((Object)message);
        rpcInvokeLevel.get().set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        String deploy = System.getProperty("eas.deploy");
        String perfLog = deploy + "/PerfLog_Server.properties";
        Properties prop = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(perfLog);
            prop.load(is);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        String onoff = prop.getProperty("httprpc");
        isValid = onoff != null && onoff.equalsIgnoreCase("on");
        String filter = prop.getProperty("httprpc_filter_time");
        if (filter != null && filter.equalsIgnoreCase("on")) {
            isFilterTime = true;
            String threshold = prop.getProperty("httprpc_filter_time_threshold");
            if (threshold != null) {
                filter_time_threshold = Long.parseLong(threshold);
            }
        } else {
            isFilterTime = false;
        }
    }

    public static boolean isFilterTime() {
        return isFilterTime;
    }

    public static void setFilterTime(boolean isFilter) {
        isFilterTime = isFilter;
    }

    public static long getFilterTimeThreshold() {
        return filter_time_threshold;
    }

    public static void setFilterTimeThreshold(long threshold) {
        filter_time_threshold = threshold;
    }

    public static long getFilterVectorThreshold() {
        return filter_vector_threshold;
    }

    public static void setFilterVectorThreshold(long threshold) {
        filter_vector_threshold = threshold;
    }

    static {
        try {
            HttpRpcCounter.init();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        rpcInvokeFlag = new ThreadLocal();
        rpcInvokeLevel = new ThreadLocal<AtomicInteger>(){

            @Override
            public AtomicInteger initialValue() {
                return new AtomicInteger(0);
            }
        };
        mdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
        mdf2 = new SimpleDateFormat("HH:mm:ss:SSS");
        calendar = Calendar.getInstance();
    }

    private static class ThreadCounter {
        private String url;
        private String queryString;
        private Stack<OneInvokeInfo> invokeStack = new Stack();
        private ArrayList<OneInvokeInfo> invokeInfos = new ArrayList();
        private Map<String, ArrayList<OneInvokeInfo>> mapHandlerNo = new HashMap<String, ArrayList<OneInvokeInfo>>();
        private int overflow = 0;
        private long overflowTime = 0L;
        private long begin = System.currentTimeMillis();
        private long end;

        void startInvoke(Object instance, Method method, Object[] params) {
            String methodFullName = null;
            methodFullName = instance.getClass().getName() + "." + method.getName();
            OneInvokeInfo info = new OneInvokeInfo();
            info.methodFullName = methodFullName;
            info.begin = System.currentTimeMillis();
            info.invokefalg = rpcInvokeFlag.get();
            info.invokeLevel = rpcInvokeLevel.get().get();
            this.invokeStack.push(info);
            String handlerNo = HttpCounterUtils.getHandlerNo();
            if (null != handlerNo) {
                if (!this.mapHandlerNo.containsKey(handlerNo)) {
                    this.mapHandlerNo.put(handlerNo, new ArrayList());
                }
                this.mapHandlerNo.get(handlerNo).add(info);
            }
        }

        void endInvoke() {
            OneInvokeInfo info = this.invokeStack.pop();
            info.end = System.currentTimeMillis();
            if (!(isFilterTime && info.end - info.begin <= filter_time_threshold || !this.invokeStack.isEmpty() && HttpCounterUtils.getHandlerNo() == null)) {
                if ((long)this.invokeInfos.size() < filter_vector_threshold) {
                    this.invokeInfos.add(info);
                } else {
                    ++this.overflow;
                    this.overflowTime += info.end - info.begin;
                }
            }
        }
    }
}

