/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.invokecounter;

import com.kingdee.bos.invokecounter.InvokeKSQLCounter;
import com.kingdee.bos.invokecounter.WorkflowSqlCounter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class PerfReporter {
    private static Logger logger = Logger.getLogger(PerfReporter.class);
    static final int TopN = 10;
    Date startDate;
    Date endDate;
    String reportFile;
    String[] fileVec;
    Map timeMap = new HashMap();
    Map dbMap = new HashMap();
    Map cpuMap = new HashMap();
    Map gcCountMap = new HashMap();
    Map gcTimeMap = new HashMap();
    Map countMap = new HashMap();
    long totalCPUTime = 0L;

    public PerfReporter(String[] args) {
        try {
            this.startDate = DateFormat.getTimeInstance().parse(args[0]);
            this.endDate = DateFormat.getTimeInstance().parse(args[1]);
            this.reportFile = args[2];
            int size = args.length - 3;
            this.fileVec = new String[size];
            for (int i = 0; i < size; ++i) {
                this.fileVec[i] = args[i + 3];
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
    }

    public static List getThreadDumpByCPU() {
        int TopN = 10;
        ArrayList<Object> list = new ArrayList<Object>();
        String version = System.getProperty("java.version");
        String subStr = version.substring(0, 3);
        double versionD = Double.parseDouble(subStr);
        if (versionD >= 1.5) {
            try {
                int i;
                Class<?> facClass = Class.forName("java.lang.management.ManagementFactory");
                Method getThreadMethod = facClass.getMethod("getThreadMXBean", null);
                Object threadMX = getThreadMethod.invoke(facClass, null);
                Class<?> threadMXClass = Class.forName("java.lang.management.ThreadMXBean");
                Method threadMXMethod = threadMXClass.getMethod("getThreadCpuTime", Long.TYPE);
                Class<?> threadClass = Class.forName("java.lang.Thread");
                Method getAllStackMethod = threadClass.getMethod("getAllStackTraces", null);
                Map stackMap = (Map)getAllStackMethod.invoke(threadClass, null);
                Object[] threadVec = stackMap.keySet().toArray();
                HashMap<Long, Thread> threadMap = new HashMap<Long, Thread>();
                ArrayList<Long> cpuTimeList = new ArrayList<Long>();
                Method getIdMethod = threadClass.getMethod("getId", null);
                for (i = 0; i < threadVec.length; ++i) {
                    Thread thread = (Thread)threadVec[i];
                    Long id = (Long)getIdMethod.invoke((Object)thread, null);
                    Long cpuTime = (Long)threadMXMethod.invoke(threadMX, id);
                    threadMap.put(cpuTime, thread);
                    cpuTimeList.add(cpuTime);
                }
                Collections.sort(cpuTimeList);
                i = cpuTimeList.size() - 1;
                for (int count = 0; i >= 0 && count < TopN; --i, ++count) {
                    Long cpuTime = (Long)cpuTimeList.get(i);
                    Thread thread = (Thread)threadMap.get(cpuTime);
                    StackTraceElement[] stackVec = (StackTraceElement[])stackMap.get(thread);
                    list.add(cpuTime);
                    list.add(thread.getName());
                    list.add(stackVec);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"error:", (Throwable)ex);
            }
        }
        return list;
    }

    public static List getReport(String startTime, String endTime) {
        String fileName;
        long start = System.currentTimeMillis();
        List reList = new ArrayList();
        ArrayList<String> fileList = new ArrayList<String>();
        Logger logger1 = Logger.getLogger((String)InvokeKSQLCounter.class.getName());
        String easInstanceHome = System.getProperty("EAS_INSTANCE_HOME");
        if (logger1 != null) {
            fileName = easInstanceHome + "/logs/RpcSqlD.V60SP1.log";
            fileList.add(fileName);
        }
        if ((logger1 = Logger.getLogger((String)WorkflowSqlCounter.class.getName())) != null) {
            fileName = easInstanceHome + "/logs/WorkflowSqlD.V60SP1.log";
            fileList.add(fileName);
        }
        try {
            String[] args = new String[fileList.size() + 3];
            args[0] = startTime;
            args[1] = endTime;
            args[2] = "";
            for (int i = 0; i < fileList.size(); ++i) {
                args[i + 3] = (String)fileList.get(i);
            }
            PerfReporter worker = new PerfReporter(args);
            int size = worker.fileVec.length;
            for (int i = 0; i < size; ++i) {
                worker.work(worker.fileVec[i]);
            }
            reList = worker.report();
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        logger.info((Object)("getPerfReport timespan: " + (System.currentTimeMillis() - start) + " ms"));
        return reList;
    }

    private List report() {
        ArrayList list = new ArrayList();
        try {
            this.output(this.cpuMap, "CPU time", list);
            this.output(this.gcCountMap, "GC count", list);
            this.output(this.gcTimeMap, "GC time", list);
            this.output(this.dbMap, "DB time", list);
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        return list;
    }

    public static void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output() throws Exception {
        ArrayList list = new ArrayList();
        this.output(this.timeMap, "Invoke Time", list);
        this.output(this.cpuMap, "CPU Time", list);
        this.output(this.gcCountMap, "GC Count", list);
        this.output(this.gcTimeMap, "GC Time", list);
        this.output(this.dbMap, "DB Time", list);
        File file = new File(this.reportFile);
        if (file.exists()) {
            file.delete();
        }
        FileWriter fw = new FileWriter(this.reportFile);
        try (BufferedWriter bw = new BufferedWriter(fw);){
            bw.write("startTime: " + this.startDate + "    endTime: " + this.endDate + "\n");
            bw.write("timespan " + (this.endDate.getTime() - this.startDate.getTime()) + "    cpuTime: " + this.totalCPUTime + "\n\n");
            for (int i = 0; i < list.size(); ++i) {
                String reportName = (String)list.get(i);
                List reportList = (List)list.get(++i);
                bw.write("----------" + reportName + "----------\n");
                int j = 0;
                while (j < reportList.size()) {
                    Long value = (Long)reportList.get(j++);
                    Long count = (Long)reportList.get(j++);
                    String name = (String)reportList.get(j++);
                    bw.write(name + "(" + count + ") : " + value + "\n");
                }
                bw.write("\n");
            }
        }
    }

    private void output(Map perfMap, String reportName, ArrayList logList1) throws Exception {
        ArrayList<Object> reportList = new ArrayList<Object>();
        logList1.add(reportName);
        logList1.add(reportList);
        HashMap<Long, HashSet<String>> invokeMap = new HashMap<Long, HashSet<String>>();
        HashSet<Long> valueSet = new HashSet<Long>();
        for (String invokeName : perfMap.keySet()) {
            Long value = (Long)perfMap.get(invokeName);
            HashSet<String> nameSet = (HashSet<String>)invokeMap.get(value);
            if (nameSet == null) {
                nameSet = new HashSet<String>();
                invokeMap.put(value, nameSet);
            }
            nameSet.add(invokeName);
            valueSet.add(value);
        }
        ArrayList list = new ArrayList(valueSet);
        Collections.sort(list);
        int count = 0;
        for (int i = list.size() - 1; i >= 0 && count < 10; --i) {
            Long value = (Long)list.get(i);
            HashSet nameSet = (HashSet)invokeMap.get(value);
            Object[] nameVec = nameSet.toArray();
            for (int j = 0; j < nameVec.length && count < 10; ++count, ++j) {
                String invokeName = (String)nameVec[j];
                Long number = (Long)this.countMap.get(invokeName);
                reportList.add(value);
                reportList.add(number);
                reportList.add(invokeName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work(String file) throws Exception {
        this.timeMap.clear();
        this.dbMap.clear();
        this.cpuMap.clear();
        this.gcCountMap.clear();
        this.gcTimeMap.clear();
        this.countMap.clear();
        try (RandomAccessFile reader = new RandomAccessFile(file, "r");){
            long length = reader.length();
            long start = 0L;
            long end = length;
            long pos = (end - start) / 2L;
            long oldPos = 0L;
            String line = "";
            String subStr = "";
            Date date = null;
            boolean isFindStart = false;
            while (!isFindStart) {
                reader.seek(pos);
                line = reader.readLine();
                while (!line.endsWith(" times")) {
                    line = reader.readLine();
                    if (line != null) continue;
                    return;
                }
                reader.readLine();
                line = reader.readLine();
                subStr = line.substring(38);
                date = DateFormat.getTimeInstance().parse(subStr);
                if (date.compareTo(this.startDate) < 0) {
                    start = reader.getFilePointer();
                } else {
                    end = reader.getFilePointer();
                }
                if (start < end) {
                    pos = start + (end - start) / 2L;
                } else {
                    start = reader.getFilePointer();
                    isFindStart = true;
                }
                if (pos != oldPos) {
                    oldPos = pos;
                    continue;
                }
                isFindStart = true;
            }
            reader.seek(start);
            String tmpLine = null;
            while (true) {
                if (!(line = reader.readLine()).endsWith(" times")) {
                    continue;
                }
                reader.readLine();
                tmpLine = reader.readLine();
                subStr = tmpLine.substring(38);
                date = DateFormat.getTimeInstance().parse(subStr);
                if (date.compareTo(this.startDate) >= 0) break;
            }
            StringTokenizer token = null;
            while (true) {
                token = new StringTokenizer(line, ":");
                String invokeName = token.nextToken();
                this.count(invokeName);
                subStr = tmpLine.substring(38);
                date = DateFormat.getTimeInstance().parse(subStr);
                if (date.compareTo(this.endDate) >= 0) {
                    break;
                }
                while (!tmpLine.startsWith("dbTime:")) {
                    tmpLine = reader.readLine();
                }
                token = new StringTokenizer(tmpLine);
                token.nextToken();
                subStr = token.nextToken();
                Long dbTime = Long.valueOf(subStr);
                this.countDBTime(invokeName, dbTime);
                tmpLine = reader.readLine();
                token = new StringTokenizer(tmpLine);
                token.nextToken();
                subStr = token.nextToken();
                Long invokeTime = Long.valueOf(subStr);
                this.countTime(invokeName, invokeTime);
                token.nextToken();
                subStr = token.nextToken();
                Long cpuTime = Long.valueOf(subStr);
                this.countCPUTime(invokeName, cpuTime);
                token.nextToken();
                subStr = token.nextToken();
                Long gcCount = Long.valueOf(subStr);
                this.countGCCount(invokeName, gcCount);
                token.nextToken();
                subStr = token.nextToken();
                Long gcTime = Long.valueOf(subStr);
                this.countGCTime(invokeName, gcTime);
                line = reader.readLine();
                while (line != null && !line.endsWith(" times")) {
                    line = reader.readLine();
                }
                if (line == null) {
                    break;
                }
                reader.readLine();
                tmpLine = reader.readLine();
            }
        }
    }

    private void count(String invokeName) {
        Long sum = (Long)this.countMap.get(invokeName);
        if (sum == null) {
            this.countMap.put(invokeName, new Long(1L));
        } else {
            sum = new Long(sum + 1L);
            this.countMap.put(invokeName, sum);
        }
    }

    private void countTime(String invokeName, Long time) {
        Long sum = (Long)this.timeMap.get(invokeName);
        if (sum == null) {
            this.timeMap.put(invokeName, time);
        } else {
            sum = new Long(sum + time);
            this.timeMap.put(invokeName, sum);
        }
    }

    private void countGCTime(String invokeName, Long gcTime) {
        Long sum = (Long)this.gcTimeMap.get(invokeName);
        if (sum == null) {
            this.gcTimeMap.put(invokeName, gcTime);
        } else {
            sum = new Long(sum + gcTime);
            this.gcTimeMap.put(invokeName, sum);
        }
    }

    private void countGCCount(String invokeName, Long gcCount) {
        Long sum = (Long)this.gcCountMap.get(invokeName);
        if (sum == null) {
            this.gcCountMap.put(invokeName, gcCount);
        } else {
            sum = new Long(sum + gcCount);
            this.gcCountMap.put(invokeName, sum);
        }
    }

    private void countCPUTime(String invokeName, Long cpuTime) {
        Long sum = (Long)this.cpuMap.get(invokeName);
        if (sum == null) {
            this.cpuMap.put(invokeName, cpuTime);
        } else {
            sum = new Long(sum + cpuTime);
            this.cpuMap.put(invokeName, sum);
        }
        this.totalCPUTime += cpuTime.longValue();
    }

    private void countDBTime(String invokeName, Long dbTime) {
        Long sum = (Long)this.dbMap.get(invokeName);
        if (sum == null) {
            this.dbMap.put(invokeName, dbTime);
        } else {
            sum = new Long(sum + dbTime);
            this.dbMap.put(invokeName, sum);
        }
    }
}

