/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.invokecounter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PreOutputReporter {
    private static Logger logger = Logger.getLogger(PreOutputReporter.class);
    Date startDate;
    Date endDate;
    String reportFile;
    String[] fileVec;
    HashMap mapInvokeID2Line = new HashMap();
    HashMap mapInvokeID2Date = new HashMap();
    HashMap mapFilename2LineList = new HashMap();

    public PreOutputReporter(String[] args) {
        try {
            this.startDate = DateFormat.getTimeInstance().parse(args[0]);
            this.endDate = DateFormat.getTimeInstance().parse(args[1]);
            this.reportFile = args[2];
            int size = args.length - 3;
            this.fileVec = new String[size];
            for (int i = 0; i < size; ++i) {
                this.fileVec[i] = args[i + 3];
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length < 4) {
            System.err.println("\u751f\u6210\u914d\u7f6e\u6587\u4ef6\u7684\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u81f3\u5c11\u5e94\u8be5\u4f20\u9012\u56db\u4e2a\u53c2\u6570\uff1a\n\u53c2\u6570\u4e00\uff1a\u5f00\u59cb\u65f6\u95f4\uff0c\u4f8b\u598215:00:00\n\u53c2\u6570\u4e8c\uff1a\u7ed3\u675f\u65f6\u95f4\uff0c\u4f8b\u598217:00:00\n\u53c2\u6570\u4e09\uff1a\u62a5\u544a\u6587\u4ef6\u5168\u8def\u5f84\uff0c\u4f8b\u5982D:/PerfReport.log\n\u53c2\u6570\u56db\uff1a\u4e00\u4e2a\u9884\u8f93\u51fa\u65e5\u5fd7\u7684\u5168\u8def\u5f84\uff0c\u4f8b\u5982D:/RpcSqlPreD.log\n\u5176\u4ed6\u53c2\u6570\uff1a\u5176\u4ed6\u9884\u8f93\u51fa\u65e5\u5fd7\u7684\u5168\u8def\u5f84\n");
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            PreOutputReporter worker = new PreOutputReporter(args);
            int size = worker.fileVec.length;
            for (int i = 0; i < size; ++i) {
                worker.work(worker.fileVec[i]);
            }
            worker.output();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.info((Object)("getPerfReport timespan: " + (System.currentTimeMillis() - startTime) + " ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work(String file) throws Exception {
        Date time;
        this.mapInvokeID2Date.clear();
        this.mapInvokeID2Line.clear();
        try (RandomAccessFile reader = new RandomAccessFile(file, "r");){
            String line;
            while ((line = reader.readLine()) != null) {
                String dateStr = line.substring(line.indexOf("[") + 1, line.indexOf("]"));
                Date date = DateFormat.getDateTimeInstance().parse(dateStr);
                String timeStr = DateFormat.getTimeInstance().format(date);
                time = DateFormat.getTimeInstance().parse(timeStr);
                if (time.compareTo(this.startDate) < 0) continue;
                if (time.compareTo(this.endDate) > 0) {
                    break;
                }
                String invoke_id = line.substring(line.indexOf("invoke_id:") + 10, line.lastIndexOf(" "));
                if (line.endsWith("start")) {
                    this.mapInvokeID2Line.put(invoke_id, line);
                    this.mapInvokeID2Date.put(invoke_id, time);
                    continue;
                }
                this.mapInvokeID2Line.remove(invoke_id);
                this.mapInvokeID2Date.remove(invoke_id);
            }
        }
        Iterator iter = this.mapInvokeID2Date.keySet().iterator();
        HashMap<Date, String> mapDate2InvokeID = new HashMap<Date, String>();
        ArrayList<Date> dateList = new ArrayList<Date>();
        while (iter.hasNext()) {
            String invoke_id = (String)iter.next();
            time = (Date)this.mapInvokeID2Date.get(invoke_id);
            mapDate2InvokeID.put(time, invoke_id);
            dateList.add(time);
        }
        Collections.sort(dateList);
        ArrayList<String> lineList = new ArrayList<String>();
        int size = dateList.size();
        for (int i = 0; i < size; ++i) {
            Date time2 = (Date)dateList.get(i);
            String invoke_id = (String)mapDate2InvokeID.get(time2);
            String retainLine = (String)this.mapInvokeID2Line.get(invoke_id);
            lineList.add(retainLine);
        }
        if (lineList.size() > 0) {
            this.mapFilename2LineList.put(file, lineList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output() throws Exception {
        File file = new File(this.reportFile);
        if (file.exists()) {
            file.delete();
        }
        FileWriter fw = new FileWriter(this.reportFile);
        try (BufferedWriter bw = new BufferedWriter(fw);){
            for (String filename : this.mapFilename2LineList.keySet()) {
                bw.write(filename);
                bw.write("\n\n");
                ArrayList lineList = (ArrayList)this.mapFilename2LineList.get(filename);
                int size = lineList.size();
                for (int i = 0; i < size; ++i) {
                    String line = (String)lineList.get(i);
                    bw.write(line);
                    bw.write("\n");
                }
                bw.write("\n\n");
            }
        }
    }
}

