/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.invokecounter;

import com.kingdee.bos.invokecounter.SimpleFTP;
import com.kingdee.util.Uuid;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class RpcLogFtpUploader
extends Thread {
    public static final Logger logger = Logger.getLogger(RpcLogFtpUploader.class);
    public static RpcLogFtpUploader instance;
    public static final int bufferSize = 2048;
    public static final long interval = 432000000L;
    public static boolean isValid;
    public static String ftpHost;
    public static int ftpPort;
    public static String ftpDir;
    public static String ftpUser;
    public static String ftpPass;
    public static String propDir;
    public static String logDir;

    private RpcLogFtpUploader() {
        super("rpc log uploader");
        String deployDir = System.getProperty("easclient.root");
        String homeDir = System.getProperty("EAS_HOME");
        String logDir = homeDir + "/client/logs/";
        this.init(deployDir, logDir);
    }

    public static void addShutdownHook() {
        if (instance == null) {
            instance = new RpcLogFtpUploader();
            instance.start();
        }
    }

    public static void main(String[] argv) {
        RpcLogFtpUploader.addShutdownHook();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String propDirectory, String logDirectory) {
        long startTime = System.currentTimeMillis();
        propDir = propDirectory;
        logDir = logDirectory;
        String perfLog = propDir + "/PerfLog_Client.properties";
        Properties prop = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(perfLog);
            prop.load(is);
            String strUpload = prop.getProperty("upload");
            if (strUpload != null && strUpload.equalsIgnoreCase("on")) {
                String strPass;
                String strUser;
                String strDir;
                String strPort;
                isValid = true;
                String strHost = prop.getProperty("ftpHost");
                if (strHost != null) {
                    ftpHost = strHost;
                }
                if ((strPort = prop.getProperty("ftpPort")) != null) {
                    ftpPort = Integer.parseInt(strPort);
                }
                if ((strDir = prop.getProperty("ftpDir")) != null) {
                    ftpDir = strDir;
                }
                if ((strUser = prop.getProperty("ftpUser")) != null) {
                    ftpUser = strUser;
                }
                if ((strPass = prop.getProperty("ftpPass")) != null) {
                    ftpPass = strPass;
                }
            } else {
                isValid = false;
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"error", (Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        logger.debug((Object)("uploader init timespan: " + (System.currentTimeMillis() - startTime) + " ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        if (!isValid) {
            logger.debug((Object)"uploader is not valid! See PerfLog_Client.properties");
            return;
        }
        File zipFile = null;
        ArrayList logFileList = new ArrayList();
        try {
            logFileList = this.getOldLogList();
            if (logFileList.size() <= 0) {
                logger.debug((Object)"there's no log need to be uploaded");
                return;
            }
            SimpleFTP ftp = new SimpleFTP();
            ftp.connect(ftpHost, ftpPort, ftpUser, ftpPass);
            ftp.bin();
            ftp.mkdir(ftpDir);
            ftp.cwd(ftpDir);
            zipFile = this.compressLog(logFileList);
            ftp.stor(zipFile);
            ftp.disconnect();
            this.renameLogUploaded(logFileList);
            int size = logFileList.size();
            for (int i = 0; i < size; ++i) {
                logger.debug((Object)(logFileList.get(i) + " uploaded"));
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"error", (Throwable)ex);
        }
        finally {
            if (zipFile != null) {
                zipFile.delete();
            }
        }
        logger.debug((Object)("upload timespan: " + (System.currentTimeMillis() - startTime)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File compressLog(ArrayList logFileList) {
        File zipFile = null;
        ZipOutputStream zos = null;
        try {
            Uuid zipUUID = Uuid.create();
            zipFile = new File(logDir + "/rpclog." + zipUUID.toString() + ".zip");
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(zipFile));
            zos = new ZipOutputStream(bos);
            byte[] buffer = new byte[2048];
            int size = logFileList.size();
            for (int i = 0; i < size; ++i) {
                File logFile = (File)logFileList.get(i);
                Uuid zipEntryUUID = Uuid.create();
                zos.putNextEntry(new ZipEntry(logFile.getName() + "." + zipEntryUUID.toString()));
                try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(logFile));){
                    int length = 0;
                    while ((length = bis.read(buffer)) >= 0) {
                        zos.write(buffer, 0, length);
                    }
                    continue;
                }
            }
            zos.flush();
        }
        catch (Exception ex) {
            logger.debug((Object)"error", (Throwable)ex);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return zipFile;
    }

    private void renameLogUploaded(ArrayList logFileList) {
        int size = logFileList.size();
        for (int i = 0; i < size; ++i) {
            File file = (File)logFileList.get(i);
            file.renameTo(new File(logDir + "/" + file.getName() + ".uploaded"));
        }
    }

    private ArrayList getOldLogList() {
        ArrayList<File> logFileList = new ArrayList<File>();
        File logDirFile = new File(logDir);
        if (!logDirFile.exists() || !logDirFile.isDirectory()) {
            return logFileList;
        }
        long now = System.currentTimeMillis();
        File[] fileVec = logDirFile.listFiles();
        int size = fileVec.length;
        for (int i = 0; i < size; ++i) {
            String fileName = fileVec[i].getName();
            long fileTime = fileVec[i].lastModified();
            if (!fileName.startsWith("rpcD.") || fileName.indexOf("-") < 0 || fileName.indexOf(".uploaded") >= 0 || now - fileTime > 432000000L) continue;
            logFileList.add(fileVec[i]);
        }
        return logFileList;
    }

    static {
        isValid = false;
        ftpHost = "";
        ftpPort = 21;
        ftpDir = "";
        ftpUser = "";
        ftpPass = "";
        propDir = "";
        logDir = "";
    }
}

