/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.invokecounter;

import com.kingdee.bos.sql.shell.trace.ConnectionLogger;
import com.kingdee.bos.sql.shell.trace.KSqlMonitor;
import com.kingdee.bos.sql.shell.trace.LogItem;
import com.kingdee.bos.sql.shell.trace.LoggerDest;
import com.kingdee.bos.sql.shell.trace.TraceInfo;
import com.kingdee.util.Uuid;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SQLPlanCounter
implements LoggerDest {
    public static final Logger logger = Logger.getLogger((String)SQLPlanCounter.class.getName());
    private static Vector logItemVector = new Vector();
    private static SQLPlanCounter monitor = new SQLPlanCounter();
    private static LoggerThread loggerThread = new LoggerThread();
    public static final long cycle = 5000L;
    private static HashMap connMap = new HashMap();
    public static final String existPlanTable = "select table_name from user_tables where table_name = 'PLAN_TABLE'";
    public static final String createPlanTable = "CREATE TABLE PLAN_TABLE (STATEMENT_ID VARCHAR2(30 byte), TIMESTAMP DATE, REMARKS VARCHAR2(80 byte), OPERATION VARCHAR2(30 byte), OPTIONS VARCHAR2(255 byte), OBJECT_NODE VARCHAR2(128 byte), OBJECT_OWNER VARCHAR2(30 byte), OBJECT_NAME VARCHAR2(30 byte), OBJECT_INSTANCE NUMBER, OBJECT_TYPE VARCHAR2(30 byte), OPTIMIZER VARCHAR2(255 byte), SEARCH_COLUMNS NUMBER, ID NUMBER, PARENT_ID NUMBER, POSITION NUMBER, COST NUMBER, CARDINALITY NUMBER, BYTES NUMBER, OTHER_TAG VARCHAR2(255 byte), PARTITION_START VARCHAR2(255 byte), PARTITION_STOP VARCHAR2(255 byte), PARTITION_ID NUMBER, OTHER LONG, DISTRIBUTION VARCHAR2(30 byte), CPU_COST NUMBER, IO_COST NUMBER, TEMP_SPACE NUMBER)";
    public static final String setShowPlanAllOn = "set showplan_all on";
    public static final String[] fieldVec_Oracle = new String[]{"ID", "Depth", "Operation", "Options", "Object_Name", "Cost", "Rows", "Bytes", "CPU", "IO"};
    public static final int[] lengthVec_Oracle = new int[]{5, 7, 20, 20, 30, 8, 8, 8, 8, 5};
    public static final String[] fieldVec_SQLServer = new String[]{"ID", "Rows", "IO", "CPU", "StmtText"};
    public static final int[] lengthVec_SQLServer = new int[]{5, 15, 15, 15, 80};
    public static final String[] fieldVec_DB2 = new String[]{"ID", "Depth", "Operator", "Object_Name", "Cardi", "Cost", "IO_Cost", "CPU_Cost"};
    public static final int[] lengthVec_DB2 = new int[]{5, 10, 20, 30, 10, 10, 10, 10};
    public static final HashMap depthMap = new HashMap();
    private static boolean isValid = false;
    private static HashMap url2sqlSetMap = new HashMap();
    static boolean isFilterTime = false;
    static long filter_time_threshold = 10000L;

    public static boolean isFilterTime() {
        return isFilterTime;
    }

    public static void setFilterTime(boolean isFilter) {
        isFilterTime = isFilter;
    }

    public static long getFilterTimeThreshold() {
        return filter_time_threshold;
    }

    public static void setFilterTimeThreshold(long threshold) {
        filter_time_threshold = threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        String deploy = System.getProperty("eas.deploy");
        String perfLog = deploy + "/PerfLog_Server.properties";
        Properties prop = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(perfLog);
            prop.load(is);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        String onoff = prop.getProperty("sqlplan");
        if (onoff != null && onoff.equalsIgnoreCase("on")) {
            isValid = true;
            loggerThread.setName("Sql Plan Log Thread");
            loggerThread.setPriority(1);
            loggerThread.start();
            ConnectionLogger.addLoggerDest((LoggerDest)monitor);
        } else {
            isValid = false;
            ConnectionLogger.removeLoggerDest((LoggerDest)monitor);
        }
        String filter = prop.getProperty("sqlplan_filter_time");
        if (filter != null && filter.equalsIgnoreCase("on")) {
            isFilterTime = true;
            String threshold = prop.getProperty("sqlplan_filter_time_threshold");
            if (threshold != null) {
                filter_time_threshold = Long.parseLong(threshold);
            }
        } else {
            isFilterTime = false;
        }
    }

    public static boolean isValid() {
        return isValid;
    }

    public static synchronized void setValid(boolean valid) {
        if (valid) {
            ConnectionLogger.addLoggerDest((LoggerDest)monitor);
            loggerThread.stopThread();
            loggerThread = new LoggerThread();
            loggerThread.setName("Sql Plan Log Thread");
            loggerThread.setPriority(1);
            loggerThread.start();
        } else {
            loggerThread.stopThread();
        }
        isValid = valid;
        logItemVector.clear();
        url2sqlSetMap.clear();
    }

    public void log(LogItem logitem) {
        if (!isValid) {
            return;
        }
        if (logItemVector.size() < 10000 && (!isFilterTime || isFilterTime && logitem.timespan >= filter_time_threshold)) {
            logItemVector.add(logitem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createPlanTable(Connection conn) {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(existPlanTable);
            if (!rs.next()) {
                st.execute(createPlanTable);
            }
            conn.commit();
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error((Object)e1, (Throwable)e1);
            }
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private static void logDB2Plan(LogItem logitem) throws Exception {
        long startTime = System.currentTimeMillis();
        if (logitem.dialect_sql == null || logitem.dialect_sql.startsWith("DROP") || logitem.dialect_sql.startsWith("TRUNCATE") || logitem.dialect_sql.startsWith("CREATE") || logitem.dialect_sql.equals("SELECT 1 FROM SYSIBM.SYSDUMMY1")) {
            return;
        }
        if (SQLPlanCounter.isExplained(logitem)) {
            return;
        }
        String sql = "";
        sql = SQLPlanCounter.dealDB2SQL(logitem.dialect_sql);
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = SQLPlanCounter.getConnFromCache(logitem);
            SQLPlanCounter.getLock(conn);
            st = conn.createStatement();
            st.executeUpdate("delete from EXPLAIN_OPERATOR");
            st.executeUpdate("delete from EXPLAIN_STREAM");
            st.execute("explain plan for " + sql);
            rs = st.executeQuery("select o.operator_id, s.target_id, o.operator_type, s.object_name, s.stream_count, o.total_cost, o.io_cost, o.cpu_cost from explain_stream s left outer join explain_operator o on s.source_id = o.operator_id order by s.stream_id desc");
            SQLPlanCounter.writeDB2Log(logitem, rs, startTime);
            conn.commit();
        }
        catch (Exception e) {
            conn.rollback();
            logger.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException e) {
                logger.error((Object)e, (Throwable)e);
                throw e;
            }
        }
    }

    private static void getLock(Connection conn) {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("update T_BAS_TRANSACTION set fupdatetime=? where fnumber=?");
            ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            ps.setString(2, "getplanlog");
            ps.executeUpdate();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private static boolean isExplained(LogItem logitem) {
        boolean isExplained = false;
        Integer sql_id = logitem.getSql_id();
        String key = logitem.url + "_" + logitem.username;
        Integer url_id = key.hashCode();
        HashSet<Integer> sqlSet = (HashSet<Integer>)url2sqlSetMap.get(url_id);
        if (sqlSet == null) {
            sqlSet = new HashSet<Integer>();
            url2sqlSetMap.put(url_id, sqlSet);
        }
        if (sqlSet.contains(sql_id)) {
            isExplained = true;
        } else {
            isExplained = false;
            sqlSet.add(sql_id);
        }
        return isExplained;
    }

    private static synchronized void writeDB2Log(LogItem logitem, ResultSet rs, long startTime) throws Exception {
        logger.debug((Object)"");
        logger.debug((Object)logitem.dialect_sql);
        StringBuffer sbTmp = new StringBuffer();
        sbTmp.append("sql_id: ");
        sbTmp.append(logitem.getSql_id());
        sbTmp.append("  method: ");
        sbTmp.append(logitem.method);
        sbTmp.append("  url: ");
        sbTmp.append(logitem.url);
        logger.debug((Object)sbTmp.toString());
        logger.debug((Object)"---------------start plan-------------");
        logger.debug((Object)SQLPlanCounter.formatLine(fieldVec_DB2, lengthVec_DB2));
        int id = 0;
        depthMap.clear();
        depthMap.put(1, 0);
        ArrayList<String[]> planList = new ArrayList<String[]>();
        while (rs.next()) {
            Integer parent_depth;
            String[] strVec = new String[fieldVec_DB2.length];
            int operator_id = rs.getInt("operator_id");
            int target_id = rs.getInt("target_id");
            int depth = -1;
            if (operator_id == 0) {
                operator_id = -1;
            }
            if ((parent_depth = (Integer)depthMap.get(target_id)) == null) break;
            depth = parent_depth + 1;
            depthMap.put(operator_id, depth);
            strVec[0] = Integer.toString(id++);
            strVec[1] = Integer.toString(depth);
            strVec[2] = rs.getString("OPERATOR_TYPE");
            strVec[3] = rs.getString("OBJECT_NAME");
            strVec[4] = Long.toString((long)rs.getDouble("STREAM_COUNT"));
            strVec[5] = Long.toString((long)rs.getDouble("TOTAL_COST"));
            strVec[6] = Long.toString((long)rs.getDouble("IO_COST"));
            strVec[7] = Long.toString((long)rs.getDouble("CPU_COST"));
            planList.add(strVec);
        }
        int size = planList.size();
        for (int i = 0; i < size; ++i) {
            String[] strVec = (String[])planList.get(i);
            if (strVec[2] == null) continue;
            if (strVec[3] == null && i < size - 1) {
                String[] tmpStrVec = (String[])planList.get(i + 1);
                strVec[3] = tmpStrVec[3];
            }
            logger.debug((Object)SQLPlanCounter.formatLine(strVec, lengthVec_DB2));
        }
        logger.debug((Object)"---------------end plan-------------");
        logger.debug((Object)("get plan time: " + (System.currentTimeMillis() - startTime) + "ms"));
        logger.debug((Object)("sql time: " + logitem.timespan + "ms"));
    }

    private static String dealDB2SQL(String sql) {
        if (sql.startsWith("INSERT") && sql.indexOf("SELECT") > -1) {
            sql = sql.substring(sql.indexOf("SELECT"));
        }
        return sql;
    }

    private static void logSQLServerPlan(LogItem logitem) throws Exception {
        long startTime = System.currentTimeMillis();
        if (logitem.dialect_sql == null || logitem.dialect_sql.startsWith("DROP") || logitem.dialect_sql.startsWith("TRUNCATE") || logitem.dialect_sql.equals("SELECT 1")) {
            return;
        }
        if (SQLPlanCounter.isExplained(logitem)) {
            return;
        }
        String sql = "";
        sql = SQLPlanCounter.dealSQLServerSQL(logitem);
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = SQLPlanCounter.getConnFromCache(logitem);
            st = conn.createStatement();
            rs = st.executeQuery(sql);
            SQLPlanCounter.writeSQLServerLog(logitem, rs, startTime);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException e) {
                logger.error((Object)e, (Throwable)e);
                throw e;
            }
        }
    }

    private static synchronized void writeSQLServerLog(LogItem logitem, ResultSet rs, long startTime) throws Exception {
        logger.debug((Object)"");
        logger.debug((Object)logitem.dialect_sql);
        StringBuffer sbTmp = new StringBuffer();
        sbTmp.append("sql_id: ");
        sbTmp.append(logitem.getSql_id());
        sbTmp.append("  method: ");
        sbTmp.append(logitem.method);
        sbTmp.append("  url: ");
        sbTmp.append(logitem.url);
        logger.debug((Object)sbTmp.toString());
        logger.debug((Object)"---------------start plan-------------");
        logger.debug((Object)SQLPlanCounter.formatLine(fieldVec_SQLServer, lengthVec_SQLServer));
        try {
            int id = 0;
            while (rs.next()) {
                String[] strVec = new String[fieldVec_SQLServer.length];
                strVec[0] = Integer.toString(id++);
                strVec[1] = rs.getString("EstimateRows");
                strVec[2] = rs.getString("EstimateIO");
                strVec[3] = rs.getString("EstimateCPU");
                int nodeID = rs.getInt("NodeId");
                strVec[4] = nodeID == 1 ? "dialect_sql" : rs.getString("StmtText");
                logger.debug((Object)SQLPlanCounter.formatLine(strVec, lengthVec_SQLServer));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e, (Throwable)e);
            throw e;
        }
        logger.debug((Object)"---------------end plan-------------");
        logger.debug((Object)("get plan time: " + (System.currentTimeMillis() - startTime) + "ms"));
        logger.debug((Object)("sql time: " + logitem.timespan + "ms"));
    }

    private static String dealSQLServerSQL(LogItem logitem) {
        String sql = logitem.dialect_sql;
        List parameters = logitem.parameters;
        if (parameters == null) {
            return sql;
        }
        int seq = 0;
        Object[] paramVec = parameters.toArray();
        StringTokenizer token = new StringTokenizer(sql, "?", true);
        StringBuffer sb = new StringBuffer();
        while (token.hasMoreTokens()) {
            Object tmp = token.nextToken();
            if (tmp.equals("?")) {
                sb.append("'");
                tmp = paramVec[seq++];
                if (tmp != null) {
                    sb.append(tmp);
                }
                sb.append("'");
                continue;
            }
            sb.append(tmp);
        }
        return sb.toString();
    }

    private static void logOraclePlan(LogItem logitem) throws Exception {
        long startTime = System.currentTimeMillis();
        if (logitem.dialect_sql == null || logitem.dialect_sql.startsWith("DROP") || logitem.dialect_sql.startsWith("TRUNCATE") || logitem.dialect_sql.startsWith("CREATE") || logitem.dialect_sql.equals("SELECT 1 FROM DUAL") || logitem.dialect_sql.equals("SELECT 1 FROM VDUAL")) {
            return;
        }
        if (SQLPlanCounter.isExplained(logitem)) {
            return;
        }
        String sql = "";
        sql = SQLPlanCounter.dealOracleSQL(logitem);
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = SQLPlanCounter.getConnFromCache(logitem);
            SQLPlanCounter.getLock(conn);
            st = conn.createStatement();
            st.executeUpdate("delete from plan_table");
            st.execute("explain plan for " + sql);
            rs = st.executeQuery("select * from plan_table order by id");
            SQLPlanCounter.writeOracleLog(logitem, rs, startTime);
            conn.commit();
        }
        catch (Exception e) {
            conn.rollback();
            logger.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException e) {
                logger.error((Object)e, (Throwable)e);
                throw e;
            }
        }
    }

    private static Connection getConnFromCache(LogItem logitem) {
        Connection conn = null;
        try {
            String url = logitem.url;
            TraceInfo traceInfo = KSqlMonitor.getTraceInfo((String)url);
            if (traceInfo == null) {
                return null;
            }
            String driverName = traceInfo.driverName;
            String originalUrl = traceInfo.originalUrl;
            String username = logitem.username;
            String password = logitem.password;
            String key = originalUrl + "_" + username + "_" + password;
            conn = (Connection)connMap.get(key);
            if (conn == null) {
                Class.forName(driverName);
                Properties properties = new Properties();
                properties.put("user", username);
                properties.put("password", password);
                conn = DriverManager.getConnection(originalUrl, properties);
                connMap.put(key, conn);
                if (logitem.dbType == 7) {
                    conn.setAutoCommit(false);
                    SQLPlanCounter.initLock(conn);
                    SQLPlanCounter.createPlanTable(conn);
                } else if (logitem.dbType == 3) {
                    SQLPlanCounter.setShowPlanAllOn(conn);
                } else if (logitem.dbType == 1) {
                    conn.setAutoCommit(false);
                    SQLPlanCounter.initLock(conn);
                    SQLPlanCounter.initExplainTables(conn);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLock(Connection conn) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement("select fid from T_BAS_TRANSACTION where fnumber=?");
            ps.setString(1, "getplanlog");
            rs = ps.executeQuery();
            if (!rs.next()) {
                ps = conn.prepareStatement("insert into T_BAS_TRANSACTION (fid, fsystype, fnumber, fupdatetime, ftimecount) values (?,?,?,?,?)");
                ps.setString(1, Uuid.create().toString());
                ps.setInt(2, -1);
                ps.setString(3, "getplanlog");
                ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                ps.setInt(5, 0);
                ps.executeUpdate();
            }
            conn.commit();
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error((Object)e1, (Throwable)e1);
            }
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initExplainTables(Connection conn) {
        Statement st = null;
        try {
            st = conn.createStatement();
            st.executeUpdate("delete from EXPLAIN_ARGUMENT");
            st.executeUpdate("delete from EXPLAIN_INSTANCE");
            st.executeUpdate("delete from EXPLAIN_OBJECT");
            st.executeUpdate("delete from EXPLAIN_OPERATOR");
            st.executeUpdate("delete from EXPLAIN_PREDICATE");
            st.executeUpdate("delete from EXPLAIN_STATEMENT");
            st.executeUpdate("delete from EXPLAIN_STREAM");
            conn.commit();
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error((Object)e1, (Throwable)e1);
            }
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private static void setShowPlanAllOn(Connection conn) {
        Statement st = null;
        try {
            st = conn.createStatement();
            st.execute(setShowPlanAllOn);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private static String dealOracleSQL(LogItem logitem) {
        String sql = logitem.dialect_sql;
        List parameters = logitem.parameters;
        if (parameters == null || parameters.size() == 0) {
            return sql;
        }
        int seq = 0;
        Object[] paramVec = parameters.toArray();
        StringTokenizer token = new StringTokenizer(sql, "?", true);
        StringBuffer sb = new StringBuffer();
        while (token.hasMoreTokens()) {
            Object tmp = token.nextToken();
            if (tmp.equals("?")) {
                sb.append("'");
                tmp = paramVec[seq++];
                if (tmp != null) {
                    sb.append(tmp);
                }
                sb.append("'");
                continue;
            }
            sb.append(tmp);
        }
        return sb.toString();
    }

    private static synchronized void writeOracleLog(LogItem logitem, ResultSet rs, long startTime) throws Exception {
        logger.debug((Object)"");
        logger.debug((Object)logitem.dialect_sql);
        StringBuffer sbTmp = new StringBuffer();
        sbTmp.append("sql_id: ");
        sbTmp.append(logitem.getSql_id());
        sbTmp.append("  method: ");
        sbTmp.append(logitem.method);
        sbTmp.append("  url: ");
        sbTmp.append(logitem.url);
        sbTmp.append("  user: ");
        sbTmp.append(logitem.username);
        logger.debug((Object)sbTmp.toString());
        logger.debug((Object)"---------------start plan-------------");
        logger.debug((Object)SQLPlanCounter.formatLine(fieldVec_Oracle, lengthVec_Oracle));
        try {
            depthMap.clear();
            while (rs.next()) {
                String[] strVec = new String[fieldVec_Oracle.length];
                int id = rs.getInt("ID");
                int parent_id = rs.getInt("Parent_ID");
                int depth = 0;
                if (id == 0) {
                    depth = 0;
                } else {
                    Integer parent_depth = (Integer)depthMap.get(parent_id);
                    if (parent_depth == null) break;
                    depth = parent_depth + 1;
                }
                depthMap.put(id, depth);
                strVec[0] = Integer.toString(id);
                strVec[1] = Integer.toString(depth);
                strVec[2] = rs.getString("Operation");
                strVec[3] = rs.getString("Options");
                strVec[4] = rs.getString("Object_Name");
                strVec[5] = Long.toString(rs.getLong("Cost"));
                strVec[6] = Long.toString(rs.getLong("Cardinality"));
                strVec[7] = Long.toString(rs.getLong("Bytes"));
                strVec[8] = Long.toString(rs.getLong("CPU_Cost"));
                strVec[9] = Long.toString(rs.getLong("IO_Cost"));
                logger.debug((Object)SQLPlanCounter.formatLine(strVec, lengthVec_Oracle));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e, (Throwable)e);
            throw e;
        }
        logger.debug((Object)"---------------end plan-------------");
        logger.debug((Object)("get plan time: " + (System.currentTimeMillis() - startTime) + "ms"));
        logger.debug((Object)("sql time: " + logitem.timespan + "ms"));
    }

    private static String formatLine(String[] fieldVec, int[] lengthVec) {
        StringBuffer sb = new StringBuffer();
        int totalLen = 0;
        int count = fieldVec.length;
        for (int i = 0; i < count; ++i) {
            totalLen += lengthVec[i];
            if (fieldVec[i] != null) {
                if (!fieldVec[i].equals("null")) {
                    sb.append(fieldVec[i]);
                } else {
                    sb.append(" ");
                }
            } else {
                sb.append(" ");
            }
            sb.append(",");
            SQLPlanCounter.appendBlank(sb, totalLen - sb.length());
        }
        return sb.toString();
    }

    private static void appendBlank(StringBuffer sb, int blankNumber) {
        for (int i = 0; i < blankNumber; ++i) {
            sb.append(" ");
        }
    }

    public static String getLogPlan(LogItem logitem) throws Exception {
        if (null == logitem) {
            return null;
        }
        if (logitem.dbType == 7 || logitem.dbType == 8) {
            return SQLPlanCounter.logOraclePlanForGet(logitem);
        }
        if (logitem.dbType == 3 || logitem.dbType == 1) {
            // empty if block
        }
        return null;
    }

    private static String logOraclePlanForGet(LogItem logitem) throws Exception {
        long startTime = System.currentTimeMillis();
        if (logitem.dialect_sql == null || logitem.dialect_sql.startsWith("DROP") || logitem.dialect_sql.startsWith("TRUNCATE") || logitem.dialect_sql.startsWith("CREATE") || logitem.dialect_sql.equals("SELECT 1 FROM DUAL") || logitem.dialect_sql.equals("SELECT 1 FROM VDUAL")) {
            return "Not support plan";
        }
        String sql = "";
        sql = SQLPlanCounter.dealOracleSQL(logitem);
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = SQLPlanCounter.getConnFromCache(logitem);
            SQLPlanCounter.getLock(conn);
            st = conn.createStatement();
            st.executeUpdate("delete from plan_table");
            st.execute("explain plan for " + sql);
            rs = st.executeQuery("select * from plan_table order by id");
            StringBuffer sbTmp = new StringBuffer();
            sbTmp.append(sql).append("\r\n");
            sbTmp.append("sql_id: ");
            sbTmp.append(logitem.getSql_id());
            sbTmp.append("  method: ");
            sbTmp.append(logitem.method);
            sbTmp.append("  url: ");
            sbTmp.append(logitem.url);
            sbTmp.append("  user: ");
            sbTmp.append(logitem.username).append("\r\n");
            sbTmp.append("---------------start plan-------------").append("\r\n");
            sbTmp.append(SQLPlanCounter.formatLine(fieldVec_Oracle, lengthVec_Oracle)).append("\r\n");
            try {
                HashMap<Integer, Integer> depthMap = new HashMap<Integer, Integer>();
                while (rs.next()) {
                    String[] strVec = new String[fieldVec_Oracle.length];
                    int id = rs.getInt("ID");
                    int parent_id = rs.getInt("Parent_ID");
                    int depth = 0;
                    if (id == 0) {
                        depth = 0;
                    } else {
                        Integer parent_depth = (Integer)depthMap.get(parent_id);
                        if (parent_depth == null) break;
                        depth = parent_depth + 1;
                    }
                    depthMap.put(id, depth);
                    strVec[0] = Integer.toString(id);
                    strVec[1] = Integer.toString(depth);
                    strVec[2] = rs.getString("Operation");
                    strVec[3] = rs.getString("Options");
                    strVec[4] = rs.getString("Object_Name");
                    strVec[5] = Long.toString(rs.getLong("Cost"));
                    strVec[6] = Long.toString(rs.getLong("Cardinality"));
                    strVec[7] = Long.toString(rs.getLong("Bytes"));
                    strVec[8] = Long.toString(rs.getLong("CPU_Cost"));
                    strVec[9] = Long.toString(rs.getLong("IO_Cost"));
                    sbTmp.append(SQLPlanCounter.formatLine(strVec, lengthVec_Oracle)).append("\r\n");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e, (Throwable)e);
                throw e;
            }
            sbTmp.append("---------------end plan-------------").append("\r\n");
            sbTmp.append("get plan time: " + (System.currentTimeMillis() - startTime) + "ms").append("\r\n");
            sbTmp.append("sql time: " + logitem.timespan + "ms").append("\r\n");
            conn.commit();
            String string = sbTmp.toString();
            return string;
        }
        catch (Exception e) {
            conn.rollback();
            logger.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException e) {
                logger.error((Object)e, (Throwable)e);
                throw e;
            }
        }
    }

    static class LoggerThread
    extends Thread {
        private boolean isRunnable = true;

        LoggerThread() {
        }

        public void stopThread() {
            this.isRunnable = false;
        }

        @Override
        public void run() {
            while (this.isRunnable || logItemVector.size() > 0) {
                try {
                    Thread.sleep(5000L);
                    Object[] logItemVec = logItemVector.toArray();
                    logItemVector.clear();
                    for (int i = 0; i < logItemVec.length; ++i) {
                        LogItem logitem = (LogItem)logItemVec[i];
                        if (logitem.dbType == 7 || logitem.dbType == 8) {
                            SQLPlanCounter.logOraclePlan(logitem);
                            continue;
                        }
                        if (logitem.dbType == 3 || logitem.dbType != 1) continue;
                        SQLPlanCounter.logDB2Plan(logitem);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
            for (Connection conn : connMap.values()) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
            connMap.clear();
        }
    }
}

