/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.logging.management;

import com.kingdee.bos.logging.management.LoggingMBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Logging
implements LoggingMBean {
    @Override
    public String[] getLoggers() {
        Enumeration e = LogManager.getCurrentLoggers();
        ArrayList<String> loggersList = new ArrayList<String>();
        while (e.hasMoreElements()) {
            String loggerName = ((Logger)e.nextElement()).getName();
            loggersList.add(loggerName + "=" + this.getLoggerLevel(loggerName));
        }
        Object[] loggers = loggersList.toArray(new String[0]);
        Arrays.sort(loggers);
        return loggers;
    }

    @Override
    public String getLoggerLevel(String loggerName) {
        for (Logger cat = Logger.getLogger((String)loggerName); cat != null; cat = cat.getParent()) {
            if (cat.getLevel() == null) continue;
            return cat.getLevel().toString();
        }
        return null;
    }

    @Override
    public void setLoggerLevel(String loggerName, String level) {
        Logger logger;
        if (level == null || loggerName == null) {
            return;
        }
        Level l = Level.toLevel((String)level.toUpperCase());
        if (l != null && (logger = Logger.getLogger((String)loggerName)) != null) {
            logger.setLevel(l);
        }
    }

    @Override
    public String getParentLoggerName(String loggerName) {
        Logger l = LogManager.getLogger((String)loggerName);
        if (l == null) {
            return null;
        }
        Category p = l.getParent();
        if (p == null) {
            return "";
        }
        return p.getName();
    }

    @Override
    public void setParentLoggerLevel(String loggerName, String level) {
        Category parent;
        Logger logger;
        if (level == null || loggerName == null) {
            return;
        }
        Level l = Level.toLevel((String)level.toUpperCase());
        if (l != null && (logger = LogManager.getLogger((String)loggerName)) != null && (parent = logger.getParent()) != null) {
            parent.setLevel(l);
        }
    }
}

