/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.management;

import com.kingdee.bos.management.CannotCreateMBeanException;
import com.kingdee.bos.management.CannotRemoveMBeanException;
import com.kingdee.bos.management.MBeanMetadata;
import com.kingdee.bos.management.config.InvalidMBeanMetadataException;
import com.kingdee.bos.management.config.MBeanConfig;
import com.kingdee.bos.management.config.MBeanConfigManager;
import com.kingdee.bos.management.util.ObjectNameHelper;
import java.util.ArrayList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class MBeanFactory {
    private static final Logger logger = Logger.getLogger(MBeanFactory.class);
    public static final MBeanServer MBEAN_SERVER;

    private MBeanFactory() {
    }

    public static synchronized void createAutoStartMBeans() throws CannotCreateMBeanException {
        MBeanConfig config = MBeanConfigManager.getConfig();
        String[] ids = config.getAutoStartMBeans();
        for (int i = 0; i < ids.length; ++i) {
            MBeanFactory.createMBean(ids[i]);
        }
    }

    public static ObjectInstance createMBean(String mbeanId) throws CannotCreateMBeanException, InvalidMBeanMetadataException {
        return MBeanFactory.registerMBean(null, mbeanId);
    }

    public static ObjectInstance registerMBean(Object mbean, String mbeanId) throws CannotCreateMBeanException, InvalidMBeanMetadataException {
        return MBeanFactory.registerMBean(mbean, mbeanId, null);
    }

    public static ObjectInstance createMBean(String mbeanId, String instanceName) throws CannotCreateMBeanException, InvalidMBeanMetadataException {
        return MBeanFactory.registerMBean(null, mbeanId, instanceName);
    }

    public static ObjectInstance registerMBean(Object mbean, String mbeanId, String instanceName) throws CannotCreateMBeanException, InvalidMBeanMetadataException {
        String string = mbeanId.intern();
        synchronized (string) {
            MBeanMetadata md = MBeanConfigManager.getConfig().getMBeanMetadata(mbeanId);
            if (md == null) {
                throw new InvalidMBeanMetadataException("metadata null:" + mbeanId);
            }
            try {
                ObjectName mbeanObjectName = new ObjectName(new ObjectNameHelper(md, instanceName).toString());
                ObjectInstance objInst = null;
                if (mbean == null) {
                    try {
                        mbean = Class.forName(md.getClassName()).newInstance();
                    }
                    catch (Exception ex) {
                        throw new CannotCreateMBeanException(ex.getMessage());
                    }
                }
                objInst = MBEAN_SERVER.registerMBean(mbean, mbeanObjectName);
                return objInst;
            }
            catch (JMException jme) {
                logger.error((Object)jme.getMessage(), (Throwable)jme);
                throw new CannotCreateMBeanException(jme.getMessage());
            }
        }
    }

    public static void unregisterMBean(ObjectName objName) throws InvalidMBeanMetadataException {
        try {
            MBEAN_SERVER.unregisterMBean(objName);
        }
        catch (JMException jme) {
            logger.error((Object)jme.getMessage(), (Throwable)jme);
            throw new CannotRemoveMBeanException(jme.getMessage());
        }
    }

    public static void unregisterMBean(String mbeanId) {
        MBeanFactory.unregisterMBean(mbeanId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterMBean(String mbeanId, String instanceName) throws CannotRemoveMBeanException, InvalidMBeanMetadataException {
        String string = mbeanId.intern();
        synchronized (string) {
            MBeanMetadata md = MBeanConfigManager.getConfig().getMBeanMetadata(mbeanId);
            if (md == null) {
                throw new InvalidMBeanMetadataException("metadata null:" + mbeanId);
            }
            try {
                ObjectName mbeanObjectName = new ObjectName(new ObjectNameHelper(md, instanceName).toString());
                MBEAN_SERVER.unregisterMBean(mbeanObjectName);
            }
            catch (JMException jme) {
                logger.error((Object)jme.getMessage(), (Throwable)jme);
                throw new CannotRemoveMBeanException(jme.getMessage());
            }
        }
    }

    static {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        MBEAN_SERVER = servers != null && servers.size() > 0 ? (MBeanServer)servers.get(0) : MBeanServerFactory.createMBeanServer();
    }
}

