/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.jmx;

import com.kingdee.bos.rpc.jmx.PerformanceService;
import com.kingdee.bos.rpc.performance.MaxInvokeMonitor;
import com.kingdee.bos.rpc.performance.MethodRecord;
import java.lang.reflect.Field;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;

public class InvokeMonitorService
implements DynamicMBean {
    private MethodRecord lastRequest = null;
    private MethodRecord lastResponse = null;
    private static final String REQUEST = "max_request";
    private static final String RESPONSE = "max_response";
    private static final String STATE = "invoke_monitor";
    public static final String START_MONITOR = "startInvokeMonitor";
    public static final String STOP_MONITOR = "stopInvokeMonitor";
    public static final String RESET_MONITOR = "resetInvokeMonitor";
    private MaxInvokeMonitor invokeMonitor = null;

    @Override
    public synchronized Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (name.equals(STATE)) {
            if (this.invokeMonitor == null) {
                return "not running";
            }
            return "running";
        }
        int i = name.indexOf(46);
        if (i < 0) {
            throw new AttributeNotFoundException(name);
        }
        String type = name.substring(0, i);
        name = name.substring(i + 1);
        MethodRecord rec = null;
        if (this.invokeMonitor != null) {
            if (type.equals(REQUEST)) {
                this.lastRequest = rec = this.invokeMonitor.getRequest();
            } else if (type.equals(RESPONSE)) {
                this.lastResponse = rec = this.invokeMonitor.getResponse();
            }
        } else if (type.equals(REQUEST)) {
            rec = this.lastRequest;
        } else if (type.equals(RESPONSE)) {
            rec = this.lastResponse;
        }
        if (rec != null) {
            try {
                Field fd = MethodRecord.class.getField(name);
                return fd.get(rec);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public synchronized AttributeList getAttributes(String[] names) {
        AttributeList l = new AttributeList();
        for (int i = 0; i < names.length; ++i) {
            try {
                l.add(new Attribute(names[i], this.getAttribute(names[i])));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return l;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        Class<MethodRecord> cls = MethodRecord.class;
        Field[] fds = cls.getFields();
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[fds.length * 2 + 1];
        attrs[0] = new MBeanAttributeInfo(STATE, "java.lang.String", null, true, false, false);
        for (int i = 0; i < fds.length; ++i) {
            attrs[i + 1] = new MBeanAttributeInfo("max_request." + fds[i].getName(), fds[i].getType().getName(), null, true, false, false);
            attrs[i + fds.length + 1] = new MBeanAttributeInfo("max_response." + fds[i].getName(), fds[i].getType().getName(), null, true, false, false);
        }
        MBeanOperationInfo[] ops = new MBeanOperationInfo[]{new MBeanOperationInfo(START_MONITOR, START_MONITOR, null, "void", 1), new MBeanOperationInfo(STOP_MONITOR, STOP_MONITOR, null, "void", 1), new MBeanOperationInfo(RESET_MONITOR, RESET_MONITOR, null, "void", 1)};
        return new MBeanInfo(PerformanceService.class.getName(), "RPC Invoke Monitor", attrs, null, ops, null);
    }

    public synchronized void startInvokeMonitor() {
        if (this.invokeMonitor == null) {
            this.invokeMonitor = new MaxInvokeMonitor();
            this.invokeMonitor.install();
        }
    }

    public synchronized void stopInvokeMonitor() {
        if (this.invokeMonitor != null) {
            this.invokeMonitor.restore();
            this.invokeMonitor = null;
        }
    }

    public synchronized void resetInvokeMonitor() {
        if (this.invokeMonitor != null) {
            this.invokeMonitor.reset();
        }
    }

    @Override
    public synchronized Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        if (method.equals(START_MONITOR)) {
            this.startInvokeMonitor();
        } else if (method.equals(STOP_MONITOR)) {
            this.stopInvokeMonitor();
        } else if (method.equals(RESET_MONITOR)) {
            this.resetInvokeMonitor();
        }
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }
}

