/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.jmx;

import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.io.server.TCPServer;
import com.kingdee.bos.rpc.jmx.RPCServiceMBean;
import java.io.IOException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;

public class RPCService
extends StandardMBean
implements RPCServiceMBean {
    private static Logger logger = Logger.getLogger(RPCService.class);
    private TCPServer server = null;

    public RPCService() throws NotCompliantMBeanException {
        super(RPCServiceMBean.class);
    }

    @Override
    public boolean getInvokeMonitorInstalled() {
        ServerManager.getConfig();
        return RPCConfig.invokeMonitors.length > 0;
    }

    @Override
    public synchronized void startTCPServer() throws IOException {
        try {
            if (this.server == null) {
                this.server = new TCPServer();
            }
            this.server.start();
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    @Override
    public synchronized void stopTCPServer() throws IOException {
        this.server.shutdown();
        this.server = null;
    }

    @Override
    public boolean getGenerateProxyStubSource() {
        return ServerManager.getConfig().generateProxyStubSource;
    }

    @Override
    public void setGenerateProxyStubSource(boolean value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.generateProxyStubSource = value;
        this.setConfig(conf);
    }

    @Override
    public boolean getSaveProxyStubClass() {
        return ServerManager.getConfig().saveProxyStubClass;
    }

    @Override
    public void setSaveProxyStubClass(boolean value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.saveProxyStubClass = value;
        this.setConfig(conf);
    }

    @Override
    public int getStreamBufferSize() {
        return ServerManager.getConfig().streamBufferSize;
    }

    @Override
    public void setStreamBufferSize(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.streamBufferSize = value;
        this.setConfig(conf);
    }

    @Override
    public int getBlockBufferSize() {
        return ServerManager.getConfig().blockBufferSize;
    }

    @Override
    public void setBlockBufferSize(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.blockBufferSize = value;
        this.setConfig(conf);
    }

    @Override
    public int getThreadPoolMinSize() {
        return ServerManager.getConfig().threadPoolMinSize;
    }

    @Override
    public void setThreadPoolMinSize(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.threadPoolMinSize = value;
        this.setConfig(conf);
    }

    @Override
    public int getThreadPoolMaxSize() {
        return ServerManager.getConfig().threadPoolMaxSize;
    }

    @Override
    public void setThreadPoolMaxSize(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.threadPoolMaxSize = value;
        this.setConfig(conf);
    }

    @Override
    public long getThreadPoolIdleTimeout() {
        return ServerManager.getConfig().threadPoolIdleTimeout;
    }

    @Override
    public void setThreadPoolIdleTimeout(long value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.threadPoolIdleTimeout = value;
        this.setConfig(conf);
    }

    @Override
    public int getMaxServiceThreadCount() {
        return ServerManager.getConfig().maxServiceThreadCount;
    }

    @Override
    public void setMaxServiceThreadCount(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.maxServiceThreadCount = value;
        this.setConfig(conf);
    }

    @Override
    public int getMinServiceThreadCount() {
        return ServerManager.getConfig().minServiceThreadCount;
    }

    @Override
    public void setMinServiceThreadCount(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.minServiceThreadCount = value;
        this.setConfig(conf);
    }

    @Override
    public boolean getLogIOExceptions() {
        return ServerManager.getConfig().logIOExceptions;
    }

    @Override
    public void setLogIOExceptions(boolean value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.logIOExceptions = value;
        this.setConfig(conf);
    }

    @Override
    public String getDefaultHttpUrl() {
        return ServerManager.getConfig().defaultHttpUrl;
    }

    @Override
    public void setDefaultHttpUrl(String value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.defaultHttpUrl = value;
        this.setConfig(conf);
    }

    @Override
    public int getConnectionRetryTime() {
        return ServerManager.getConfig().connectionRetryTime;
    }

    @Override
    public void setConnectionRetryTime(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.connectionRetryTime = value;
        this.setConfig(conf);
    }

    @Override
    public int getMaxStubReleaseSize() {
        return ServerManager.getConfig().maxStubReleaseSize;
    }

    @Override
    public void setMaxStubReleaseSize(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.maxStubReleaseSize = value;
        this.setConfig(conf);
    }

    @Override
    public long getReleaseDelayInterval() {
        return ServerManager.getConfig().releaseDelayInterval;
    }

    @Override
    public void setReleaseDelayInterval(long value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.releaseDelayInterval = value;
        this.setConfig(conf);
    }

    @Override
    public int getMaxInvokeDataSize() {
        return ServerManager.getConfig().maxInvokeDataSize;
    }

    @Override
    public void setMaxInvokeDataSize(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.maxInvokeDataSize = value;
        this.setConfig(conf);
    }

    @Override
    public int getMaxCompressedDataSize() {
        return ServerManager.getConfig().maxCompressedDataSize;
    }

    @Override
    public void setMaxCompressedDataSize(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.maxCompressedDataSize = value;
        this.setConfig(conf);
    }

    @Override
    public int getMinCompressSize() {
        return ServerManager.getConfig().minCompressSize;
    }

    @Override
    public void setMinCompressSize(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.minCompressSize = value;
        this.setConfig(conf);
    }

    @Override
    public boolean getCompressOnlyRemote() {
        return ServerManager.getConfig().compressOnlyRemote;
    }

    @Override
    public void setCompressOnlyRemote(boolean value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.compressOnlyRemote = value;
        this.setConfig(conf);
    }

    @Override
    public boolean getLogObjectCreate() {
        return ServerManager.getConfig().logObjectCreate;
    }

    @Override
    public void setLogObjectCreate(boolean value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.logObjectCreate = value;
        this.setConfig(conf);
    }

    @Override
    public boolean getLogObjectRelease() {
        return ServerManager.getConfig().logObjectRelease;
    }

    @Override
    public void setLogObjectRelease(boolean value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.logObjectRelease = value;
        this.setConfig(conf);
    }

    @Override
    public boolean getLogObjectFinalize() {
        return ServerManager.getConfig().logObjectFinalize;
    }

    @Override
    public void setLogObjectFinalize(boolean value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.logObjectFinalize = value;
        this.setConfig(conf);
    }

    @Override
    public boolean getLogSessionCreate() {
        return ServerManager.getConfig().logSessionCreate;
    }

    @Override
    public void setLogSessionCreate(boolean value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.logSessionCreate = value;
        this.setConfig(conf);
    }

    @Override
    public boolean getLogSessionClose() {
        return ServerManager.getConfig().logSessionClose;
    }

    @Override
    public void setLogSessionClose(boolean value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.logSessionClose = value;
        this.setConfig(conf);
    }

    @Override
    public boolean getLogSessionTimeout() {
        return ServerManager.getConfig().logSessionTimeout;
    }

    @Override
    public void setLogSessionTimeout(boolean value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.logSessionTimeout = value;
        this.setConfig(conf);
    }

    @Override
    public boolean getLogSessionFinalize() {
        return ServerManager.getConfig().logSessionFinalize;
    }

    @Override
    public void setLogSessionFinalize(boolean value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.logSessionFinalize = value;
        this.setConfig(conf);
    }

    @Override
    public boolean getLogSessionKeepAlive() {
        return ServerManager.getConfig().logSessionKeepAlive;
    }

    @Override
    public void setLogSessionKeepAlive(boolean value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.logSessionKeepAlive = value;
        this.setConfig(conf);
    }

    @Override
    public long getMonitorIntervalTime() {
        return ServerManager.getConfig().monitorIntervalTime;
    }

    @Override
    public void setMonitorIntervalTime(long value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.monitorIntervalTime = value;
        this.setConfig(conf);
    }

    @Override
    public long getSessionTimeout() {
        return ServerManager.getConfig().sessionTimeout;
    }

    @Override
    public void setSessionTimeout(long value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.sessionTimeout = value;
        this.setConfig(conf);
    }

    @Override
    public long getSessionKeepAliveInterval() {
        return ServerManager.getConfig().sessionKeepAliveInterval;
    }

    @Override
    public void setSessionKeepAliveInterval(long value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.sessionKeepAliveInterval = value;
        this.setConfig(conf);
    }

    @Override
    public long getHttpConnectionTimeout() {
        return ServerManager.getConfig().httpConnectionTimeout;
    }

    @Override
    public void setHttpConnectionTimeout(long value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.httpConnectionTimeout = value;
        this.setConfig(conf);
    }

    @Override
    public int getTcpHandshakeTimeout() {
        return ServerManager.getConfig().tcpHandshakeTimeout;
    }

    @Override
    public void setTcpHandshakeTimeout(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.tcpHandshakeTimeout = value;
        this.setConfig(conf);
    }

    @Override
    public int getTcpServiceTimeout() {
        return ServerManager.getConfig().tcpServiceTimeout;
    }

    @Override
    public void setTcpServiceTimeout(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.tcpServiceTimeout = value;
        this.setConfig(conf);
    }

    @Override
    public long getNioSelectTimeout() {
        return ServerManager.getConfig().nioSelectTimeout;
    }

    @Override
    public void setNioSelectTimeout(long value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.nioSelectTimeout = value;
        this.setConfig(conf);
    }

    @Override
    public long getNioWaitTimeout() {
        return ServerManager.getConfig().nioWaitTimeout;
    }

    @Override
    public void setNioWaitTimeout(long value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.nioWaitTimeout = value;
        this.setConfig(conf);
    }

    @Override
    public int getNioMaxConnectionsPerSelector() {
        return ServerManager.getConfig().nioMaxConnectionsPerSelector;
    }

    @Override
    public void setNioMaxConnectionsPerSelector(int value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.nioMaxConnectionsPerSelector = value;
        this.setConfig(conf);
    }

    @Override
    public long getLoadbalanceConnectionRetryTime() {
        return ServerManager.getConfig().loadbalanceConnectionRetryTime;
    }

    @Override
    public void setLoadbalanceConnectionRetryTime(long value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.loadbalanceConnectionRetryTime = value;
        this.setConfig(conf);
    }

    @Override
    public boolean getUseConnectionPool() {
        return ServerManager.getConfig().useConnectionPool;
    }

    @Override
    public void setUseConnectionPool(boolean value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.useConnectionPool = value;
        this.setConfig(conf);
    }

    @Override
    public long getMinConnectionInterval() {
        return ServerManager.getConfig().minConnectionInterval;
    }

    @Override
    public void setMinConnectionInterval(long value) {
        RPCConfig conf = ServerManager.getConfig().copy();
        conf.minConnectionInterval = value;
        this.setConfig(conf);
    }

    @Override
    public boolean getInvokeMonitorInstalled(String serverName) {
        ServerManager.getConfig((String)serverName);
        return RPCConfig.invokeMonitors.length > 0;
    }

    @Override
    public boolean getGenerateProxyStubSource(String serverName) {
        return ServerManager.getConfig((String)serverName).generateProxyStubSource;
    }

    @Override
    public void setGenerateProxyStubSource(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.generateProxyStubSource = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public boolean getSaveProxyStubClass(String serverName) {
        return ServerManager.getConfig((String)serverName).saveProxyStubClass;
    }

    @Override
    public void setSaveProxyStubClass(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.saveProxyStubClass = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public int getStreamBufferSize(String serverName) {
        return ServerManager.getConfig((String)serverName).streamBufferSize;
    }

    @Override
    public void setStreamBufferSize(String serverName, int value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.streamBufferSize = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public int getBlockBufferSize(String serverName) {
        return ServerManager.getConfig((String)serverName).blockBufferSize;
    }

    @Override
    public void setBlockBufferSize(String serverName, int value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.blockBufferSize = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public int getMaxServiceThreadCount(String serverName) {
        return ServerManager.getConfig((String)serverName).maxServiceThreadCount;
    }

    @Override
    public void setMaxServiceThreadCount(String serverName, int value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.maxServiceThreadCount = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public int getMinServiceThreadCount(String serverName) {
        return ServerManager.getConfig((String)serverName).minServiceThreadCount;
    }

    @Override
    public void setMinServiceThreadCount(String serverName, int value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.minServiceThreadCount = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public boolean getLogIOExceptions(String serverName) {
        return ServerManager.getConfig((String)serverName).logIOExceptions;
    }

    @Override
    public void setLogIOExceptions(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.logIOExceptions = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public String getDefaultHttpUrl(String serverName) {
        return ServerManager.getConfig((String)serverName).defaultHttpUrl;
    }

    @Override
    public void setDefaultHttpUrl(String serverName, String value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.defaultHttpUrl = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public int getConnectionRetryTime(String serverName) {
        return ServerManager.getConfig((String)serverName).connectionRetryTime;
    }

    @Override
    public void setConnectionRetryTime(String serverName, int value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.connectionRetryTime = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public int getMaxStubReleaseSize(String serverName) {
        return ServerManager.getConfig((String)serverName).maxStubReleaseSize;
    }

    @Override
    public void setMaxStubReleaseSize(String serverName, int value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.maxStubReleaseSize = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public long getReleaseDelayInterval(String serverName) {
        return ServerManager.getConfig((String)serverName).releaseDelayInterval;
    }

    @Override
    public void setReleaseDelayInterval(String serverName, long value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.releaseDelayInterval = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public int getMaxInvokeDataSize(String serverName) {
        return ServerManager.getConfig((String)serverName).maxInvokeDataSize;
    }

    @Override
    public void setMaxInvokeDataSize(String serverName, int value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.maxInvokeDataSize = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public int getMaxCompressedDataSize(String serverName) {
        return ServerManager.getConfig((String)serverName).maxCompressedDataSize;
    }

    @Override
    public void setMaxCompressedDataSize(String serverName, int value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.maxCompressedDataSize = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public int getMinCompressSize(String serverName) {
        return ServerManager.getConfig((String)serverName).minCompressSize;
    }

    @Override
    public void setMinCompressSize(String serverName, int value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.minCompressSize = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public boolean getCompressOnlyRemote(String serverName) {
        return ServerManager.getConfig((String)serverName).compressOnlyRemote;
    }

    @Override
    public void setCompressOnlyRemote(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.compressOnlyRemote = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public boolean getLogObjectCreate(String serverName) {
        return ServerManager.getConfig((String)serverName).logObjectCreate;
    }

    @Override
    public void setLogObjectCreate(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.logObjectCreate = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public boolean getLogObjectRelease(String serverName) {
        return ServerManager.getConfig((String)serverName).logObjectRelease;
    }

    @Override
    public void setLogObjectRelease(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.logObjectRelease = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public boolean getLogObjectFinalize(String serverName) {
        return ServerManager.getConfig((String)serverName).logObjectFinalize;
    }

    @Override
    public void setLogObjectFinalize(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.logObjectFinalize = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public boolean getLogSessionCreate(String serverName) {
        return ServerManager.getConfig((String)serverName).logSessionCreate;
    }

    @Override
    public void setLogSessionCreate(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.logSessionCreate = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public boolean getLogSessionClose(String serverName) {
        return ServerManager.getConfig((String)serverName).logSessionClose;
    }

    @Override
    public void setLogSessionClose(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.logSessionClose = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public boolean getLogSessionTimeout(String serverName) {
        return ServerManager.getConfig((String)serverName).logSessionTimeout;
    }

    @Override
    public void setLogSessionTimeout(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.logSessionTimeout = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public boolean getLogSessionFinalize(String serverName) {
        return ServerManager.getConfig((String)serverName).logSessionFinalize;
    }

    @Override
    public void setLogSessionFinalize(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.logSessionFinalize = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public boolean getLogSessionKeepAlive(String serverName) {
        return ServerManager.getConfig((String)serverName).logSessionKeepAlive;
    }

    @Override
    public void setLogSessionKeepAlive(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.logSessionKeepAlive = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public long getMonitorIntervalTime(String serverName) {
        return ServerManager.getConfig((String)serverName).monitorIntervalTime;
    }

    @Override
    public void setMonitorIntervalTime(String serverName, long value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.monitorIntervalTime = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public long getSessionTimeout(String serverName) {
        return ServerManager.getConfig((String)serverName).sessionTimeout;
    }

    @Override
    public void setSessionTimeout(String serverName, long value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.sessionTimeout = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public long getSessionKeepAliveInterval(String serverName) {
        return ServerManager.getConfig((String)serverName).sessionKeepAliveInterval;
    }

    @Override
    public void setSessionKeepAliveInterval(String serverName, long value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.sessionKeepAliveInterval = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public long getHttpConnectionTimeout(String serverName) {
        return ServerManager.getConfig((String)serverName).httpConnectionTimeout;
    }

    @Override
    public void setHttpConnectionTimeout(String serverName, long value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.httpConnectionTimeout = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public int getTcpHandshakeTimeout(String serverName) {
        return ServerManager.getConfig((String)serverName).tcpHandshakeTimeout;
    }

    @Override
    public void setTcpHandshakeTimeout(String serverName, int value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.tcpHandshakeTimeout = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public int getTcpServiceTimeout(String serverName) {
        return ServerManager.getConfig((String)serverName).tcpServiceTimeout;
    }

    @Override
    public void setTcpServiceTimeout(String serverName, int value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.tcpServiceTimeout = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public long getNioSelectTimeout(String serverName) {
        return ServerManager.getConfig((String)serverName).nioSelectTimeout;
    }

    @Override
    public void setNioSelectTimeout(String serverName, long value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.nioSelectTimeout = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public long getNioWaitTimeout(String serverName) {
        return ServerManager.getConfig((String)serverName).nioWaitTimeout;
    }

    @Override
    public void setNioWaitTimeout(String serverName, long value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.nioWaitTimeout = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public int getNioMaxConnectionsPerSelector(String serverName) {
        return ServerManager.getConfig((String)serverName).nioMaxConnectionsPerSelector;
    }

    @Override
    public void setNioMaxConnectionsPerSelector(String serverName, int value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.nioMaxConnectionsPerSelector = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public long getLoadbalanceConnectionRetryTime(String serverName) {
        return ServerManager.getConfig((String)serverName).loadbalanceConnectionRetryTime;
    }

    @Override
    public void setLoadbalanceConnectionRetryTime(String serverName, long value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.loadbalanceConnectionRetryTime = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public boolean getUseConnectionPool(String serverName) {
        return ServerManager.getConfig((String)serverName).useConnectionPool;
    }

    @Override
    public void setUseConnectionPool(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.useConnectionPool = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public long getMinConnectionInterval(String serverName) {
        return ServerManager.getConfig((String)serverName).minConnectionInterval;
    }

    @Override
    public void setMinConnectionInterval(String serverName, long value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.minConnectionInterval = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public int getTcpConnectionPort() {
        return ServerManager.getConfig().tcpConnectionPort;
    }

    @Override
    public int getTcpConnectionPort(String serverName) {
        return ServerManager.getConfig((String)serverName).tcpConnectionPort;
    }

    private void setConfig(String serverName, RPCConfig newConfig) {
        ServerManager.setConfig((String)serverName, (RPCConfig)newConfig);
        RPCEngine.synConfig2ThreadPool((RPCConfig)newConfig);
    }

    private void setConfig(RPCConfig newConfig) {
        ServerManager.setConfig((RPCConfig)newConfig);
        RPCEngine.synConfig2ThreadPool((RPCConfig)newConfig);
    }

    @Override
    public boolean getSocketKeepAlive(String serverName) {
        return ServerManager.getConfig((String)serverName).socketKeepAlive;
    }

    @Override
    public void setSocketKeepAlive(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.socketKeepAlive = value;
        this.setConfig(serverName, conf);
    }

    @Override
    public boolean getTestSocketBeforeUse(String serverName) {
        return ServerManager.getConfig((String)serverName).testSocketBeforeUse;
    }

    @Override
    public void setTestSocketBeforeUse(String serverName, boolean value) {
        RPCConfig conf = ServerManager.getConfig((String)serverName).copy();
        conf.testSocketBeforeUse = value;
        this.setConfig(serverName, conf);
    }
}

