/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.agent;

import com.kingdee.bos.management.NotifySupportBuddyMBean;
import com.kingdee.bos.service.message.agent.BOSMessageService;
import com.kingdee.bos.service.message.agent.ListenerManager;
import com.kingdee.bos.service.message.agent.MessageServiceManageMBean;
import com.kingdee.bos.service.message.agent.MessageServiceThreadPool;

public class MessageServiceManage
extends NotifySupportBuddyMBean
implements MessageServiceManageMBean {
    public MessageServiceManage(BOSMessageService source) {
        super(source);
    }

    private final BOSMessageService msgSvc() {
        return (BOSMessageService)this.getSource();
    }

    @Override
    public String getInstanceName() {
        return null;
    }

    @Override
    public int getMessageRedeliverMaxTimes() {
        return BOSMessageService.messageRedeliverMaxTimes;
    }

    @Override
    public String getReceiverDestination() {
        if (this.msgSvc().receiverAgent != null && this.msgSvc().receiverAgent.dest != null) {
            return this.msgSvc().receiverAgent.dest.toString();
        }
        return null;
    }

    @Override
    public String[] getReceiverListeners() {
        if (this.msgSvc().receiverAgent != null && this.msgSvc().receiverAgent.listeners != null) {
            ListenerManager listenerMgr = this.msgSvc().receiverAgent.listeners;
            String[] listeners = new String[listenerMgr.size()];
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i] = listenerMgr.get(i).toString();
            }
        }
        return null;
    }

    @Override
    public String getSenderDestination() {
        if (this.msgSvc().senderAgent != null && this.msgSvc().senderAgent.dest != null) {
            return this.msgSvc().senderAgent.dest.toString();
        }
        return null;
    }

    @Override
    public String getServiceType() {
        return BOSMessageService.getServiceType();
    }

    @Override
    public int getThreadPoolActiveCount() {
        MessageServiceThreadPool tp = BOSMessageService.getMessageTheadPool();
        if (tp != null) {
            return tp.getActiveCount();
        }
        return 0;
    }

    @Override
    public long getThreadPoolIdleTimeout() {
        MessageServiceThreadPool tp = BOSMessageService.getMessageTheadPool();
        if (tp != null) {
            return tp.getIdleTimeout();
        }
        return 0L;
    }

    @Override
    public int getThreadPoolMaxSize() {
        MessageServiceThreadPool tp = BOSMessageService.getMessageTheadPool();
        if (tp != null) {
            return tp.getMaxSize();
        }
        return 0;
    }

    @Override
    public int getThreadPoolMinSize() {
        MessageServiceThreadPool tp = BOSMessageService.getMessageTheadPool();
        if (tp != null) {
            return tp.getMinSize();
        }
        return 0;
    }

    @Override
    public boolean isLoadEjbOnEASStart() {
        return this.msgSvc().isLoadEjbOnEASStart;
    }

    @Override
    public void setMessageRedeliverMaxTimes(int messageRedeliverMaxTimes) {
        BOSMessageService.messageRedeliverMaxTimes = messageRedeliverMaxTimes;
    }

    @Override
    public void setServiceType(String serviceType) {
        BOSMessageService.setServiceType((String)serviceType);
    }

    @Override
    public void setThreadPoolIdleTimeout(long idleTimeout) {
        MessageServiceThreadPool tp = BOSMessageService.getMessageTheadPool();
        if (tp != null) {
            tp.setParameters(tp.getMaxSize(), idleTimeout);
        }
    }

    @Override
    public void setThreadPoolMaxSize(int maxSize) {
        MessageServiceThreadPool tp = BOSMessageService.getMessageTheadPool();
        if (tp != null) {
            tp.setParameters(maxSize, tp.getIdleTimeout());
        }
    }

    @Override
    public void start() {
        this.msgSvc().start();
    }

    @Override
    public void stop() {
        this.msgSvc().stop();
    }
}

