/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.scheduler;

import com.kingdee.bos.management.NotifySupportBuddyMBean;
import com.kingdee.bos.service.job.core.JobService;
import com.kingdee.bos.service.job.core.JobServiceStatus;
import com.kingdee.bos.service.scheduler.BOSSchedulerService;
import com.kingdee.bos.service.scheduler.SchedulerServiceManageMBean;

public class SchedulerServiceManage
extends NotifySupportBuddyMBean
implements SchedulerServiceManageMBean {
    public SchedulerServiceManage(BOSSchedulerService source) {
        super(source);
    }

    @Override
    public String getInstanceName() {
        return null;
    }

    @Override
    public boolean isRunning() {
        return ((BOSSchedulerService)this.getSource()).running;
    }

    @Override
    public void start() {
        ((BOSSchedulerService)this.getSource()).startSchedulerService();
    }

    @Override
    public void stop() {
        ((BOSSchedulerService)this.getSource()).stopSchedulerService();
    }

    @Override
    public int getJobQueueSize() {
        JobServiceStatus status = JobService.getJobServiceStatus();
        return status.readyJobCount + status.runningJobCount + status.waitingJobCount - (status.dataCenterCount * 3 + 1);
    }

    @Override
    public double getTimeUsage() {
        JobServiceStatus status = JobService.getJobServiceStatus();
        return (double)Math.round((double)status.usedTime * 10000.0 / (double)status.availableTime) / 10000.0;
    }

    @Override
    public double getCoreTimeUsage() {
        JobServiceStatus status = JobService.getJobServiceStatus();
        return (double)Math.round((double)status.coreTimeUsed * 10000.0 / (double)status.availableTime) / 10000.0;
    }

    @Override
    public long getProcessedJobCount() {
        JobServiceStatus status = JobService.getJobServiceStatus();
        return status.processedJobCount;
    }

    @Override
    public long getCoreJobCount() {
        JobServiceStatus status = JobService.getJobServiceStatus();
        return status.coreJobCount;
    }

    @Override
    public long getCoreTimeUsed() {
        JobServiceStatus status = JobService.getJobServiceStatus();
        return status.coreTimeUsed;
    }

    @Override
    public long getTimeUsed() {
        JobServiceStatus status = JobService.getJobServiceStatus();
        return status.usedTime;
    }

    @Override
    public long getAvailableTime() {
        JobServiceStatus status = JobService.getJobServiceStatus();
        return status.availableTime;
    }

    @Override
    public int getContextCacheSize() {
        JobServiceStatus status = JobService.getJobServiceStatus();
        return status.contextCacheSize;
    }

    @Override
    public int getJobDefCacheSize() {
        JobServiceStatus status = JobService.getJobServiceStatus();
        return status.jobDefCacheSize;
    }

    @Override
    public int getTriggerCacheCount() {
        JobServiceStatus status = JobService.getJobServiceStatus();
        return status.triggerCacheCount;
    }

    @Override
    public int getCompletedJobCount() {
        return JobService.getCompletedJobCount();
    }

    @Override
    public int getFailedJobCount() {
        return JobService.getFailedJobCount();
    }

    @Override
    public int getRunningJobCount() {
        return JobService.getRunningJobcount();
    }

    @Override
    public int getReadyJobCount() {
        return JobService.getReadyJobCount();
    }
}

