/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.management.NotifySupportBuddyMBean;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfEngineManageMBean;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.message.WfMessageCounter;
import com.kingdee.bos.workflow.enactment.util.ObjectValueTabularDataBuilder;
import com.kingdee.bos.workflow.metas.ActInstInfo;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.ProcInstDataInfo;
import com.kingdee.bos.workflow.metas.ProcInstInfo;
import com.kingdee.bos.workflow.store.WfAssignmentCounter;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.bos.workflow.util.TransEventPriorityPolicyConfig;
import java.util.ArrayList;
import java.util.List;
import javax.management.JMRuntimeException;
import javax.management.openmbean.TabularData;
import org.apache.log4j.Logger;

public class WfEngineManage
extends NotifySupportBuddyMBean
implements WfEngineManageMBean {
    private static final Logger logger = Logger.getLogger(WfEngineManage.class);

    public WfEngineManage(WfEngine engine) {
        super(engine);
    }

    private WfEngine getWfEngine() {
        return (WfEngine)this.getSource();
    }

    @Override
    public String getInstanceName() {
        return this.getWfEngine().getEngineKey();
    }

    @Override
    public String getServerKey() {
        return this.getWfEngine().getServerKey();
    }

    @Override
    public String getEngineKey() {
        return this.getWfEngine().getEngineKey();
    }

    @Override
    public String getSolutionName() {
        return this.getWfEngine().getEngineSolution();
    }

    @Override
    public String getAisName() {
        return this.getWfEngine().getEngineAis();
    }

    @Override
    public String getLocale() {
        return this.getWfEngine().getLocale().toString();
    }

    @Override
    public String getMessageDestination() {
        return this.getWfEngine().getMessageManager().getWfDestination().toString();
    }

    @Override
    public void restart() {
        try {
            this.getWfEngine().restart();
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
            throw new JMRuntimeException(t.getMessage());
        }
    }

    @Override
    public void start() {
        try {
            this.getWfEngine().start();
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
            throw new JMRuntimeException(t.getMessage());
        }
    }

    @Override
    public void stop() {
        try {
            this.getWfEngine().stop();
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
            throw new JMRuntimeException(t.getMessage());
        }
    }

    @Override
    public void destroy() {
        try {
            this.getWfEngine().destroy();
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
            throw new JMRuntimeException(t.getMessage());
        }
    }

    @Override
    public int getState() {
        return this.getWfEngine().getState();
    }

    @Override
    public boolean isRunning() {
        return 1 == this.getWfEngine().getState();
    }

    public TabularData getProcInstInfosByBizObjID(String bizObjID) {
        try {
            WfEngine engine = this.getWfEngine();
            AssignCollection assignCollection = engine.getStoreManager().getWorkItemStorer().getAssignInfoCollection("WHERE bizObjID ='" + bizObjID + "' ");
            ArrayList<ProcInstInfo> list = new ArrayList<ProcInstInfo>();
            int size = assignCollection.size();
            for (int i = 0; i < size; ++i) {
                WfProcess wfProcess = engine.getProcessInst(assignCollection.get(i).getProcInstID().toString());
                list.add(wfProcess.getData().getMeta());
            }
            return new ObjectValueTabularDataBuilder("ProcInstInfosTabularData", "ProcInstInfosTabularData", (IObjectValue[])list.toArray(new ProcInstInfo[list.size()])).toTabularData();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new JMRuntimeException(e.getMessage());
        }
    }

    public TabularData getProcInstDataInfosByBizObjID(String bizObjID) {
        try {
            WfEngine engine = this.getWfEngine();
            AssignCollection assignCollection = engine.getStoreManager().getWorkItemStorer().getAssignInfoCollection("WHERE bizObjID ='" + bizObjID + "' ");
            ArrayList<ProcInstDataInfo> list = new ArrayList<ProcInstDataInfo>();
            int size = assignCollection.size();
            for (int i = 0; i < size; ++i) {
                list.add(engine.getProcessInst(assignCollection.get(i).getProcInstID().toString()).getProcessContext().getProcInstDataInfo());
            }
            return new ObjectValueTabularDataBuilder("ProcessContextData", "ProcessContextData", (IObjectValue[])list.toArray(new ProcInstDataInfo[list.size()])).toTabularData();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new JMRuntimeException(e.getMessage());
        }
    }

    public TabularData getActInstsByBizObjID(String bizObjID) {
        try {
            WfEngine engine = this.getWfEngine();
            AssignCollection assignCollection = engine.getStoreManager().getWorkItemStorer().getAssignInfoCollection("WHERE bizObjID ='" + bizObjID + "' ");
            ArrayList<ActInstInfo> list = new ArrayList<ActInstInfo>();
            int size = assignCollection.size();
            for (int i = 0; i < size; ++i) {
                WfProcess wfProcess = engine.getProcessInst(assignCollection.get(i).getProcInstID().toString());
                List activites = wfProcess.activities();
                for (WfActivity wfActivity : activites) {
                    list.add(wfActivity.getMeta().getActInstInfo());
                }
            }
            return new ObjectValueTabularDataBuilder("ActInstInfoData", "ActInstInfoData", (IObjectValue[])list.toArray(new ActInstInfo[list.size()])).toTabularData();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new JMRuntimeException(e.getMessage());
        }
    }

    public TabularData getAssignInfosByBizObjID(String bizObjID) {
        try {
            WfEngine engine = this.getWfEngine();
            AssignCollection assignCollection = engine.getStoreManager().getWorkItemStorer().getAssignInfoCollection("WHERE bizObjID ='" + bizObjID + "' ");
            ArrayList<AssignInfo> list = new ArrayList<AssignInfo>();
            int size = assignCollection.size();
            for (int i = 0; i < size; ++i) {
                WfProcess wfProcess = engine.getProcessInst(assignCollection.get(i).getProcInstID().toString());
                List activites = wfProcess.activities();
                for (WfActivity wfActivity : activites) {
                    List assignments = wfActivity.assignments();
                    for (WfAssignment wfAssignment : assignments) {
                        list.add(wfAssignment.getMeta().getAssignInfo());
                    }
                }
            }
            return new ObjectValueTabularDataBuilder("AssignInfoData", "AssignInfoData", (IObjectValue[])list.toArray(new AssignInfo[list.size()])).toTabularData();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new JMRuntimeException(e.getMessage());
        }
    }

    @Override
    public void enableEventPriorityPolicy() {
        this.getTransEventPriorityPolicyConfig().enableEventPriorityPolicy = true;
    }

    @Override
    public void disableEventPriorityPolicy() {
        this.getTransEventPriorityPolicyConfig().enableEventPriorityPolicy = false;
    }

    private TransEventPriorityPolicyConfig getTransEventPriorityPolicyConfig() {
        return EngineConfig.getInstance().getTransEventPriorityPolicyConfig();
    }

    @Override
    public boolean isEnableEventPriorityPolicy() {
        return this.getTransEventPriorityPolicyConfig().enableEventPriorityPolicy;
    }

    @Override
    public float getLowestCapability() {
        return this.getTransEventPriorityPolicyConfig().lowestCapability;
    }

    @Override
    public void setLowestCapability(float lowestCapability) {
        this.getTransEventPriorityPolicyConfig().lowestCapability = lowestCapability;
    }

    @Override
    public float getLowCapability() {
        return this.getTransEventPriorityPolicyConfig().lowCapability;
    }

    @Override
    public void setLowCapability(float lowCapability) {
        this.getTransEventPriorityPolicyConfig().lowCapability = lowCapability;
    }

    @Override
    public float getLowerCapability() {
        return this.getTransEventPriorityPolicyConfig().lowerCapability;
    }

    @Override
    public void setLowerCapability(float lowerCapability) {
        this.getTransEventPriorityPolicyConfig().lowerCapability = lowerCapability;
    }

    @Override
    public float getMediumCapability() {
        return this.getTransEventPriorityPolicyConfig().mediumCapability;
    }

    @Override
    public void setMediumCapability(float mediumCapability) {
        this.getTransEventPriorityPolicyConfig().mediumCapability = mediumCapability;
    }

    @Override
    public float getHigherCapability() {
        return this.getTransEventPriorityPolicyConfig().higherCapability;
    }

    @Override
    public void setHigherCapability(float higherCapability) {
        this.getTransEventPriorityPolicyConfig().higherCapability = higherCapability;
    }

    @Override
    public float getHighCapability() {
        return this.getTransEventPriorityPolicyConfig().highCapability;
    }

    @Override
    public void setHighCapability(float highCapability) {
        this.getTransEventPriorityPolicyConfig().highCapability = highCapability;
    }

    @Override
    public float getHighestCapability() {
        return this.getTransEventPriorityPolicyConfig().highestCapability;
    }

    @Override
    public void setHighestCapability(float highestCapability) {
        this.getTransEventPriorityPolicyConfig().highestCapability = highestCapability;
    }

    @Override
    public int getWorkerThreadCount() {
        return this.getWfEngine().getWorkerThreadCount();
    }

    @Override
    public long getUsedTime() {
        return this.getWfEngine().getUsedTime();
    }

    @Override
    public int getCompleteProcessInstCount() {
        return this.getWfEngine().getCompleteProcessInstCount();
    }

    @Override
    public int getNewProcessInstCount() {
        return this.getWfEngine().getNewProcessInstCount();
    }

    @Override
    public int getMessageSentCount() {
        return WfMessageCounter.getCount((Context)this.getWfEngine().context());
    }

    @Override
    public int getAssignmentCreatedCount() {
        return WfAssignmentCounter.getCount((Context)this.getWfEngine().context());
    }

    @Override
    public void clearCache() {
        try {
            this.getWfEngine().clearCache();
        }
        catch (Throwable t) {
            logger.error((Object)"error when clearCache", t);
        }
    }
}

