/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cache;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.jcache.CacheRef;
import com.kingdee.bos.jcache.ObjectRef;
import com.kingdee.bos.jcache.Region;
import com.kingdee.bos.management.NotifySupportBuddyMBean;
import com.kingdee.bos.management.util.BeanCompositeDataBuilder;
import com.kingdee.bos.management.util.CompositeDataBuilder;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.enactment.cache.WfCacheManageMBean;
import com.kingdee.bos.workflow.enactment.cache.WfCacheManager;
import com.kingdee.bos.workflow.enactment.util.BeanTabularDataBuilder;
import com.kingdee.bos.workflow.enactment.util.ObjectValueTabularDataBuilder;
import com.kingdee.bos.workflow.metas.ActInstInfo;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.ProcDefInfo;
import com.kingdee.bos.workflow.metas.ProcInstInfo;
import java.util.ArrayList;
import javax.management.JMRuntimeException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.log4j.Logger;

public class WfCacheManage
extends NotifySupportBuddyMBean
implements WfCacheManageMBean {
    private static final Logger logger = Logger.getLogger(WfCacheManage.class);
    private final WfCacheManager wfCacheManager = this.getCacheManager();

    public WfCacheManage(WfCacheManager wfCacheManager) {
        super(wfCacheManager);
    }

    @Override
    public String getInstanceName() {
        return this.wfCacheManager.getName();
    }

    private WfCacheManager getCacheManager() {
        return (WfCacheManager)this.getSource();
    }

    @Override
    public CompositeData getRootRegionProperties() {
        Region region = this.wfCacheManager.wfRootRegion;
        return this.transformPropertiesToCompositeData(region);
    }

    @Override
    public CompositeData getProcInstRegionProperties() {
        Region region = this.wfCacheManager.procInstCache;
        return this.transformPropertiesToCompositeData(region);
    }

    @Override
    public TabularData getCacheProcInstInfos() {
        ArrayList<ProcInstInfo> list = new ArrayList<ProcInstInfo>();
        Region region = this.wfCacheManager.procInstCache;
        for (CacheRef cacheRef : region.getRefs()) {
            ObjectRef objectRef;
            WfProcess wfProcess;
            if (!(cacheRef instanceof ObjectRef) || (wfProcess = (WfProcess)(objectRef = (ObjectRef)cacheRef).getCurrentValue()) == null) continue;
            list.add(wfProcess.getData().getMeta());
        }
        return this.transformCacheObjectToTabularData("procInstTabularData", "procInst TabularData", (IObjectValue[])list.toArray(new ProcInstInfo[list.size()]));
    }

    @Override
    public CompositeData getActInstRegionProperties() {
        Region region = this.wfCacheManager.actInstCache;
        return this.transformPropertiesToCompositeData(region);
    }

    @Override
    public TabularData getCacheActInstInfos() {
        ArrayList<ActInstInfo> list = new ArrayList<ActInstInfo>();
        Region region = this.wfCacheManager.actInstCache;
        for (CacheRef cacheRef : region.getRefs()) {
            ObjectRef objectRef;
            WfActivity wfActivity;
            if (!(cacheRef instanceof ObjectRef) || (wfActivity = (WfActivity)(objectRef = (ObjectRef)cacheRef).getCurrentValue()) == null) continue;
            list.add(wfActivity.getMeta().getActInstInfo());
        }
        return this.transformCacheObjectToTabularData("actInstTabularData", "actInst TabularData", (IObjectValue[])list.toArray(new ActInstInfo[list.size()]));
    }

    @Override
    public CompositeData getProcDefRegionProperties() {
        Region region = this.wfCacheManager.procDefCache;
        return this.transformPropertiesToCompositeData(region);
    }

    @Override
    public TabularData getCacheProcDefs() {
        ArrayList<ProcessDef> list = new ArrayList<ProcessDef>();
        Region region = this.wfCacheManager.procDefCache;
        for (CacheRef cacheRef : region.getRefs()) {
            ObjectRef objectRef;
            ProcessDef processDef;
            if (!(cacheRef instanceof ObjectRef) || (processDef = (ProcessDef)(objectRef = (ObjectRef)cacheRef).getCurrentValue()) == null) continue;
            list.add(processDef);
        }
        return this.transformCacheObjectToTabularData("processDefTabularData", "process Def TabularData", list.toArray(new ProcessDef[list.size()]), new String[]{"hashValue"});
    }

    @Override
    public CompositeData getProcMgrRegionProperties() {
        Region region = this.wfCacheManager.procMgrCache;
        return this.transformPropertiesToCompositeData(region);
    }

    @Override
    public TabularData getCacheProcDefInfos() {
        ArrayList<ProcDefInfo> list = new ArrayList<ProcDefInfo>();
        Region region = this.wfCacheManager.procMgrCache;
        for (CacheRef cacheRef : region.getRefs()) {
            ObjectRef objectRef;
            WfProcessMgr wfProcessMgr;
            if (!(cacheRef instanceof ObjectRef) || (wfProcessMgr = (WfProcessMgr)(objectRef = (ObjectRef)cacheRef).getCurrentValue()) == null) continue;
            list.add(wfProcessMgr.getData().getMeta());
        }
        ArrayList<ProcDefInfo> procDefInfos = new ArrayList<ProcDefInfo>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ProcDefInfo procDefInfo = (ProcDefInfo)list.get(i);
            procDefInfos.add(procDefInfo);
        }
        return this.transformCacheObjectToTabularData("procDefInfoTabularData", "procDefInfo TabularData", (IObjectValue[])list.toArray(new ProcDefInfo[list.size()]), new String[]{"procdefID", "innerVersion"});
    }

    @Override
    public CompositeData getAssignmentRegionProperties() {
        Region region = this.wfCacheManager.assignmentCache;
        return this.transformPropertiesToCompositeData(region);
    }

    @Override
    public TabularData getCacheAssignInfos() {
        ArrayList<AssignInfo> list = new ArrayList<AssignInfo>();
        Region region = this.wfCacheManager.assignmentCache;
        for (CacheRef cacheRef : region.getRefs()) {
            ObjectRef objectRef;
            WfAssignment wfAssignment;
            if (!(cacheRef instanceof ObjectRef) || (wfAssignment = (WfAssignment)(objectRef = (ObjectRef)cacheRef).getCurrentValue()) == null) continue;
            list.add(wfAssignment.getMeta().getAssignInfo());
        }
        return this.transformCacheObjectToTabularData("assignInstTabularData", "assignInst TabularData", (IObjectValue[])list.toArray(new AssignInfo[list.size()]));
    }

    @Override
    public CompositeData getGeneralObjectRegionProperties() {
        Region region = this.wfCacheManager.generalObjectCache;
        return this.transformPropertiesToCompositeData(region);
    }

    @Override
    public CompositeData getParticipantRegionProperties() {
        Region region = this.wfCacheManager.generalObjectCache;
        return this.transformPropertiesToCompositeData(region);
    }

    @Override
    public CompositeData getUserServiceContextRegionProperties() {
        Region region = this.wfCacheManager.userServiceContextCache;
        return this.transformPropertiesToCompositeData(region);
    }

    @Override
    public void clearAllCaches() {
        try {
            this.getCacheManager().cleanUp();
        }
        catch (WfException wfe) {
            logger.error((Object)wfe.getMessage(), (Throwable)wfe);
            throw new JMRuntimeException(wfe.getMessage());
        }
    }

    private CompositeData transformPropertiesToCompositeData(Region region) {
        CompositeDataBuilder builder = new CompositeDataBuilder("CacheRegion", "Cache Region");
        builder.addValue(region.attributes().getAttributes());
        return builder.toCompositeData();
    }

    private TabularData transformCacheObjectToTabularData(String typeName, String typeDescription, IObjectValue[] objectValues, String[] tabularIndexNames) {
        if (objectValues != null && objectValues.length > 0) {
            return new ObjectValueTabularDataBuilder(typeName, typeDescription, objectValues, tabularIndexNames).toTabularData();
        }
        return null;
    }

    private TabularData transformCacheObjectToTabularData(String typeName, String typeDescription, IObjectValue[] objectValues) {
        if (objectValues != null && objectValues.length > 0) {
            return new ObjectValueTabularDataBuilder(typeName, typeDescription, objectValues).toTabularData();
        }
        return null;
    }

    private TabularData transformCacheObjectToTabularData(String typeName, String typeDescription, Object[] beans, String[] tabularIndexNames) {
        if (beans != null && beans.length > 0) {
            return new BeanTabularDataBuilder(typeName, typeDescription, beans, tabularIndexNames).toTabularData();
        }
        return null;
    }

    @Override
    public CompositeData getCacheProcInstInfo(String ID) {
        return new BeanCompositeDataBuilder("ProcInstInfoCompositeData", "ProcInstInfo CompositeData", this.getCacheManager().getProcessInst(ID).getData().getMeta()).toCompositeData();
    }

    @Override
    public CompositeData getCacheActInstInfo(String ID) {
        return new BeanCompositeDataBuilder("ActInstInfoCompositeData", "ActInstInfo CompositeData", this.getCacheManager().getActivityInst(ID).getMeta().getActInstInfo()).toCompositeData();
    }

    @Override
    public CompositeData getCacheAssignInfo(String ID) {
        return new BeanCompositeDataBuilder("AssignInfoCompositeData", "AssignInfo CompositeData", this.getCacheManager().getAssignment(ID).getMeta().getAssignInfo()).toCompositeData();
    }

    @Override
    public CompositeData getCacheProcessDef(String procDefHash) {
        return new BeanCompositeDataBuilder("ProceDefCompositeData", "ProceDef CompositeData", this.getCacheManager().getProcessDef(procDefHash)).toCompositeData();
    }

    @Override
    public CompositeData getCacheProcDefInfo(String ID) {
        return new BeanCompositeDataBuilder("ProceDefCompositeData", "ProceDef CompositeData", this.getCacheManager().getProcessMgr(ID).getData().getMeta()).toCompositeData();
    }

    @Override
    public int getSize() {
        return this.getCacheManager().size();
    }
}

