/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.cbos.process.vm.utils.app.Encoding;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class ContextBridge {
    private static byte[] password = new byte[8];

    public static void init(String password) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(password.getBytes());
            System.arraycopy(md5.digest(), 0, ContextBridge.password, 0, 8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String generateSessionID(Context ctx, String clientType) {
        IObjectPK id = ctx.getCaller();
        String dc = ctx.getAIS();
        Locale l = ctx.getLocale();
        try {
            SecretKeySpec sks = new SecretKeySpec(password, "DES");
            Cipher ci = Cipher.getInstance("DES");
            ci.init(1, sks);
            String key = id + ";" + dc + ";" + l + ";" + clientType;
            byte[] data = ci.doFinal(key.getBytes());
            return new String(Encoding.HEX.encode(data));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SessionInfo restoreContext(byte[] sessionId) {
        try {
            SecretKeySpec sks = new SecretKeySpec(password, "DES");
            Cipher ci = Cipher.getInstance("DES");
            ci.init(2, sks);
            byte[] data = ci.doFinal(sessionId);
            String[] tmp = new String(data).split(";");
            SessionInfo info = new SessionInfo();
            info.userId = tmp[0];
            info.dataCenter = tmp[1];
            info.locale = tmp[2].length() == 2 ? tmp[2] : "l2";
            info.clientType = tmp[3];
            String sql = "select fnumber,fname_" + info.locale + " as fname from T_PM_USER where fid=?";
            int[] types = new int[]{12};
            Object[] params = new Object[]{info.userId};
            Map item = (Map)SQL.executeQuery((String)info.dataCenter, (String)sql, (int[])types, (Object[])params).get(0);
            info.userName = (String)item.get("fname");
            info.userNumber = (String)item.get("fnumber");
            return info;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        SecureRandom rnd = new SecureRandom();
        for (int i = 0; i < password.length; ++i) {
            ContextBridge.password[i] = (byte)rnd.nextInt(128);
        }
    }

    public static class SessionInfo {
        public String userId;
        public String userName;
        public String userNumber;
        public String dataCenter;
        public String clientType;
        public String locale;
    }
}

