/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz;

import com.kingdee.bos.metadata.event.EventInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BizEventMap
implements Serializable {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.biz.BizEventMap");
    private static final long serialVersionUID = 1670951542059876118L;
    private final HashMap<EventKey, List<EventStructEntry>> eventMap;
    private static final EventStructEntry[] emptyEntries = new EventStructEntry[0];

    public BizEventMap(int initSize) {
        int size = 1;
        if (initSize > 0) {
            size = initSize;
        }
        this.eventMap = new HashMap(size);
    }

    public synchronized void clear() {
        this.eventMap.clear();
    }

    public synchronized void put(String destmethod, EventInfo destevent, String destoperation, String destfunction) {
        EventStructEntry entry = new EventStructEntry(destmethod, destevent, destoperation, destfunction);
        this.addEventToMap(entry);
    }

    private void addEventToMap(EventStructEntry entry) {
        EventKey[] keys;
        for (EventKey key : keys = entry.key.exhaustKeys()) {
            this.addEventToMap(key, entry);
        }
    }

    private void addEventToMap(EventKey key, EventStructEntry entry) {
        List<EventStructEntry> list = this.eventMap.get(key);
        if (list == null) {
            list = new ArrayList<EventStructEntry>(2);
            this.eventMap.put(key, list);
        }
        list.add(entry);
    }

    public EventStructEntry[] get(String methodId, String eventName, String operationName, String functionName) {
        List<EventStructEntry> entries = this.eventMap.get(new EventKey(methodId, eventName, operationName, functionName));
        if (entries == null) {
            return emptyEntries;
        }
        return entries.toArray(new EventStructEntry[0]);
    }

    public EventStructEntry[] getByEvent(String eventName) {
        return this.get(null, eventName, null, null);
    }

    public EventStructEntry[] getByMethod(String methodId) {
        return this.get(methodId, null, null, null);
    }

    public EventStructEntry[] getByOperation(String operationName) {
        return this.get(null, null, operationName, null);
    }

    public EventStructEntry[] getByFunction(String functionName) {
        return this.get(null, null, null, functionName);
    }

    public boolean contains(String methodId, String eventName, String operationName, String functionName) {
        return this.get(methodId, eventName, operationName, functionName).length > 0;
    }

    public boolean containsByMethod(String methodId) {
        return this.contains(methodId, null, null, null);
    }

    public boolean containsByEvent(String eventName) {
        return this.contains(null, eventName, null, null);
    }

    public boolean containsByOperation(String operationName) {
        return this.contains(null, null, operationName, null);
    }

    public boolean containsByFunction(String functionName) {
        return this.contains(null, null, null, functionName);
    }

    public synchronized EventInfo[] getEventSet() {
        List<EventStructEntry> entries = this.eventMap.get(EventKey.NULL);
        if (entries == null) {
            return new EventInfo[0];
        }
        int size = entries.size();
        EventInfo[] events = new EventInfo[size];
        for (int i = 0; i < size; ++i) {
            events[i] = entries.get(i).event;
        }
        return events;
    }

    public synchronized String[] getFunctionSet() {
        List<EventStructEntry> entries = this.eventMap.get(EventKey.NULL);
        if (entries == null) {
            return new String[0];
        }
        int size = entries.size();
        String[] functions = new String[size];
        for (int i = 0; i < size; ++i) {
            functions[i] = entries.get(i).key.function;
        }
        return functions;
    }

    public synchronized String[] getMethodSet() {
        List<EventStructEntry> entries = this.eventMap.get(EventKey.NULL);
        if (entries == null) {
            return new String[0];
        }
        int size = entries.size();
        String[] methods = new String[size];
        for (int i = 0; i < size; ++i) {
            methods[i] = entries.get(i).key.method;
        }
        return methods;
    }

    public synchronized String[] getOperationSet() {
        List<EventStructEntry> entries = this.eventMap.get(EventKey.NULL);
        if (entries == null) {
            return new String[0];
        }
        int size = entries.size();
        String[] operations = new String[size];
        for (int i = 0; i < size; ++i) {
            operations[i] = entries.get(i).key.operation;
        }
        return operations;
    }

    public synchronized int size() {
        return this.eventMap.size();
    }

    public synchronized boolean isEmpty() {
        return this.eventMap.isEmpty();
    }

    public static class EventStructEntry
    implements Serializable {
        private static final long serialVersionUID = -7511334378836647997L;
        private final EventKey key;
        private final EventInfo event;

        public EventStructEntry(String destmethod, EventInfo destevent, String destoperation, String destfunction) {
            this.key = new EventKey(destmethod, destevent == null ? null : destevent.getName(), destoperation, destfunction);
            this.event = destevent;
        }

        public EventInfo getEvent() {
            return this.event;
        }

        public String getFunction() {
            return this.key.function;
        }

        public String getMethod() {
            return this.key.method;
        }

        public String getOperation() {
            return this.key.operation;
        }
    }

    private static class EventKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final EventKey NULL = new EventKey(null, null, null, null);
        private final String method;
        private final String event;
        private final String operation;
        private final String function;
        private volatile int h = 0;

        EventKey(String method, String event, String operation, String function) {
            this.method = method;
            this.event = event;
            this.operation = operation;
            this.function = function;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EventKey)) {
                return false;
            }
            EventKey that = (EventKey)obj;
            return this.equals(this.method, that.method) && this.equals(this.event, that.event) && this.equals(this.operation, that.operation) && this.equals(this.function, that.function);
        }

        private boolean equals(String src, String dst) {
            if (src == null && dst == null) {
                return true;
            }
            if (src != null) {
                return src.equals(dst);
            }
            return false;
        }

        public int hashCode() {
            if (this.h == 0) {
                int hash = 0;
                hash += this.method == null ? 0 : this.method.hashCode();
                hash += this.event == null ? 0 : this.event.hashCode();
                hash += this.operation == null ? 0 : this.operation.hashCode();
                this.h = hash += this.function == null ? 0 : this.function.hashCode();
            }
            return this.h;
        }

        public String toString() {
            return this.method + "/" + this.event + "/" + this.operation + "/" + this.function;
        }

        EventKey toMethodKey() {
            return new EventKey(this.method, null, null, null);
        }

        EventKey toMethodAndEventKey() {
            return new EventKey(this.method, this.event, null, null);
        }

        EventKey[] exhaustKeys() {
            HashSet<EventKey> keys = new HashSet<EventKey>(16);
            keys.add(this);
            keys.add(NULL);
            keys.add(new EventKey(this.method, null, null, null));
            keys.add(new EventKey(null, this.event, null, null));
            keys.add(new EventKey(null, null, this.operation, null));
            keys.add(new EventKey(null, null, null, this.function));
            keys.add(new EventKey(this.method, this.event, null, null));
            keys.add(new EventKey(this.method, null, this.operation, null));
            keys.add(new EventKey(this.method, null, null, this.function));
            keys.add(new EventKey(null, this.event, this.operation, null));
            keys.add(new EventKey(null, this.event, null, this.function));
            keys.add(new EventKey(null, null, this.operation, this.function));
            keys.add(new EventKey(this.method, this.event, this.operation, null));
            keys.add(new EventKey(this.method, this.event, null, this.function));
            keys.add(new EventKey(this.method, null, this.operation, this.function));
            keys.add(new EventKey(null, this.event, this.operation, this.function));
            return keys.toArray(new EventKey[0]);
        }
    }
}

