/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.function.FunctionInvoke;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizUtils {
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.biz.BizUtils");
    public static final String SUBMIT_METHOD_INNER_ID = "dfd2c083-00fa-1000-e000-001fc0a813e6";
    public static final IMetaDataPK SUBMIT_METHOD_INNER_PK = new MetaDataPK("dfd2c083-00fa-1000-e000-001fc0a813e6");
    public static final String WFASSIGNMENT_CONTEXT_NAME = "WfAssignmentInfo";

    public static String getSubmitMethodId(BOSObjectType objectType) {
        MetaDataPK operationPk = new MetaDataPK(SUBMIT_METHOD_INNER_ID);
        return operationPk.getName() + objectType.toString();
    }

    public static Map getNextActivityPerformers(IObjectValue objectValue) {
        String value = objectValue.getExtendedProperty("DesignateNextActivityPerformerWhenSubmit");
        if (StringUtils.isEmpty((String)value)) {
            return new HashMap();
        }
        try {
            byte[] fieldValueByteArray = StringUtils.hexFromString((String)value);
            ByteArrayInputStream bis = new ByteArrayInputStream(fieldValueByteArray);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object obj = ois.readObject();
            return (Map)obj;
        }
        catch (IOException e) {
            return new HashMap();
        }
        catch (ClassNotFoundException e) {
            return new HashMap();
        }
    }

    public static Map nextActivityPerformers(IServiceContext serviceContext) {
        if (serviceContext == null) {
            throw new IllegalArgumentException();
        }
        AbstractObjectValue objectValue = null;
        Object[] parameters = serviceContext.getOperationParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            if (!(parameter instanceof AbstractObjectValue)) continue;
            objectValue = (AbstractObjectValue)parameter;
            break;
        }
        if (objectValue == null) {
            return new HashMap();
        }
        String value = objectValue.getExtendedProperty("DesignateNextActivityPerformerWhenSubmit");
        if (value == null || value.length() == 0) {
            return new HashMap();
        }
        try {
            byte[] fieldValueByteArray = StringUtils.hexFromString((String)value);
            ByteArrayInputStream bis = new ByteArrayInputStream(fieldValueByteArray);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object obj = ois.readObject();
            return (Map)obj;
        }
        catch (IOException e) {
            return new HashMap();
        }
        catch (ClassNotFoundException e) {
            return new HashMap();
        }
    }

    public static boolean matchAction(AssignmentInfo assignment, String action) {
        String destAction = BizUtils.getActionByOperation((IMetaDataPK)new MetaDataPK(assignment.getBizPackage(), assignment.getBizFunction()), action);
        return action.equals(destAction);
    }

    public static String getActionByOperation(IMetaDataPK functionPk, String operation) {
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction(functionPk);
        return BizUtils.getActionByOperation(function, operation);
    }

    public static String getActionByOperation(FunctionObjectInfo function, String operation) {
        String name = "";
        for (int i = 0; i < function.getOperation().size(); ++i) {
            if (function.getOperation().get(i).getUiActionRef() == null || !(name = function.getOperation().get(i).getUiActionRef().getActionRefName()).equalsIgnoreCase(operation)) continue;
            return name;
        }
        return "";
    }

    public static String getEditUIClassByBillId(String billId) {
        BOSUuid id = BOSUuid.read((String)billId);
        BOSObjectType type = id.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo vo = loader.getEntity(type);
        String editUi = vo.getExtendedProperty("editUI");
        return editUi;
    }

    public static boolean checkAssignmentInfo(AssignmentInfo assignment, String action) {
        return assignment != null && assignment.isValid() && assignment.getBizOperation() != null && BizUtils.matchAction(assignment, action);
    }

    public static String[] getMatchActionsByOperation(IMetaDataPK uiPK, String packageName) {
        Map operations = null;
        assert (packageName != null);
        try {
            operations = FunctionInvoke.getOperation(null, (IMetaDataPK)uiPK, null);
        }
        catch (BOSException e) {
            log.error((Object)"BizUtils.getMatchActionsByOperation error!", (Throwable)e);
        }
        if (operations != null && operations.size() > 0) {
            ArrayList<String> actions = new ArrayList<String>(operations.size());
            for (OperationInfo operation : operations.values()) {
                if (!packageName.equals(operation.getName())) continue;
                actions.add(operation.getUiActionRef().getActionRefName());
            }
            return actions.toArray(new String[0]);
        }
        return new String[0];
    }
}

