/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.upgrade.UpgradeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public abstract class AbstractKpdlElement
implements IKpdlElement {
    private static final Locale L2 = new Locale("L2");
    private static final long serialVersionUID = 2599887127521941121L;
    protected ResourceCollection resources = new ResourceCollection();
    protected Locale locale = L2;
    protected AbstractKpdlElement container = null;
    public static final String standardVersion = "V6.1.0";
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.define.AbstractKpdlElement");

    public abstract String getID();

    public abstract String bosType();

    public Resource getResource(String key) {
        Resource resource = null;
        if (this.resources != null && this.resources.containsKey(key)) {
            return this.resources.get(key);
        }
        return resource;
    }

    public String getResourceValue(String key, Locale locale) {
        String value = null;
        Resource resource = this.getResource(key);
        if (resource != null) {
            value = resource.getValue(locale);
        }
        return value;
    }

    public String getResourceValue(String key) {
        return this.getResourceValue(key, this.getLocale());
    }

    public void setResource(String key, Resource resource) {
        if (key == null || resource == null) {
            throw new IllegalArgumentException();
        }
        this.resources.set(key, resource);
    }

    public void setResource(String key, String value, Locale locale) {
        if (key == null || value == null || locale == null) {
            throw new IllegalArgumentException();
        }
        Resource resource = this.getResource(key);
        if (resource != null) {
            resource.setValue(locale, value);
        } else {
            resource = new Resource();
            resource.setKey(key);
            resource.setValue(locale, value);
            this.resources.set(key, resource);
        }
    }

    public Locale getLocale() {
        if (this.getContainer() != null) {
            return this.container.getLocale();
        }
        return this.locale;
    }

    public void setLocale(Locale destLocale) {
        if (destLocale == null) {
            throw new IllegalArgumentException();
        }
        this.locale = destLocale;
    }

    public Map parseResources(Element element) {
        throw new RuntimeException("TODO");
    }

    public Element toResourcesElement() {
        throw new RuntimeException("TODO");
    }

    public AbstractKpdlElement getContainer() {
        return this.container;
    }

    @Override
    public boolean isReadOnly() {
        if (this.getContainer() != null) {
            return this.container.isReadOnly();
        }
        return false;
    }

    public void setContainer(AbstractKpdlElement element) {
        this.container = element;
    }

    @Override
    public IKpdlElement parse(Element destElement) throws WfKpdlParseException {
        try {
            this.beforeParse(destElement);
            IKpdlElement kpdlElement = this.innerParse(destElement);
            this.afterParse(kpdlElement);
            this.resources.trimToSize();
            return kpdlElement;
        }
        catch (Exception ex) {
            if (ex instanceof WfKpdlParseException) {
                throw (WfKpdlParseException)((Object)ex);
            }
            throw new WfKpdlParseException("parse failed", ex);
        }
    }

    protected abstract IKpdlElement innerParse(Element var1) throws WfKpdlParseException;

    protected void beforeParse(Element destElement) throws UpgradeException {
    }

    protected void afterParse(IKpdlElement kpdlElement) throws UpgradeException {
    }

    public AbstractKpdlElement deepClone(AbstractKpdlElement info) {
        AbstractKpdlElement dc = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(info);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream bis = new ObjectInputStream(bais);
            dc = (AbstractKpdlElement)bis.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return dc;
    }
}

