/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterType;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.IApplicationActivity;
import com.kingdee.bos.workflow.define.IExecuteObject;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import org.jdom2.Element;

public class ActualParameterDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -4967494874147952220L;
    private int index = 0;
    private String expr = "";
    private String prop = "";
    private String formalDefId = "";
    private ActualParameterType actualParameterType = ActualParameterType.DEFAULT;

    public ActualParameterDef(IExecuteObject executeObject) {
        this.setContainer(executeObject);
    }

    public ActualParameterDef(IExecuteObject executeObject, Element destActualParameterDefElment) throws WfKpdlParseException {
        this(executeObject);
        this.parse(destActualParameterDefElment);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int destIndex) {
        this.index = destIndex;
    }

    public String getExpr() {
        return this.expr;
    }

    public void setExpr(String destExpr) {
        this.expr = destExpr;
    }

    public ActualParameterType getActualParameterType() {
        return this.actualParameterType;
    }

    public void setActualParameterType(ActualParameterType type) {
        this.actualParameterType = type;
    }

    public int check() {
        return 0;
    }

    @Override
    public Element toElement() {
        Element actualParameterElement = new Element("ActualParameter", DefinitionConstants.NS_INSTANCE_KPDL);
        actualParameterElement.setAttribute("Index", String.valueOf(this.index));
        actualParameterElement.setAttribute("Expr", this.expr == null ? "" : this.expr);
        actualParameterElement.setAttribute("Prop", this.prop == null ? "" : this.prop);
        actualParameterElement.setAttribute("FormalParameterDefId", this.formalDefId != null ? this.formalDefId : "");
        actualParameterElement.setAttribute("ActualParameterType", this.actualParameterType.getName());
        return actualParameterElement;
    }

    public FormalParameterDef getRelatedFormalParameter() {
        FormalParameterDef formalParam = null;
        if (ActivityDef.class.isAssignableFrom(this.container.getClass())) {
            formalParam = this.getRelatedFormalParameter((ActivityDef)this.container);
        }
        return formalParam;
    }

    public FormalParameterDef getRelatedFormalParameter(ActivityDef activity) {
        if (activity == null) {
            return null;
        }
        if (activity instanceof IApplicationActivity) {
            IApplicationActivity applicationActivity = (IApplicationActivity)((Object)activity);
            FormalParameterDef tempFormalParam = this.getRelatedFormalParameter(applicationActivity.getRelatedApplication());
            if (tempFormalParam == null) {
                tempFormalParam = this.getRelatedFormalParameter(applicationActivity.getRedoApplication());
            }
            return tempFormalParam;
        }
        return null;
    }

    public FormalParameterDef getRelatedFormalParameter(ApplicationDef application) {
        if (application == null || application.getFormalParameters() == null || application.getFormalParameters().size() == 0) {
            return null;
        }
        FormalParameterCollection formalParams = application.getFormalParameters();
        for (int i = 0; i < formalParams.size(); ++i) {
            if (formalParams.get(i).getIndex() != this.getIndex()) continue;
            return formalParams.get(i);
        }
        return null;
    }

    public String getDataFieldName(ActivityDef activity) {
        DataFieldDef dataField = this.getDataField(activity);
        if (dataField == null) {
            return null;
        }
        return dataField.getName();
    }

    public String getDataFieldNameWithProp(ActivityDef activity) {
        String name = this.getDataFieldName(activity);
        if (!StringUtils.isEmpty((String)name) && !StringUtils.isEmpty((String)this.prop)) {
            name = name + "." + this.prop;
        }
        return name;
    }

    public DataFieldDef getDataField(ActivityDef activity) {
        if (activity == null || activity.getContainer() == null || ((ProcessDef)activity.getContainer()).getDataFields() == null) {
            return null;
        }
        DataFieldDef dataField = ((ProcessDef)activity.getContainer()).getDataFields().get(this.expr);
        if (dataField == null) {
            return null;
        }
        return dataField;
    }

    public DataFieldDef getDataField() {
        if (ActivityDef.class.isAssignableFrom(this.container.getClass())) {
            return this.getDataField((ActivityDef)this.container);
        }
        return null;
    }

    @Override
    public String getID() {
        throw new RuntimeException("NotSupport");
    }

    public void setContainer(IExecuteObject element) {
        super.setContainer((AbstractKpdlElement)((Object)element));
    }

    @Override
    public String bosType() {
        return null;
    }

    @Override
    protected IKpdlElement innerParse(Element destActualParameterDefElment) throws WfKpdlParseException {
        if (destActualParameterDefElment == null) {
            throw new IllegalArgumentException();
        }
        this.index = Integer.parseInt(destActualParameterDefElment.getAttributeValue("Index"));
        this.expr = XmlUtil.readStringAttr(destActualParameterDefElment, "Expr");
        this.prop = XmlUtil.readStringAttr(destActualParameterDefElment, "Prop");
        this.formalDefId = XmlUtil.readStringAttr(destActualParameterDefElment, "FormalParameterDefId");
        return this;
    }

    public String getFormalDefId() {
        return this.formalDefId;
    }

    public void setFormalDefId(String formalDefId) {
        this.formalDefId = formalDefId;
    }

    public String getProp() {
        return this.prop;
    }

    public void setProp(String prop) {
        this.prop = prop;
    }
}

