/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.DataTypeUtils;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.IImplementationActivity;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.KpdlResourceUtils;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.Uuid;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public class DataFieldDef
extends AbstractKpdlElement
implements Cloneable {
    private static final long serialVersionUID = -4708474961248984967L;
    private static final String BOSTYPE = "WFDAFDEF";
    private String id;
    private String name;
    private final String description = KpdlResourceUtils.DATAFIELD_DESCRIPTION.getName();
    private int length;
    private DataType dataType;
    private String initValue;
    private ExtendedAttributeCollection extendedAttributes;
    private boolean isArray;
    private boolean isSystemDefault;

    public DataFieldDef(ProcessDef process) {
        this.setContainer(process);
        this.id = Uuid.create().toString() + BOSTYPE;
        this.name = "datafield";
        this.isArray = false;
        this.length = 0;
        this.dataType = BasicType.STRING;
        this.isSystemDefault = false;
        this.extendedAttributes = new ExtendedAttributeCollection();
    }

    public DataFieldDef(Element element, ProcessDef process) throws WfKpdlParseException {
        this(process);
        this.parse(element);
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setID(String destID) {
        this.resources.updateResourceId(this.getDescriptionResource(), destID);
        this.id = destID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String destName) {
        this.name = destName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType destDatatype) {
        this.dataType = destDatatype;
    }

    public String getInitValue() {
        return this.initValue;
    }

    public void setInitValue(String destInitValue) {
        this.initValue = destInitValue;
    }

    public String getDescription() {
        return this.getDescription(this.container.getLocale());
    }

    public Resource getDescriptionResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(this.description + this.id);
    }

    public String getDescription(Locale locale) {
        if (this.getDescriptionResource() == null) {
            return null;
        }
        return this.getDescriptionResource().getValue(locale);
    }

    public void setDescription(String destDescription) throws WfException {
        assert (this.container != null);
        this.setDescription(this.container.getLocale(), destDescription);
    }

    public void setDescription(Locale locale, String destDesc) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destDesc == null) {
            throw new IllegalArgumentException();
        }
        if (this.getDescriptionResource() == null) {
            this.setDescription(new Resource(this.description, this.id, locale, destDesc));
        } else {
            this.getDescriptionResource().setValue(locale, destDesc);
        }
    }

    public void setDescription(Resource destDesc) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(this.description + this.id, destDesc);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int destLength) {
        this.length = destLength;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean b) {
        this.isArray = b;
    }

    public boolean isSystemDefault() {
        return this.isSystemDefault;
    }

    public void setSystemDefault(boolean b) {
        this.isSystemDefault = b;
    }

    public ExtendedAttributeCollection getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public int check() {
        return 0;
    }

    @Override
    public Element toElement() {
        Element dataFieldElement = new Element("DataField", DefinitionConstants.NS_INSTANCE_KPDL);
        dataFieldElement.setAttribute("Id", this.id);
        dataFieldElement.setAttribute("Name", this.name);
        dataFieldElement.setAttribute("IsArray", String.valueOf(this.isArray));
        dataFieldElement.setAttribute("IsSystemDefault", String.valueOf(this.isSystemDefault));
        if (this.dataType != null) {
            dataFieldElement.addContent((Content)this.dataType.toElement());
        }
        Element initValueElement = new Element("InitialValue", DefinitionConstants.NS_INSTANCE_KPDL);
        initValueElement.setText(this.initValue);
        dataFieldElement.addContent((Content)initValueElement);
        Element lengthElement = new Element("Length", DefinitionConstants.NS_INSTANCE_KPDL);
        lengthElement.setText(String.valueOf(this.length));
        dataFieldElement.addContent((Content)lengthElement);
        Element descriptionElement = new Element("Description", DefinitionConstants.NS_INSTANCE_KPDL);
        descriptionElement.setText(this.description);
        dataFieldElement.addContent((Content)descriptionElement);
        if (this.extendedAttributes != null && this.extendedAttributes.size() > 0) {
            dataFieldElement.addContent((Content)this.extendedAttributes.toElement());
        }
        if (this.resources != null) {
            dataFieldElement.addContent((Content)this.resources.toElement());
        }
        return dataFieldElement;
    }

    public boolean hasReference(ProcessDef process) {
        int i;
        boolean hasRef = false;
        if (process == null || process.getDataFields() == null || process.getDataFields().get(this.getID()) == null) {
            return hasRef;
        }
        if (process.getActivitys() != null) {
            block0: for (i = 0; i < process.getActivitys().size(); ++i) {
                IImplementationActivity implemtationActivity;
                if (!IImplementationActivity.class.isAssignableFrom(process.getActivitys().get(i).getClass()) || (implemtationActivity = (IImplementationActivity)((Object)process.getActivitys().get(i))).getActualParameters() == null) continue;
                for (int j = 0; j < implemtationActivity.getActualParameters().size(); ++j) {
                    if (!implemtationActivity.getActualParameters().get(j).getExpr().equals(this.getID())) continue;
                    hasRef = true;
                    continue block0;
                }
            }
        }
        if (process.getFormalParameters() != null) {
            for (i = 0; i < process.getFormalParameters().size(); ++i) {
                if (!process.getFormalParameters().get(i).getID().equals(this.getID())) continue;
                hasRef = true;
                break;
            }
        }
        return hasRef;
    }

    @Override
    public void setContainer(AbstractKpdlElement element) {
        super.setContainer(element);
        this.container = (ProcessDef)element;
    }

    public String toString() {
        return DataFieldDef.class.getName() + "/n [ ID:" + this.id + " Name: " + this.name + " InitValue: " + this.initValue + " IsArray: " + this.isArray + " ]";
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    @Override
    protected IKpdlElement innerParse(Element element) throws WfKpdlParseException {
        Element resourcesElement;
        this.id = XmlUtil.readStringAttr(element, "Id");
        this.name = XmlUtil.readStringAttr(element, "Name");
        this.isArray = Boolean.valueOf(element.getAttributeValue("IsArray"));
        this.isSystemDefault = Boolean.valueOf(element.getAttributeValue("IsSystemDefault"));
        Element dataTypeElem = element.getChild("DataType", DefinitionConstants.NS_INSTANCE_KPDL);
        if (dataTypeElem != null) {
            this.dataType = DataTypeUtils.readDataType(dataTypeElem, DefinitionConstants.NS_INSTANCE_KPDL);
        }
        this.initValue = XmlUtil.readString(element, "InitialValue", DefinitionConstants.NS_INSTANCE_KPDL);
        this.length = XmlUtil.readInt(element, "Length", DefinitionConstants.NS_INSTANCE_KPDL);
        Element extendedAttributesElement = element.getChild("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL);
        if (extendedAttributesElement != null) {
            this.extendedAttributes = new ExtendedAttributeCollection(extendedAttributesElement);
        }
        if ((resourcesElement = element.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.resources = new ResourceCollection(this, resourcesElement);
        }
        return this;
    }

    public DataFieldDef clone() throws CloneNotSupportedException {
        DataFieldDef dataField = (DataFieldDef)super.clone();
        dataField.setID(Uuid.create().toString() + BOSTYPE);
        return dataField;
    }
}

