/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ApplicationCollection;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.DeadlineCollection;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.EventType;
import com.kingdee.bos.workflow.define.IApplicationActivity;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class EventActivityDef
extends ActivityDef
implements IApplicationActivity {
    private static final long serialVersionUID = 6202461113016037518L;
    protected ActualParameterCollection actualParameters;
    protected String applicationId;
    protected DeadlineCollection deadlines;
    protected boolean isDefaultRollback;
    protected EventType eventType;
    protected String refActivityId;
    protected String eventName;
    protected String eventId;
    protected String filterRule;
    protected String actDefName;
    protected boolean isAttachToManAct;
    private ParticipantCollection participants;

    public boolean isAttachToManAct() {
        return this.isAttachToManAct;
    }

    public void setAttachToManAct(boolean isAttachToManAct) {
        this.isAttachToManAct = isAttachToManAct;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public String getRefActivityId() {
        return this.refActivityId;
    }

    public void setRefActivityId(String refActivityId) {
        this.refActivityId = refActivityId;
    }

    public String getFilterRule() {
        return this.filterRule;
    }

    public void setFilterRule(String filterRule) {
        this.filterRule = filterRule;
    }

    public EventActivityDef(ProcessDef process) {
        block3: {
            super(process);
            this.actualParameters = new ActualParameterCollection(this);
            this.applicationId = "";
            this.deadlines = new DeadlineCollection(this);
            this.isDefaultRollback = true;
            this.eventType = null;
            this.refActivityId = "";
            this.eventName = "";
            this.eventId = "";
            this.filterRule = "";
            this.actDefName = "";
            this.isAttachToManAct = false;
            this.participants = new ParticipantCollection();
            this.setType(ActivityType.EVENT);
            this.isDefaultRollback = true;
            if (process != null) {
                try {
                    this.setName(this.actDefName);
                }
                catch (WfException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"EvemtActivityDef.construct error", (Throwable)((Object)e));
                }
            }
        }
        this.setActivityFeature();
    }

    public EventActivityDef(ProcessDef container, Element destEventActivityDefElement) throws WfKpdlParseException {
        super(container, destEventActivityDefElement);
        this.actualParameters = new ActualParameterCollection(this);
        this.applicationId = "";
        this.deadlines = new DeadlineCollection(this);
        this.isDefaultRollback = true;
        this.eventType = null;
        this.refActivityId = "";
        this.eventName = "";
        this.eventId = "";
        this.filterRule = "";
        this.actDefName = "";
        this.isAttachToManAct = false;
        this.participants = new ParticipantCollection();
        this.setType(ActivityType.EVENT);
        this.setActivityFeature();
        this.parse(destEventActivityDefElement);
    }

    @Override
    public ActualParameterCollection getActualParameters() {
        return this.actualParameters;
    }

    @Override
    public ApplicationDef getRelatedApplication() {
        if (this.applicationId == null) {
            return null;
        }
        return this.container().getApplicationDef(this.applicationId);
    }

    public void setRelatedApplication(ApplicationDef destRelatedApplication) throws WfException {
        if (destRelatedApplication == null) {
            throw new IllegalArgumentException("destRelatedApplication null");
        }
        if (this.container().getApplications() == null) {
            this.container().setApplications(new ApplicationCollection(this.container()));
        }
        this.container().getApplications().set(destRelatedApplication.getID(), destRelatedApplication);
        this.applicationId = destRelatedApplication.getID();
    }

    public DeadlineCollection getDeadlines() {
        return this.deadlines;
    }

    public void setDeadlines(DeadlineCollection destDeadlines) {
        this.deadlines = destDeadlines;
    }

    @Override
    public Element toElement() {
        Element eventElement = super.toElement();
        if (eventElement != null) {
            eventElement.setName(this.actDefName);
            if (this.applicationId != null && this.applicationId.length() > 0) {
                eventElement.setAttribute("ApplicationId", this.applicationId);
            }
            if (this.eventType != null && !StringUtils.isEmpty((String)this.eventType.getValue())) {
                eventElement.setAttribute("EventType", this.eventType.getValue());
            }
            if (this.actualParameters != null && this.actualParameters.size() > 0) {
                eventElement.addContent((Content)this.actualParameters.toElement());
            } else {
                eventElement.addContent((Content)new Element("ActualParameters", DefinitionConstants.NS_INSTANCE_KPDL));
            }
            if (this.deadlines != null && this.deadlines.size() > 0) {
                eventElement.addContent((Content)this.deadlines.toElement());
            } else {
                eventElement.addContent((Content)new Element("Deadlines", DefinitionConstants.NS_INSTANCE_KPDL));
            }
            Element eventRefElement = new Element("EventDefRef", DefinitionConstants.NS_INSTANCE_KPDL);
            eventRefElement.setAttribute("EventDefRefId", this.eventId);
            eventRefElement.setAttribute("FilterRule", this.filterRule == null ? " " : this.filterRule);
            eventRefElement.setAttribute("EventDefRefName", this.eventName);
            eventElement.addContent((Content)eventRefElement);
            eventElement.setAttribute("IsDefaultRollback", String.valueOf(this.isDefaultRollback));
            eventElement.setAttribute("refActivityId", this.refActivityId);
            if (this.participants != null && this.participants.size() > 0) {
                eventElement.addContent((Content)this.participants.toElement());
            } else {
                eventElement.addContent((Content)new Element("Participants", DefinitionConstants.NS_INSTANCE_KPDL));
            }
        }
        return eventElement;
    }

    @Override
    public IKpdlElement innerParse(Element destEventActivityDefElement) throws WfKpdlParseException {
        Element participantsElement;
        Element deadlineElementList;
        super.innerParse(destEventActivityDefElement);
        Element actualParametersElement = destEventActivityDefElement.getChild("ActualParameters", DefinitionConstants.NS_INSTANCE_KPDL);
        if (actualParametersElement != null) {
            this.actualParameters = new ActualParameterCollection(this, actualParametersElement);
        }
        if ((deadlineElementList = destEventActivityDefElement.getChild("Deadlines", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.deadlines = new DeadlineCollection(this, deadlineElementList);
        }
        this.applicationId = XmlUtil.readStringAttr(destEventActivityDefElement, "ApplicationId");
        this.eventType = EventType.getEnum(destEventActivityDefElement.getAttributeValue("EventType"));
        String isDefaultRollbackStr = destEventActivityDefElement.getAttributeValue("IsDefaultRollback");
        if (!StringUtils.isEmpty((String)isDefaultRollbackStr)) {
            this.isDefaultRollback = Boolean.valueOf(isDefaultRollbackStr);
        }
        this.refActivityId = destEventActivityDefElement.getAttributeValue("refActivityId");
        Element eventRefElement = destEventActivityDefElement.getChild("EventDefRef", DefinitionConstants.NS_INSTANCE_KPDL);
        if (eventRefElement != null) {
            this.eventId = XmlUtil.readStringAttr(eventRefElement, "EventDefRefId");
            this.eventName = XmlUtil.readStringAttr(eventRefElement, "EventDefRefName");
            this.filterRule = XmlUtil.readStringAttr(eventRefElement, "FilterRule");
        }
        if ((participantsElement = destEventActivityDefElement.getChild("Participants", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.participants = new ParticipantCollection(this, participantsElement);
        }
        return this;
    }

    public void setActualParameters(ActualParameterCollection collection) {
        this.actualParameters = collection;
    }

    public boolean isDefaultRollback() {
        return this.isDefaultRollback;
    }

    public void setDefaultRollback(boolean isDefaultRollback) {
        this.isDefaultRollback = isDefaultRollback;
    }

    @Override
    public ApplicationDef getRedoApplication() {
        return null;
    }

    public ParticipantCollection getParticipants() {
        return this.participants;
    }

    public void setParticipants(ParticipantCollection collection) {
        this.participants = collection;
    }

    protected void setActivityFeature() {
        this.actDefName = "SendSignalIntermediateEvent";
        this.eventType = EventType.EVENT_INTERMEDIATE_SENDSIGNAL;
    }
}

