/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.AssignmentMessage;
import com.kingdee.bos.workflow.define.AutoApproveDef;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ScriptDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.Uuid;
import org.jdom2.Content;
import org.jdom2.Element;

public class EventPolicyDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = 7430004421000299190L;
    private static final String BOSTYPE = "WFETPDEF";
    private String id = Uuid.create().toString() + "WFETPDEF";
    private String eventType = "";
    private int eventAction = 1;
    private ParticipantCollection participants = new ParticipantCollection();
    private ScriptDef handleScript = new ScriptDef();
    private AutoApproveDef autoApprove;
    private boolean isUseActivityParticipants = false;
    private AssignmentMessage message;
    private boolean isUseSystemDefaultMessage = true;
    private boolean hasSuspendEmail = false;

    public EventPolicyDef() {
        this.isUseActivityParticipants = false;
        this.isUseSystemDefaultMessage = true;
        this.autoApprove = new AutoApproveDef();
        this.message = null;
    }

    public EventPolicyDef(AbstractKpdlElement container) {
        this.autoApprove = new AutoApproveDef();
        this.isUseActivityParticipants = false;
        this.isUseSystemDefaultMessage = true;
        this.message = null;
        this.container = container;
    }

    public EventPolicyDef(Element destElement) throws WfKpdlParseException {
        this();
        this.parse(destElement);
    }

    public EventPolicyDef(AbstractKpdlElement container, Element destElement) throws WfKpdlParseException {
        this();
        this.container = container;
        this.parse(destElement);
    }

    @Override
    public Element toElement() {
        Element eventPolicyElement = new Element("EventPolicy", DefinitionConstants.NS_INSTANCE_KPDL);
        eventPolicyElement.setAttribute("Id", this.id);
        eventPolicyElement.setAttribute("EventType", this.eventType);
        eventPolicyElement.setAttribute("EventAction", String.valueOf(this.eventAction));
        eventPolicyElement.setAttribute("IsUseActivityParticipants", String.valueOf(this.isUseActivityParticipants));
        eventPolicyElement.setAttribute("IsUseSystemDefaultMessage", String.valueOf(this.isUseSystemDefaultMessage));
        eventPolicyElement.setAttribute("IshasSuspendEmail", String.valueOf(this.hasSuspendEmail));
        if (this.participants != null) {
            Element participantsElement = this.participants.toElement();
            eventPolicyElement.addContent((Content)participantsElement);
        }
        if (this.handleScript != null) {
            Element tempHandleScriptElement = new Element("HandleScript", DefinitionConstants.NS_INSTANCE_KPDL);
            tempHandleScriptElement.addContent((Content)this.handleScript.toElement());
            eventPolicyElement.addContent((Content)tempHandleScriptElement);
        }
        if (this.autoApprove != null) {
            eventPolicyElement.addContent((Content)this.autoApprove.toElement());
        }
        if (this.message != null) {
            eventPolicyElement.addContent((Content)this.message.toElement());
        } else {
            eventPolicyElement.addContent((Content)new Element("AssignmentMessage", DefinitionConstants.NS_INSTANCE_KPDL));
        }
        return eventPolicyElement;
    }

    public AssignmentMessage getMessage() {
        return this.message;
    }

    public void setMessage(AssignmentMessage message) {
        this.message = message;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getId() {
        return this.id;
    }

    public ParticipantCollection getParticipants() {
        return this.participants;
    }

    public void setEventType(String string) {
        this.eventType = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setParticipants(ParticipantCollection collection) {
        this.participants = collection;
    }

    @Override
    public String getID() {
        throw new RuntimeException("NotSupport");
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    @Override
    protected IKpdlElement innerParse(Element destElement) throws WfKpdlParseException {
        Element messageElement;
        Element autoApproveElement;
        Element scriptElement;
        Element handleScriptElement;
        if (destElement == null) {
            throw new IllegalArgumentException();
        }
        this.id = XmlUtil.readStringAttr(destElement, "Id");
        this.eventType = XmlUtil.readStringAttr(destElement, "EventType");
        String eventAction = XmlUtil.readStringAttr(destElement, "EventAction");
        try {
            this.eventAction = Integer.parseInt(eventAction);
        }
        catch (NumberFormatException e) {
            this.eventAction = 1;
        }
        String isUseActivityParticipants = XmlUtil.readStringAttr(destElement, "IsUseActivityParticipants");
        this.isUseActivityParticipants = isUseActivityParticipants != null ? "true".equalsIgnoreCase(isUseActivityParticipants) : false;
        String isUseSystemDefaultMessage = XmlUtil.readStringAttr(destElement, "IsUseSystemDefaultMessage");
        this.isUseSystemDefaultMessage = isUseSystemDefaultMessage != null ? "true".equalsIgnoreCase(isUseSystemDefaultMessage) : true;
        String hasSuspendEmail = XmlUtil.readStringAttr(destElement, "IshasSuspendEmail");
        if (hasSuspendEmail != null) {
            this.hasSuspendEmail = "true".equalsIgnoreCase(hasSuspendEmail);
        } else {
            this.isUseSystemDefaultMessage = false;
        }
        Element destParticipantsElement = destElement.getChild("Participants", DefinitionConstants.NS_INSTANCE_KPDL);
        if (destParticipantsElement != null) {
            this.participants = new ParticipantCollection(destParticipantsElement);
        }
        if ((handleScriptElement = destElement.getChild("HandleScript", DefinitionConstants.NS_INSTANCE_KPDL)) != null && (scriptElement = handleScriptElement.getChild("Script", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.handleScript = new ScriptDef(scriptElement);
        }
        if ((autoApproveElement = destElement.getChild("autoApprove", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.autoApprove = new AutoApproveDef(autoApproveElement);
        }
        if ((messageElement = destElement.getChild("AssignmentMessage", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.message = new AssignmentMessage(this.container, messageElement);
        }
        return this;
    }

    public boolean isUseSystemDefaultMessage() {
        return this.isUseSystemDefaultMessage;
    }

    public void setUseSystemDefaultMessage(boolean isUseSystemDefaultMessage) {
        this.isUseSystemDefaultMessage = isUseSystemDefaultMessage;
    }

    public boolean isUseActivityParticipants() {
        return this.isUseActivityParticipants;
    }

    public void setUseActivityParticipants(boolean isUseActivityParticipants) {
        this.isUseActivityParticipants = isUseActivityParticipants;
    }

    public int getEventAction() {
        return this.eventAction;
    }

    public void setEventAction(int eventAction) {
        this.eventAction = eventAction;
    }

    public ScriptDef getHandleScript() {
        return this.handleScript;
    }

    public void setHandleScript(ScriptDef handleScript) {
        this.handleScript = handleScript;
    }

    public AutoApproveDef getAutoApprove() {
        return this.autoApprove;
    }

    public void setAutoApprove(AutoApproveDef autoApprove) {
        this.autoApprove = autoApprove;
    }

    public void setHasSuspendEmail(boolean hasSuspendEmail) {
        this.hasSuspendEmail = hasSuspendEmail;
    }

    public boolean isHasSuspendEmail() {
        return this.hasSuspendEmail;
    }
}

