/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.DataTypeUtils;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.KpdlResourceUtils;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public class FormalParameterDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = 657547154533569420L;
    private static final String BOSTYPE = "WFFPTDEF";
    private String name;
    private DataType dataType;
    private final String description;
    private String id;
    private String descriptInfoId;
    private int index;
    private FormalParameterMode mode;
    private String boId;
    private String boName;
    private final String boAlies;
    private String propertyName;
    private String propertyIsDynamic;
    private final String propertyAlies;
    private boolean isDefault;
    private String type;
    private String entityType;

    public FormalParameterDef(AbstractKpdlElement containerObject) {
        block4: {
            this.description = KpdlResourceUtils.FORMALPARAMETER_DESCRIPTION.getName();
            this.descriptInfoId = "";
            this.boAlies = KpdlResourceUtils.FORMALPARAMETER_BOALIES.getName();
            this.propertyAlies = KpdlResourceUtils.FORMALPARAMETER_PROPERTYALIES.getName();
            this.type = null;
            this.entityType = null;
            this.name = "";
            this.dataType = BasicType.STRING;
            this.id = Uuid.create().toString() + BOSTYPE;
            this.descriptInfoId = Uuid.create().toString() + BOSTYPE;
            this.index = 0;
            this.mode = FormalParameterMode.IN;
            this.boId = "";
            this.boName = "";
            this.propertyName = "";
            this.propertyIsDynamic = "";
            this.isDefault = false;
            this.container = containerObject;
            if (this.container != null) {
                try {
                    if (this.getDescriptionResource() == null) {
                        this.setDescription(new Resource(this.description, this.descriptInfoId));
                    }
                }
                catch (WfException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"FormalParameterDef.construct setDescription error", (Throwable)((Object)e));
                }
            }
        }
    }

    public FormalParameterDef(Element destFormalParameterElement, AbstractKpdlElement containerObject) throws WfKpdlParseException {
        this(containerObject);
        this.parse(destFormalParameterElement);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getDescription() {
        return this.getDescription(this.container.getLocale());
    }

    public String getDescription(Locale locale) {
        if (this.getDescriptionResource() == null) {
            return null;
        }
        return this.getDescriptionResource().getValue(locale);
    }

    public Resource getDescriptionResource() {
        if (this.container == null) {
            return null;
        }
        if (this.resources.get(this.description + this.descriptInfoId) == null) {
            return this.resources.get(this.description + this.id);
        }
        return this.resources.get(this.description + this.descriptInfoId);
    }

    @Override
    public String getID() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public FormalParameterMode getMode() {
        return this.mode;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setDataType(DataType type) {
        this.dataType = type;
    }

    public void setDescription(String destDescription) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.setDescription(this.container.getLocale(), destDescription);
    }

    public void setDescription(Locale locale, String destDesc) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destDesc == null) {
            throw new IllegalArgumentException();
        }
        if (this.getDescriptionResource() == null) {
            this.setDescription(new Resource(this.description, this.descriptInfoId, locale, destDesc));
        } else {
            this.getDescriptionResource().setValue(locale, destDesc);
        }
    }

    public void setDescription(Resource destDesc) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(this.description + this.descriptInfoId, destDesc);
    }

    public void setID(String string) {
        this.resources.updateResourceId(this.getBoAliesResource(), string);
        this.resources.updateResourceId(this.getDescriptionResource(), string);
        this.resources.updateResourceId(this.getPropertyAliesResource(), string);
        this.id = string;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public void setMode(FormalParameterMode mode) {
        this.mode = mode;
    }

    public String getBoAlies() {
        return this.getBoAlies(this.container.getLocale());
    }

    public Resource getBoAliesResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(this.boAlies + this.id);
    }

    public String getBoAlies(Locale locale) {
        if (this.getBoAliesResource() == null) {
            return null;
        }
        return this.getBoAliesResource().getValue(locale);
    }

    public String getBoId() {
        return this.boId;
    }

    public String getBoName() {
        return this.boName;
    }

    public String getPropertyIsDynamic() {
        return this.propertyIsDynamic;
    }

    public void setPropertyIsDynamic(String propertyIsDynamic) {
        this.propertyIsDynamic = propertyIsDynamic;
    }

    public String getPropertyAlies() {
        return this.getPropertyAlies(this.container.getLocale());
    }

    public String getPropertyAlies(Locale locale) {
        if (this.getPropertyAliesResource() == null) {
            return null;
        }
        return this.getPropertyAliesResource().getValue(locale);
    }

    public Resource getPropertyAliesResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(this.propertyAlies + this.id);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean b) {
        this.isDefault = b;
    }

    public void setBoAlies(String destBoAlies) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.setBoAlies(this.container.getLocale(), destBoAlies);
    }

    public void setBoAlies(Locale locale, String destDesc) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destDesc == null) {
            throw new IllegalArgumentException();
        }
        if (this.getBoAliesResource() == null) {
            this.setBoAlies(new Resource(this.boAlies, this.id, locale, destDesc));
        } else {
            this.getBoAliesResource().setValue(locale, destDesc);
        }
    }

    public void setBoAlies(Resource destDesc) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(this.boAlies + this.id, destDesc);
    }

    public void setBoId(String string) {
        this.boId = string;
    }

    public void setBoName(String string) {
        this.boName = string;
    }

    public void setPropertyAlies(String destPropertyAlies) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.setPropertyAlies(this.container.getLocale(), destPropertyAlies);
    }

    public void setPropertyAlies(Locale locale, String destDesc) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destDesc == null) {
            throw new IllegalArgumentException();
        }
        if (this.getPropertyAliesResource() == null) {
            this.setPropertyAlies(new Resource(this.propertyAlies, this.id, locale, destDesc));
        } else {
            this.getPropertyAliesResource().setValue(locale, destDesc);
        }
    }

    public void setPropertyAlies(Resource destDesc) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(this.propertyAlies + this.id, destDesc);
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public DataFieldDef getDataField(ProcessDef process) {
        if (process == null) {
            throw new IllegalArgumentException("process is null");
        }
        if (this.id != null && this.id.length() > 0 && process.getDataFields() != null) {
            return process.getDataFields().get(this.id);
        }
        return null;
    }

    public void setDataField(ProcessDef process, DataFieldDef dataField) throws WfException {
        if (process == null || dataField == null || dataField.getID() == null) {
            throw new IllegalArgumentException();
        }
        if (process.getDataFields() == null || !process.getDataFields().containsKey(dataField.getID())) {
            // empty if block
        }
        this.dataType = dataField.getDataType();
        this.id = dataField.getID();
    }

    public int check() {
        return 0;
    }

    @Override
    public Element toElement() {
        Element formalParameterElement = new Element("FormalParameter", DefinitionConstants.NS_INSTANCE_KPDL);
        formalParameterElement.setAttribute("Id", this.id);
        formalParameterElement.setAttribute("Index", String.valueOf(this.index));
        formalParameterElement.setAttribute("Mode", this.mode.getName());
        formalParameterElement.setAttribute("Name", this.name);
        formalParameterElement.setAttribute("IsDefault", String.valueOf(this.isDefault));
        formalParameterElement.setAttribute("entityType", this.entityType == null ? "" : this.entityType);
        formalParameterElement.setAttribute("descriptInfoId", this.descriptInfoId);
        if (!StringUtils.isEmpty((String)this.type)) {
            formalParameterElement.setAttribute("Type", this.type);
        }
        if (this.dataType != null) {
            formalParameterElement.addContent((Content)this.dataType.toElement());
        }
        Element descriptionElement = new Element("Description", DefinitionConstants.NS_INSTANCE_KPDL);
        descriptionElement.setText(this.description);
        formalParameterElement.addContent((Content)descriptionElement);
        if (this.boId != null && this.boId.length() > 0) {
            Element refBoInfoElement = new Element("RefBOPropertyInfo", DefinitionConstants.NS_INSTANCE_KPDL);
            refBoInfoElement.setAttribute("BoId", this.boId);
            refBoInfoElement.setAttribute("BoName", this.boName);
            refBoInfoElement.setAttribute("BoAlies", this.boAlies);
            refBoInfoElement.setAttribute("PropertyName", this.propertyName);
            refBoInfoElement.setAttribute("PropertyAlies", this.propertyAlies);
            refBoInfoElement.setAttribute("PropertyIsDynamic", this.propertyIsDynamic);
            formalParameterElement.addContent((Content)refBoInfoElement);
        }
        if (this.resources != null) {
            formalParameterElement.addContent((Content)this.resources.toElement());
        }
        return formalParameterElement;
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    @Override
    protected IKpdlElement innerParse(Element destFormalParameterElement) throws WfKpdlParseException {
        Element resourcesElement;
        if (destFormalParameterElement == null) {
            throw new IllegalArgumentException("element");
        }
        this.id = XmlUtil.readStringAttr(destFormalParameterElement, "Id");
        if (XmlUtil.readStringAttr(destFormalParameterElement, "descriptInfoId") != null) {
            this.descriptInfoId = XmlUtil.readStringAttr(destFormalParameterElement, "descriptInfoId");
        }
        String indexStr = destFormalParameterElement.getAttributeValue("Index");
        this.index = Integer.parseInt(indexStr);
        this.mode = FormalParameterMode.getEnum(destFormalParameterElement.getAttributeValue("Mode"));
        this.name = XmlUtil.readStringAttr(destFormalParameterElement, "Name");
        this.entityType = XmlUtil.readStringAttr(destFormalParameterElement, "entityType");
        this.isDefault = Boolean.valueOf(destFormalParameterElement.getAttributeValue("IsDefault"));
        Element tempElement = destFormalParameterElement.getChild("DataType", DefinitionConstants.NS_INSTANCE_KPDL);
        if (tempElement != null) {
            this.dataType = DataTypeUtils.readDataType(tempElement, DefinitionConstants.NS_INSTANCE_KPDL);
        }
        this.type = XmlUtil.readStringAttr(destFormalParameterElement, "Type");
        Element refBoInfoElement = destFormalParameterElement.getChild("RefBOPropertyInfo", DefinitionConstants.NS_INSTANCE_KPDL);
        if (refBoInfoElement != null) {
            this.boId = XmlUtil.readStringAttr(refBoInfoElement, "BoId");
            this.boName = XmlUtil.readStringAttr(refBoInfoElement, "BoName");
            this.propertyName = XmlUtil.readStringAttr(refBoInfoElement, "PropertyName");
            String isDynamic = XmlUtil.readStringAttr(refBoInfoElement, "PropertyIsDynamic");
            if (!StringUtils.isEmpty((String)isDynamic)) {
                this.propertyIsDynamic = isDynamic;
            }
        }
        if ((resourcesElement = destFormalParameterElement.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.resources = new ResourceCollection(this, resourcesElement);
        }
        return this;
    }

    public boolean isRelevantObjectOutput() {
        return "relevantObject".equals(this.type) && FormalParameterMode.OUT.equals((Object)this.mode);
    }
}

