/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.JavaMethodUtil;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.Uuid;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public class JavaMethodDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -3429251043281310565L;
    private static final String BOSTYPE = "METHODEF";
    private static final String NAME = "JAVA_METHOD";
    private String id;
    private String className;
    private String methodName;
    private String parameterTypes;
    private String returnType;
    private boolean isStatic;

    public JavaMethodDef(AbstractKpdlElement container) {
        block4: {
            this.isStatic = false;
            this.id = Uuid.create().toString() + BOSTYPE;
            this.setContainer(container);
            if (this.container != null) {
                try {
                    if (this.getNameResource() == null) {
                        this.setName(new Resource(NAME, this.id, "JavaMethod"));
                    }
                }
                catch (WfException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"JavaMethodDef.new() error", (Throwable)((Object)e));
                }
            }
        }
    }

    public JavaMethodDef() {
        this.isStatic = false;
        this.id = Uuid.create().toString() + BOSTYPE;
    }

    public JavaMethodDef(AbstractKpdlElement container, Element destScriptElement) throws WfKpdlParseException {
        this(container);
        this.parse(destScriptElement);
    }

    public JavaMethodDef(Element destScriptElement) throws WfKpdlParseException {
        this();
        this.parse(destScriptElement);
    }

    public int check() {
        return 0;
    }

    @Override
    public Element toElement() {
        Element javaMethodElement = new Element("JavaMethod", DefinitionConstants.NS_INSTANCE_KPDL);
        javaMethodElement.setAttribute("Id", this.id);
        javaMethodElement.setAttribute("className", this.className);
        javaMethodElement.setAttribute("methodName", this.methodName);
        javaMethodElement.setAttribute("parameterTypes", this.parameterTypes);
        javaMethodElement.setAttribute("returnType", this.returnType);
        javaMethodElement.setAttribute("static", String.valueOf(this.isStatic));
        if (this.resources != null) {
            javaMethodElement.addContent((Content)this.resources.toElement());
        }
        return javaMethodElement;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    @Override
    protected IKpdlElement innerParse(Element destScriptElement) throws WfKpdlParseException {
        if (destScriptElement == null) {
            throw new IllegalArgumentException();
        }
        this.id = XmlUtil.readStringAttr(destScriptElement, "Id");
        this.className = XmlUtil.readStringAttr(destScriptElement, "className");
        this.methodName = XmlUtil.readStringAttr(destScriptElement, "methodName");
        this.parameterTypes = XmlUtil.readStringAttr(destScriptElement, "parameterTypes");
        this.returnType = XmlUtil.readStringAttr(destScriptElement, "returnType");
        String tmp = XmlUtil.readStringAttr(destScriptElement, "static");
        this.isStatic = Boolean.valueOf(tmp);
        Element resourcesElement = destScriptElement.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL);
        if (resourcesElement != null) {
            this.resources = new ResourceCollection(this, resourcesElement);
        }
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Class[] getParameterTypesClassArray() {
        return JavaMethodUtil.string2ClassArray(this.parameterTypes);
    }

    public String getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(String parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public void setParameterTypes(Class[] parameterTypes) {
        this.parameterTypes = JavaMethodUtil.classArray2String(parameterTypes);
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getName() {
        return this.getName(this.container.getLocale());
    }

    public Resource getNameResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(NAME + this.id);
    }

    public String getName(Locale locale) {
        if (this.getNameResource() == null) {
            return null;
        }
        return this.getNameResource().getValue(locale);
    }

    public void setName(String destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.setName(this.container.getLocale(), destName);
    }

    public void setName(Locale locale, String destName) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destName == null) {
            throw new IllegalArgumentException();
        }
        if (this.getNameResource() == null) {
            this.setName(new Resource(NAME, this.id, locale, destName));
        } else {
            this.getNameResource().setValue(locale, destName);
        }
    }

    public void setName(Resource destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(NAME + this.id, destName);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }
}

