/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.util.md5;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ApplicationType;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.EventPolicyCollection;
import com.kingdee.bos.workflow.define.EventPolicyDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ExternalType;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.JoinType;
import com.kingdee.bos.workflow.define.KPDLSAXHandler;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.SendMessage;
import com.kingdee.bos.workflow.define.SplitType;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.define.diagram.ActivityNode;
import com.kingdee.bos.workflow.define.diagram.Coordinate;
import com.kingdee.bos.workflow.define.diagram.Line;
import com.kingdee.bos.workflow.define.diagram.NodeType;
import com.kingdee.bos.workflow.util.CollectionBase;
import com.kingdee.bos.workflow.util.TypeUtil;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.EntityResolver;

public final class KpdlParser {
    public static final String JOB_RESPONSIBLES = "$Responsibles$";
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.define.KpdlParser");

    public static ProcessDef parseKpdlDocFromPath(String kpdlFilePath) throws WfKpdlParseException, WfException {
        return KpdlParser.parseKpdlDocFromPath(kpdlFilePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessDef parseKpdlDocFromPath(String kpdlFilePath, boolean isReadOnly) throws WfKpdlParseException, WfException {
        if (kpdlFilePath == null || kpdlFilePath.length() == 0) {
            throw new IllegalArgumentException();
        }
        String kpdlStr = "";
        File file = null;
        FileInputStream fileStream = null;
        try {
            file = new File(kpdlFilePath);
            byte[] buffer = new byte[(int)file.length()];
            fileStream = new FileInputStream(file);
            fileStream.read(buffer);
            kpdlStr = new String(buffer, "UTF-8");
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"KpdlParser.parseKpdlDocFromPath error", (Throwable)e);
            }
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (IOException e1) {
                log.error((Object)e1);
            }
        }
        return KpdlParser.parseKpdl(kpdlStr, isReadOnly);
    }

    public static ProcessDef parseKpdl(String text) throws WfKpdlParseException, WfException {
        return KpdlParser.parseKpdl(text, false);
    }

    public static ProcessDef parseKpdl(String text, Locale locale) throws WfKpdlParseException, WfException {
        return KpdlParser.parseKpdl(text, locale, false);
    }

    public static ProcessDef parseKpdl(String text, boolean isReadOnly) throws WfKpdlParseException, WfException {
        return KpdlParser.parseKpdl(text, Locale.getDefault(), isReadOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessDef parseKpdl(String originalString, Locale locale, boolean isReadOnly) throws WfKpdlParseException, WfException {
        ByteArrayInputStream inputStream;
        if (originalString == null || originalString.length() == 0) {
            originalString = new ProcessDef().toXml();
        }
        md5 md = new md5(originalString);
        md.processString();
        String hashValue = md.getStringDigest();
        try {
            inputStream = new ByteArrayInputStream(originalString.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new WfKpdlParseException("UnsupportedEncodingException", ex);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        ProcessDef procDef = null;
        try {
            Document doc;
            Thread.currentThread().setContextClassLoader(JDOMFactory.class.getClassLoader());
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            KPDLSAXHandler kpdlSaxHandler = new KPDLSAXHandler();
            builder.setEntityResolver((EntityResolver)kpdlSaxHandler);
            try {
                doc = inputStream.available() == 0 ? null : builder.build((InputStream)inputStream);
            }
            catch (JDOMException ex) {
                throw new WfKpdlParseException("JDOMException", ex);
            }
            catch (IOException ex) {
                throw new WfKpdlParseException("IOException", ex);
            }
            log.debug((Object)("PROCESS HASH VALUE : " + hashValue + "  LENGHT IS : " + hashValue.length()));
            procDef = KpdlParser.parseKpdlDoc(doc, hashValue, originalString, isReadOnly);
            procDef.setLocale(locale);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        return procDef;
    }

    public static ProcessDef parseKpdlDoc(Document doc) throws WfKpdlParseException, WfException {
        if (doc == null) {
            throw new IllegalArgumentException("doc");
        }
        Element destElement = doc.getRootElement();
        return KpdlParser.parseProcess(destElement);
    }

    public static ProcessDef parseKpdlDoc(Document doc, String hashValue, String originalString, boolean isReadOnly) throws WfKpdlParseException, WfException {
        if (doc == null) {
            throw new IllegalArgumentException("doc");
        }
        Element destElement = doc.getRootElement();
        return KpdlParser.parseProcess(destElement, hashValue, originalString, isReadOnly);
    }

    public static ProcessDef parseProcess(Element destElement) throws WfKpdlParseException, WfException {
        return KpdlParser.parseProcess(destElement, new ProcessDef());
    }

    public static ProcessDef parseProcess(Element destElement, String hashValue, String originalString, boolean isReadOnly) throws WfKpdlParseException, WfException {
        return KpdlParser.parseProcess(destElement, new ProcessDef(hashValue, originalString, isReadOnly));
    }

    public static ProcessDef parseProcess(Element destElement, ProcessDef process) throws WfKpdlParseException, WfException {
        return (ProcessDef)process.parse(destElement);
    }

    public static ProcessDef toPerfectModelProcess(ProcessDef process) throws WfException {
        if (process == null || process.getActivitys() == null || process.getActivitys().size() == 0 || process.getTransitions() == null || process.getTransitions().size() == 0) {
            throw new WfException("Activities or Transitions is null!");
        }
        CollectionBase tempActivities = (CollectionBase)process.getActivitys().clone();
        for (int i = 0; i < tempActivities.size(); ++i) {
            ActivityDef tempActivity = (ActivityDef)tempActivities.getObject(i);
            TransitionCollection incomingTransitions = tempActivity.getIncomingTransitions();
            TransitionCollection outgoingTransitions = tempActivity.getOutgoingTransitions();
            if (incomingTransitions != null && incomingTransitions.size() > 2) {
                KpdlParser.addVirtualPreRouterActivity(tempActivity, process);
            }
            if (outgoingTransitions == null || outgoingTransitions.size() <= 2) continue;
            KpdlParser.addVirtualPostRouterActivity(tempActivity, process);
        }
        return process;
    }

    private static void addVirtualPostRouterActivity(ActivityDef activity, ProcessDef process) throws WfException {
        int count = activity.getOutgoingTransitions().size();
        try {
            do {
                TransitionDef tran1 = activity.getOutgoingTransitions().get(1);
                TransitionDef tran2 = activity.getOutgoingTransitions().get(2);
                Line newLine = new Line(process.getDiagram());
                ActivityNode routerNode = new ActivityNode(process.getDiagram(), NodeType.ROUTER);
                int x = activity.getRelatedNode().getCoordinate().x + 50 + 1 / count * 100;
                int y = activity.getRelatedNode().getCoordinate().y + 50 + 1 / count * 100;
                routerNode.setCoordinate(new Coordinate(x, y));
                if (activity.activityHeader.getSplitType().equals((Object)SplitType.AND)) {
                    routerNode.getRefActivity().activityHeader.setSplitType(SplitType.AND);
                    routerNode.getRefActivity().activityHeader.setJoinType(JoinType.AND);
                } else if (activity.activityHeader.getSplitType().equals((Object)SplitType.OR)) {
                    routerNode.getRefActivity().activityHeader.setSplitType(SplitType.OR);
                    routerNode.getRefActivity().activityHeader.setJoinType(JoinType.OR);
                } else {
                    routerNode.getRefActivity().activityHeader.setSplitType(SplitType.XOR);
                    routerNode.getRefActivity().activityHeader.setJoinType(JoinType.XOR);
                }
                tran1.setFrom(routerNode.getRefActivity());
                tran2.setFrom(routerNode.getRefActivity());
                newLine.getRefTransition().setFrom(activity);
                newLine.getRefTransition().setTo(routerNode.getRefActivity());
                process.getTransitions().set(tran1.getID(), tran1);
                process.getTransitions().set(tran2.getID(), tran2);
            } while (--count > 2);
        }
        catch (Exception e) {
            log.error((Object)("addVirtualPostRouterActivity" + e.getMessage()));
        }
    }

    private static void addVirtualPreRouterActivity(ActivityDef activity, ProcessDef process) throws WfException {
        int count = activity.getIncomingTransitions().size();
        try {
            do {
                TransitionDef tran1 = activity.getIncomingTransitions().get(1);
                TransitionDef tran2 = activity.getIncomingTransitions().get(2);
                Line newLine = new Line(process.getDiagram());
                ActivityNode routerNode = new ActivityNode(process.getDiagram(), NodeType.ROUTER);
                int x = activity.getRelatedNode().getCoordinate().x - 50 - 1 / count * 100;
                int y = activity.getRelatedNode().getCoordinate().y - 50 - 1 / count * 100;
                routerNode.setCoordinate(new Coordinate(x, y));
                if (activity.activityHeader.getJoinType().equals((Object)JoinType.AND)) {
                    routerNode.getRefActivity().activityHeader.setSplitType(SplitType.AND);
                    routerNode.getRefActivity().activityHeader.setJoinType(JoinType.AND);
                } else if (activity.activityHeader.getJoinType().equals((Object)JoinType.OR)) {
                    routerNode.getRefActivity().activityHeader.setSplitType(SplitType.OR);
                    routerNode.getRefActivity().activityHeader.setJoinType(JoinType.OR);
                } else {
                    routerNode.getRefActivity().activityHeader.setSplitType(SplitType.XOR);
                    routerNode.getRefActivity().activityHeader.setJoinType(JoinType.XOR);
                }
                tran1.setTo(routerNode.getRefActivity());
                tran2.setTo(routerNode.getRefActivity());
                newLine.getRefTransition().setTo(activity);
                newLine.getRefTransition().setFrom(routerNode.getRefActivity());
                process.getTransitions().set(tran1.getID(), tran1);
                process.getTransitions().set(tran2.getID(), tran2);
            } while (--count > 2);
        }
        catch (Exception e) {
            log.error((Object)("addVirtualPreRouterActivity" + e.getMessage()));
        }
    }

    public static List getAllPossiblyPath(ProcessDef process) throws WfException {
        if (process == null || process.getActivitys() == null || process.getActivitys().size() == 0) {
            return null;
        }
        ArrayList allPath = new ArrayList();
        ActivityCollection activities = (ActivityCollection)process.getActivitys().clone();
        Hashtable cycCount = new Hashtable();
        for (int depth = process.getActivitys().size() * process.getActivitys().size(); depth > 0; --depth) {
            ArrayList path = new ArrayList();
            KpdlParser.addPostActivityIndexToPath(process.getStartActivity(), path, allPath, activities, cycCount);
            if (path.size() <= 1 || allPath.contains(path)) continue;
            allPath.add(path);
        }
        return allPath;
    }

    private static boolean addPostActivityIndexToPath(ActivityDef activity, List path, List allPath, ActivityCollection activities, Hashtable cycCount) throws WfException {
        if (activities == null || activity == null) {
            throw new WfException("activities or activity is null.");
        }
        String index = String.valueOf(activities.indexOfKey(activity.getID()));
        if (path.contains(index) || KpdlParser.hasContainsPath(index, path, allPath)) {
            return false;
        }
        path.add(index);
        ActivityCollection postActivities = activity.getPostActivities();
        if (postActivities != null && postActivities.size() > 0) {
            int postActCount = postActivities.size();
            int currentIndex = 0;
            if (postActCount > 1) {
                if (cycCount.containsKey(activity.getID())) {
                    currentIndex = (Integer)cycCount.get(activity.getID()) + 1;
                    if (postActCount < currentIndex + 1) {
                        currentIndex = 0;
                    }
                } else {
                    currentIndex = 0;
                }
                cycCount.put(activity.getID(), new Integer(currentIndex));
            }
            return KpdlParser.addPostActivityIndexToPath(postActivities.get(currentIndex), path, allPath, activities, cycCount);
        }
        return true;
    }

    private static boolean hasContainsPath(String activityIndex, List path, List allPath) {
        if (activityIndex == null || activityIndex.length() == 0 || path == null || path.size() == 0 || allPath == null) {
            return false;
        }
        for (int i = 0; i < allPath.size(); ++i) {
            if (KpdlParser.listToString((List)allPath.get(i)).indexOf(KpdlParser.listToString(path) + activityIndex) <= 0) continue;
            return true;
        }
        return false;
    }

    private static String listToString(List list) {
        StringBuffer outStr = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            outStr.append(list.get(i).toString());
        }
        return outStr.toString();
    }

    public static String[][] pathToConjugateMode(List path, ProcessDef process) throws WfException {
        String[][] conjugateList = null;
        if (path == null || path.size() == 0 || process == null || process.getActivitys() == null || process.getActivitys().size() == 0) {
            return conjugateList;
        }
        conjugateList = new String[path.size() * 2][3];
        for (int i = 0; i < path.size(); ++i) {
            ActivityDef activity = process.getActivitys().get(Integer.parseInt(path.get(i).toString()));
            if (activity == null) {
                throw new WfException("activity is null");
            }
            conjugateList[i * 2][0] = activity.getActivityHeader().getJoinType().getName() + ".Join";
            conjugateList[i * 2][1] = path.get(i).toString();
            conjugateList[i * 2 + 1][0] = activity.getActivityHeader().getSplitType().getName() + ".Split";
            conjugateList[i * 2 + 1][1] = path.get(i).toString();
        }
        return conjugateList;
    }

    public static ProcessDef createProcess(Locale locale) throws WfKpdlParseException {
        return new ProcessDef(locale);
    }

    public static ProcessDef createJobProcess(String processName, FunctionObjectInfo function, OperationInfo operation, Map jobContext, String schedule, Locale locale) throws WfException {
        ProcessDef jobProcess = KpdlParser.createProcess(locale);
        try {
            jobProcess.setName(locale, processName);
        }
        catch (WfException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
        }
        Date validto = new Date();
        Date validfrom = new Date();
        jobProcess.getProcessHeader().setValidFrom(validto);
        validfrom.setYear(validto.getYear() + 50);
        jobProcess.getProcessHeader().setValidTo(validfrom);
        jobProcess.setType(ProcessType.BACKGROUNDJOB);
        ScheduleDef scheduale = new ScheduleDef(jobProcess, XmlUtil.stringToElement(schedule));
        jobProcess.getProcessHeader().setScheduale(scheduale);
        FunctionDef func = new FunctionDef();
        FormalParameterCollection formalParams = new FormalParameterCollection(jobProcess);
        ActualParameterCollection actualParams = new ActualParameterCollection(jobProcess);
        if (function != null && operation != null) {
            ParameterCollection parameters;
            MethodInfo method = null;
            String boName = null;
            String boId = null;
            if (operation.getUiActionRef() != null && operation.getUiActionRef().getUIObjectRef() != null) {
                throw new WfException("Job process cann't bind UI function");
            }
            if (operation.getFacadeObjectRef() != null) {
                method = operation.getMethodRef();
                boName = operation.getFacadeObjectRef().getName();
                boId = operation.getFacadeObjectRef().getType().toString();
            } else if (operation.getEntityObjectRef() != null) {
                method = operation.getMethodRef();
                boName = operation.getEntityObjectRef().getName();
                boId = operation.getEntityObjectRef().getType().toString();
            }
            func.setName(function.getName());
            func.setOperation(operation.getName());
            func.setPackageName(function.getPackage());
            if (method != null && (parameters = method.getParameters()) != null) {
                DataFieldDef df = null;
                FormalParameterDef formalParam = null;
                ActualParameterDef actualParam = null;
                for (int i = 0; i < parameters.size(); ++i) {
                    formalParam = new FormalParameterDef(jobProcess);
                    actualParam = new ActualParameterDef(jobProcess);
                    DataType dataType = TypeUtil.convertTypeReferenceToDataType(parameters.get(i).getDataType());
                    df = new DataFieldDef(jobProcess);
                    df.setName(parameters.get(i).getName());
                    df.setDataType(dataType);
                    if (jobContext != null && jobContext.containsKey(df.getName())) {
                        df.setInitValue(jobContext.get(df.getName()) != null ? jobContext.get(df.getName()).toString() : "");
                    }
                    jobProcess.addDataFieldDef(df);
                    formalParam.setIndex(i);
                    formalParam.setDataField(jobProcess, df);
                    formalParam.setDataType(dataType);
                    formalParam.setMode(FormalParameterMode.IN);
                    formalParam.setBoName(boName);
                    formalParam.setBoId(boId);
                    formalParam.setName(df.getName());
                    formalParams.add(formalParam.getID(), formalParam);
                    actualParam.setIndex(i);
                    actualParam.setExpr(formalParam.getID());
                    actualParams.add(actualParam);
                }
            }
        } else {
            func.setName(function != null ? function.getName() : "");
            func.setOperation(operation != null ? operation.getName() : "");
        }
        ApplicationDef application = new ApplicationDef(jobProcess);
        application.setFunction(func);
        application.setType(ApplicationType.TOOL);
        application.setFormalParameters(formalParams);
        ActivityNode startNode = new ActivityNode(jobProcess.getDiagram(), NodeType.STARTACTIVITY);
        ActivityNode endNode = new ActivityNode(jobProcess.getDiagram(), NodeType.ENDACTIVITY);
        ActivityNode toolNode = new ActivityNode(jobProcess.getDiagram(), NodeType.TOOL);
        ((ToolActivityDef)toolNode.getRefActivity()).setRelatedApplication(application);
        ((ToolActivityDef)toolNode.getRefActivity()).setActualParameters(actualParams);
        ToolActivityDef toolDef = (ToolActivityDef)toolNode.getRefActivity();
        ExtendedAttributeDef ead = new ExtendedAttributeDef();
        ead.setName("autoErrorSend");
        ead.setValue("true");
        toolDef.getActivityHeader().getExtendedAttributes().addObject(ead);
        Line line1 = new Line(jobProcess.getDiagram());
        Line line2 = new Line(jobProcess.getDiagram());
        line1.getRefTransition().setFrom(startNode.getRefActivity());
        line1.getRefTransition().setTo(toolNode.getRefActivity());
        line2.getRefTransition().setFrom(toolNode.getRefActivity());
        line2.getRefTransition().setTo(endNode.getRefActivity());
        if (jobContext != null) {
            Object isFireLastMissedJob;
            Object sendMessage;
            Object nonMutexCtrl;
            Object isRetainTime;
            ExtendedAttributeDef extendedAttributeDef1;
            Object selectedServer;
            Object tmp = jobContext.get(JOB_RESPONSIBLES);
            if (tmp instanceof String[]) {
                String[] persons = (String[])tmp;
                EventPolicyCollection events = jobProcess.getProcessHeader().getEventPolicies();
                EventPolicyDef event = new EventPolicyDef();
                event.setEventType("PROCESS_SUSPENDED");
                event.setEventAction(7);
                ParticipantCollection participants = new ParticipantCollection();
                event.setParticipants(participants);
                try {
                    events.add(event);
                }
                catch (WfException wfException) {
                    // empty catch block
                }
                for (int i = 0; i < persons.length; ++i) {
                    int j = persons[i].indexOf("|");
                    ParticipantDef part = new ParticipantDef(null);
                    if (j > 0) {
                        part.setParticipantValue(persons[i].substring(0, j));
                        part.setName(persons[i].substring(j + 1));
                    } else {
                        part.setParticipantValue(persons[i]);
                    }
                    part.setParticipantType(ParticipantType.HUMAN);
                    participants.add(part.getID(), part);
                }
            }
            if (jobContext.containsKey("selectedServer") && (selectedServer = jobContext.get("selectedServer")) instanceof String && !StringUtils.isEmpty((String)((String)selectedServer))) {
                extendedAttributeDef1 = new ExtendedAttributeDef();
                extendedAttributeDef1.setName("selectedServer");
                extendedAttributeDef1.setValue((String)selectedServer);
                jobProcess.getExtendedAttributes().setObject("selectedServer", (Object)extendedAttributeDef1);
            }
            if (jobContext.containsKey("isRetainTime") && ((isRetainTime = jobContext.get("isRetainTime")) instanceof String && "true".equals(isRetainTime) || Boolean.TRUE.equals(isRetainTime))) {
                extendedAttributeDef1 = new ExtendedAttributeDef();
                extendedAttributeDef1.setName("isRetainTime");
                extendedAttributeDef1.setValue("true");
                jobProcess.getExtendedAttributes().setObject("isRetainTime", (Object)extendedAttributeDef1);
            }
            if (jobContext.containsKey("nonMutexCtrl") && ((nonMutexCtrl = jobContext.get("nonMutexCtrl")) instanceof String && "true".equals(nonMutexCtrl) || Boolean.TRUE.equals(nonMutexCtrl))) {
                extendedAttributeDef1 = new ExtendedAttributeDef();
                extendedAttributeDef1.setName("nonMutexCtrl");
                extendedAttributeDef1.setValue("true");
                jobProcess.getExtendedAttributes().setObject("nonMutexCtrl", (Object)extendedAttributeDef1);
            }
            if (jobContext.containsKey("sendMessage") && (sendMessage = jobContext.get("sendMessage")) != null && sendMessage instanceof SendMessage) {
                KpdlParser.setMessageExtended(jobProcess, (SendMessage)sendMessage);
            }
            if (jobContext.containsKey("isFireLastMissedJob") && ((isFireLastMissedJob = jobContext.get("isFireLastMissedJob")) instanceof String && "false".equals(isFireLastMissedJob) || Boolean.FALSE.equals(isFireLastMissedJob))) {
                extendedAttributeDef1 = new ExtendedAttributeDef();
                extendedAttributeDef1.setName("isFireLastMissedJob");
                extendedAttributeDef1.setValue("false");
                jobProcess.getExtendedAttributes().setObject("isFireLastMissedJob", (Object)extendedAttributeDef1);
            }
        }
        return jobProcess;
    }

    private static void setMessageExtended(ProcessDef jobProcess, SendMessage sendMessage) {
        KpdlParser.setExtendedDef(jobProcess, "sendSMS", String.valueOf(sendMessage.isSendSMS()));
        KpdlParser.setExtendedDef(jobProcess, "sendMail", String.valueOf(sendMessage.isSendMail()));
        KpdlParser.setExtendedDef(jobProcess, "failureNotice", String.valueOf(sendMessage.isFailureNotice()));
        KpdlParser.setExtendedDef(jobProcess, "completeNotice", String.valueOf(sendMessage.isCompleteNotice()));
        KpdlParser.setExtendedDef(jobProcess, "abortNotice", String.valueOf(sendMessage.isAbortNotice()));
        KpdlParser.setExtendedDef(jobProcess, "slowNotice", String.valueOf(sendMessage.isSlowNotice()));
        KpdlParser.setExtendedDef(jobProcess, "overtimeNotice", String.valueOf(sendMessage.isOvertimeNotice()));
        KpdlParser.setExtendedDef(jobProcess, "runTimeout", String.valueOf(sendMessage.getRunTimeout()));
        KpdlParser.setExtendedDef(jobProcess, "noticeTitle_L1", sendMessage.getNoticeTitle_L1());
        KpdlParser.setExtendedDef(jobProcess, "noticeTitle_L2", sendMessage.getNoticeTitle_L2());
        KpdlParser.setExtendedDef(jobProcess, "noticeTitle_L3", sendMessage.getNoticeTitle_L3());
        KpdlParser.setExtendedDef(jobProcess, "noticeContent_L1", sendMessage.getNoticeContent_L1());
        KpdlParser.setExtendedDef(jobProcess, "noticeContent_L2", sendMessage.getNoticeContent_L2());
        KpdlParser.setExtendedDef(jobProcess, "noticeContent_L3", sendMessage.getNoticeContent_L3());
    }

    private static void setExtendedDef(ProcessDef jobProcess, String name, String value) {
        ExtendedAttributeDef extendedAttributeDef = new ExtendedAttributeDef();
        extendedAttributeDef.setName(name);
        extendedAttributeDef.setValue(value);
        jobProcess.getExtendedAttributes().setObject(name, (Object)extendedAttributeDef);
    }

    public static DataType convertDataType(String dataType) {
        DataType dt = null;
        try {
            dt = BasicType.parse(dataType);
        }
        catch (IllegalArgumentException e) {
            dt = ExternalType.OBJECT;
        }
        return dt;
    }

    public static ScheduleDef parseSchedule(String schedule) throws WfKpdlParseException {
        if (schedule == null || schedule.length() == 0) {
            return null;
        }
        return new ScheduleDef(null, XmlUtil.stringToElement(schedule));
    }

    public static String scheduleToString(ScheduleDef scheduleDef) {
        if (scheduleDef == null) {
            return "";
        }
        Element elment = scheduleDef.toElement();
        return XmlUtil.elementToString(elment);
    }

    public static String getScheduleXml(String kpdl) throws WfKpdlParseException, WfException {
        String scheduleXml = null;
        ProcessDef procDef = KpdlParser.parseKpdl(kpdl);
        ScheduleDef schedule = procDef.getProcessHeader().getScheduale();
        if (schedule != null) {
            scheduleXml = KpdlParser.scheduleToString(schedule);
        }
        return scheduleXml;
    }
}

