/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.DurationUnit;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import java.math.BigDecimal;
import org.jdom2.Content;
import org.jdom2.Element;

public class LimitDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -8062891539232718788L;
    private int waitingTime = 0;
    private int workingTime = 0;
    private int duration = 0;
    private int elapsedTime = 0;
    private DurationUnit durationUnit = DurationUnit.HOUR;
    private BigDecimal deadlineTime;
    private String orgId;
    private String orgName;

    public LimitDef() {
    }

    public LimitDef(Element destLimitElement) throws WfKpdlParseException {
        this();
        this.parse(destLimitElement);
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public BigDecimal getDeadlineTime() {
        return this.deadlineTime;
    }

    public void setDeadlineTime(BigDecimal deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public int getWaitingTime() {
        return this.waitingTime;
    }

    public void setWaitingTime(int destWaitingTime) {
        this.waitingTime = destWaitingTime;
    }

    public int getWorkingTime() {
        return this.workingTime;
    }

    public void setWorkingTime(int destWorkingTime) {
        this.workingTime = destWorkingTime;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int destDuration) {
        this.duration = destDuration;
    }

    public int getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(int destElapsedTime) {
        this.elapsedTime = destElapsedTime;
    }

    public DurationUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(DurationUnit destDurationUnit) {
        this.durationUnit = destDurationUnit;
    }

    @Override
    public Element toElement() {
        Element limitElement = new Element("Limit", DefinitionConstants.NS_INSTANCE_KPDL);
        limitElement.setAttribute("DurationUnit", this.durationUnit.getName());
        limitElement.setAttribute("deadlineTime", String.valueOf(this.deadlineTime));
        limitElement.setAttribute("orgId", this.orgId == null ? "" : this.orgId);
        limitElement.setAttribute("orgName", this.orgName == null ? "" : this.orgName);
        Element waitingTimeElement = new Element("WaitingTime", DefinitionConstants.NS_INSTANCE_KPDL);
        waitingTimeElement.setText(String.valueOf(this.waitingTime));
        limitElement.addContent((Content)waitingTimeElement);
        Element workingTimeElement = new Element("WorkingTime", DefinitionConstants.NS_INSTANCE_KPDL);
        workingTimeElement.setText(String.valueOf(this.workingTime));
        limitElement.addContent((Content)workingTimeElement);
        Element durationElement = new Element("Duration", DefinitionConstants.NS_INSTANCE_KPDL);
        durationElement.setText(String.valueOf(this.duration));
        limitElement.addContent((Content)durationElement);
        Element elapsedTimeElement = new Element("ElapsedTime", DefinitionConstants.NS_INSTANCE_KPDL);
        elapsedTimeElement.setText(String.valueOf(this.elapsedTime));
        limitElement.addContent((Content)elapsedTimeElement);
        return limitElement;
    }

    @Override
    public String getID() {
        throw new RuntimeException("NotSupport");
    }

    @Override
    public String bosType() {
        return null;
    }

    @Override
    protected IKpdlElement innerParse(Element destLimitElement) throws WfKpdlParseException {
        if (destLimitElement == null) {
            throw new IllegalArgumentException();
        }
        this.durationUnit = DurationUnit.getEnum(destLimitElement.getAttributeValue("DurationUnit"));
        this.waitingTime = XmlUtil.readInt(destLimitElement, "WaitingTime", DefinitionConstants.NS_INSTANCE_KPDL);
        this.workingTime = XmlUtil.readInt(destLimitElement, "WorkingTime", DefinitionConstants.NS_INSTANCE_KPDL);
        this.duration = XmlUtil.readInt(destLimitElement, "Duration", DefinitionConstants.NS_INSTANCE_KPDL);
        this.elapsedTime = XmlUtil.readInt(destLimitElement, "ElapsedTime", DefinitionConstants.NS_INSTANCE_KPDL);
        String s = destLimitElement.getAttributeValue("deadlineTime");
        if (s != null && s.length() > 0 && !"null".equals(s)) {
            this.deadlineTime = new BigDecimal(s);
        }
        this.orgId = destLimitElement.getAttributeValue("orgId");
        this.orgName = destLimitElement.getAttributeValue("orgName");
        return this;
    }
}

