/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.PartnerLinkTypeDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import org.jdom2.Element;

public class PartnerLinkRoleDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = 1618945365714337886L;
    private static final String BOS_TYPE = "PLNKRDEF";
    private String id;
    private String name;
    private String nsURIPT;
    private String localPartPT;
    private String nsPrefixPT;

    public PartnerLinkRoleDef(PartnerLinkTypeDef partnerLinkTypeDef) {
        this.container = partnerLinkTypeDef;
        this.id = Uuid.create() + BOS_TYPE;
    }

    public PartnerLinkRoleDef(PartnerLinkTypeDef partnerLinkTypeDef, Element destElement) throws WfKpdlParseException {
        this.container = partnerLinkTypeDef;
        this.parse(destElement);
    }

    @Override
    public String bosType() {
        return BOS_TYPE;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPortTypeNamespaceURI() {
        return this.nsURIPT;
    }

    public String getPortTypeLocalPart() {
        return this.localPartPT;
    }

    public String getPortTypeNamespacePrefix() {
        return this.nsPrefixPT;
    }

    public void setPortTypeNamespacePrefix(String namespacePrefix) {
        this.nsPrefixPT = namespacePrefix;
    }

    public void setPortTypeLocalPart(String localPart) {
        this.localPartPT = localPart;
    }

    public void setPortTypeNamespaceURI(String namespaceURI) {
        this.nsURIPT = namespaceURI;
    }

    @Override
    protected IKpdlElement innerParse(Element destElement) throws WfKpdlParseException {
        this.id = XmlUtil.readStringAttr(destElement, "Id");
        this.name = XmlUtil.readStringAttr(destElement, "Name");
        String strPortType = XmlUtil.readStringAttr(destElement, "PortType");
        String[] strings = StringUtils.split((String)strPortType, (String)":");
        this.nsPrefixPT = strings[0];
        this.localPartPT = strings[1];
        return this;
    }

    @Override
    public Element toElement() {
        Element partnerLinkRoleElement = new Element("PartnerLinkRole", DefinitionConstants.NS_INSTANCE_KPDL);
        partnerLinkRoleElement.setAttribute("Id", this.id);
        partnerLinkRoleElement.setAttribute("Name", this.name);
        partnerLinkRoleElement.setAttribute("PortType", this.nsPrefixPT + ":" + this.localPartPT);
        return partnerLinkRoleElement;
    }
}

