/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.diagram.ActivityNode;
import com.kingdee.bos.workflow.define.diagram.Diagram;
import com.kingdee.bos.workflow.define.diagram.Line;
import com.kingdee.bos.workflow.define.diagram.Node;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;

class ProcessDefCleaner {
    private final ProcessDef processDef;

    ProcessDefCleaner(ProcessDef processDef) {
        this.processDef = processDef;
    }

    void execute() throws WfException {
        this.cleanWastedActivities();
        this.cleanWastedLines();
        this.cleanWastedTransitions();
    }

    private void cleanWastedLines() throws WfException {
        Diagram diagram = this.processDef.getDiagram();
        ArrayList<Line> wastedLines = new ArrayList<Line>();
        if (diagram != null && diagram.getLines() != null) {
            Line line;
            int i;
            int size = diagram.getLines().size();
            for (i = 0; i < size; ++i) {
                line = diagram.getLines().get(i);
                if (line.getRefTransition() != null) continue;
                wastedLines.add(line);
            }
            size = wastedLines.size();
            for (i = 0; i < size; ++i) {
                line = (Line)wastedLines.get(i);
                this.processDef.destoryLine(line);
            }
            wastedLines.clear();
        }
    }

    private void cleanWastedTransitions() throws WfException {
        if (this.processDef.getTransitions() != null) {
            int size = this.processDef.getTransitions().size();
            for (int i = 0; i < size; ++i) {
                TransitionDef transition = this.processDef.getTransitions().get(i);
                if (transition.getRelatedLine() != null && transition.getFrom() != null && transition.getTo() != null) continue;
                this.processDef.destroyTransition(transition.getID());
            }
        }
    }

    private void cleanWastedActivities() throws WfException {
        HashSet<String> activityIDs = new HashSet<String>();
        Diagram diagram = this.processDef.getDiagram();
        if (diagram != null && diagram.getNodes() != null) {
            int size = diagram.getNodes().size();
            for (int i = 0; i < size; ++i) {
                ActivityNode activityNode;
                Node node = diagram.getNodes().get(i);
                if (!(node instanceof ActivityNode) || (activityNode = (ActivityNode)node).getRefActivity() == null) continue;
                activityIDs.add(activityNode.getRefActivity().getID());
            }
        }
        ActivityCollection activityCollection = this.processDef.getActivitys();
        for (int i = activityCollection.size() - 1; i >= 0; --i) {
            ActivityDef activityDef = activityCollection.get(i);
            if (activityIDs.contains(activityDef.getID()) || this.isEventActivityNeed(activityDef)) continue;
            this.processDef.destroyActivity(activityDef.getID());
        }
    }

    private boolean isEventActivityNeed(ActivityDef activityDef) {
        if (activityDef instanceof EventActivityDef) {
            String eventActId = activityDef.getID();
            ActivityCollection manpowerActCol = this.processDef.getActivitys(ActivityType.MANPOWER);
            if (manpowerActCol != null) {
                for (int i = 0; i < manpowerActCol.size(); ++i) {
                    ManpowerActivityDef manpowerActivityDef = (ManpowerActivityDef)manpowerActCol.get(i);
                    String refEventActDefId = manpowerActivityDef.getRefEventActDefId();
                    if (StringUtils.isEmpty((String)refEventActDefId) || !refEventActDefId.equalsIgnoreCase(eventActId)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

